/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.report;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import workbench.db.report.TagAttribute;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.util.HtmlUtil;
import workbench.util.StringUtil;

public class TagWriter {
    public static final String CDATA_START = "<![CDATA[";
    public static final String CDATA_END = "]]>";
    public static final String TAG_GENERATED_BY = "generated-by";
    private static final char[] SPECIAL_CHARS = new char[]{'<', '>', '&', '\n', '\r'};

    public void appendTag(StringBuilder stringBuilder, StringBuilder stringBuilder2, String string, int n) {
        this.appendTag(stringBuilder, stringBuilder2, string, String.valueOf(n), false);
    }

    public void appendTag(StringBuilder stringBuilder, StringBuilder stringBuilder2, String string, boolean bl) {
        if (bl) {
            this.appendTag(stringBuilder, stringBuilder2, string, "true", false);
        } else {
            this.appendTag(stringBuilder, stringBuilder2, string, "false", false);
        }
    }

    public void appendTag(StringBuilder stringBuilder, StringBuilder stringBuilder2, String string, CharSequence charSequence) {
        this.appendTag(stringBuilder, stringBuilder2, string, charSequence, false);
    }

    public void appendTagConditionally(StringBuilder stringBuilder, StringBuilder stringBuilder2, String string, String string2) {
        if (!StringUtil.isEmptyString(string2)) {
            this.appendTag(stringBuilder, stringBuilder2, string, string2, false);
        }
    }

    public void appendTag(StringBuilder stringBuilder, StringBuilder stringBuilder2, String string, CharSequence charSequence, String string2, String string3) {
        this.appendOpenTag(stringBuilder, stringBuilder2, string, string2, string3);
        stringBuilder.append(charSequence == null ? "" : charSequence);
        this.appendCloseTag(stringBuilder, null, string);
    }

    public void appendCDATATag(StringBuilder stringBuilder, StringBuilder stringBuilder2, String string, CharSequence charSequence, String string2, String string3) {
        TagAttribute tagAttribute = new TagAttribute(string2, string3);
        this.appendCDATATag(stringBuilder, stringBuilder2, string, charSequence, tagAttribute);
    }

    public void appendCDATATag(StringBuilder stringBuilder, StringBuilder stringBuilder2, String string, CharSequence charSequence, TagAttribute ... tagAttributeArray) {
        this.appendOpenTag(stringBuilder, stringBuilder2, string, true, tagAttributeArray);
        stringBuilder.append('\n');
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  ");
        stringBuilder.append(CDATA_START);
        stringBuilder.append(charSequence == null ? "" : charSequence);
        stringBuilder.append(CDATA_END);
        stringBuilder.append('\n');
        stringBuilder.append((CharSequence)stringBuilder2);
        this.appendCloseTag(stringBuilder, null, string);
    }

    public void appendTag(StringBuilder stringBuilder, StringBuilder stringBuilder2, String string, CharSequence charSequence, boolean bl) {
        boolean bl2;
        this.appendOpenTag(stringBuilder, stringBuilder2, string);
        boolean bl3 = bl2 = bl && TagWriter.needsCData(charSequence);
        if (bl2) {
            stringBuilder.append(CDATA_START);
            stringBuilder.append(charSequence == null ? "" : charSequence);
        } else {
            stringBuilder.append(HtmlUtil.escapeXML(charSequence));
        }
        if (bl2) {
            stringBuilder.append(CDATA_END);
        }
        this.appendCloseTag(stringBuilder, null, string);
    }

    public void appendEmptyTag(StringBuilder stringBuilder, StringBuilder stringBuilder2, String string, String string2, String string3) {
        this.appendOpenTag(stringBuilder, stringBuilder2, string, false, new TagAttribute(string2, string3));
        stringBuilder.append("/>");
    }

    public void appendOpenTag(StringBuilder stringBuilder, StringBuilder stringBuilder2, String string) {
        this.appendOpenTag(stringBuilder, stringBuilder2, string, null, true);
    }

    public void appendOpenTag(StringBuilder stringBuilder, StringBuilder stringBuilder2, String string, String string2, String string3) {
        if (StringUtil.isNonBlank(string2)) {
            this.appendOpenTag(stringBuilder, stringBuilder2, string, true, new TagAttribute(string2, string3));
        } else {
            this.appendOpenTag(stringBuilder, stringBuilder2, string, true, new TagAttribute[0]);
        }
    }

    public void appendOpenTag(StringBuilder stringBuilder, StringBuilder stringBuilder2, String string, String[] stringArray, String[] stringArray2) {
        this.appendOpenTag(stringBuilder, stringBuilder2, string, stringArray, stringArray2, true);
    }

    public void appendOpenTag(StringBuilder stringBuilder, StringBuilder stringBuilder2, String string, String[] stringArray, String[] stringArray2, boolean bl) {
        ArrayList<TagAttribute> arrayList = null;
        if (stringArray != null && stringArray2 != null && stringArray.length == stringArray2.length) {
            arrayList = new ArrayList<TagAttribute>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(new TagAttribute(stringArray[i], stringArray2[i]));
            }
        } else {
            LogMgr.logError(new CallerInfo(){}, "Invalid attribute/values passed: attributes: " + StringUtil.arrayToString(stringArray) + ", values=" + StringUtil.arrayToString(stringArray2), new RuntimeException("Backtrace"));
        }
        this.appendOpenTag(stringBuilder, stringBuilder2, string, arrayList, bl);
    }

    public void appendOpenTag(StringBuilder stringBuilder, StringBuilder stringBuilder2, String string, Collection<TagAttribute> collection, boolean bl) {
        if (stringBuilder2 != null) {
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        stringBuilder.append('<');
        stringBuilder.append(string);
        if (collection != null && collection.size() > 0) {
            for (TagAttribute tagAttribute : collection) {
                stringBuilder.append(' ');
                stringBuilder.append(tagAttribute.getTagText());
            }
        }
        if (bl) {
            stringBuilder.append('>');
        }
    }

    public void appendOpenTag(StringBuilder stringBuilder, StringBuilder stringBuilder2, String string, boolean bl, TagAttribute ... tagAttributeArray) {
        if (stringBuilder2 != null) {
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        stringBuilder.append('<');
        stringBuilder.append(string);
        if (tagAttributeArray != null && tagAttributeArray.length > 0) {
            for (TagAttribute tagAttribute : tagAttributeArray) {
                if (tagAttribute == null) continue;
                stringBuilder.append(' ');
                stringBuilder.append(tagAttribute.getTagText());
            }
        }
        if (bl) {
            stringBuilder.append('>');
        }
    }

    public void appendCloseTag(StringBuilder stringBuilder, StringBuilder stringBuilder2, String string) {
        if (stringBuilder2 != null) {
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        stringBuilder.append("</");
        stringBuilder.append(string);
        stringBuilder.append(">\n");
    }

    public static boolean needsCData(CharSequence charSequence) {
        if (charSequence == null) {
            return false;
        }
        for (int i = 0; i < SPECIAL_CHARS.length; ++i) {
            if (StringUtil.indexOf(charSequence, SPECIAL_CHARS[i]) <= -1) continue;
            return true;
        }
        return false;
    }

    public void writeWorkbenchVersion(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        this.appendTag(stringBuilder, stringBuilder2, TAG_GENERATED_BY, "SQL Workbench/J " + ResourceMgr.getBuildInfo());
    }

    public static void writeWorkbenchVersion(Writer writer, StringBuilder stringBuilder) throws IOException {
        if (stringBuilder != null) {
            writer.append(stringBuilder);
        }
        writer.append('<');
        writer.append(TAG_GENERATED_BY);
        writer.append('>');
        writer.append("SQL Workbench/J " + ResourceMgr.getBuildInfo());
        writer.append("</");
        writer.append(TAG_GENERATED_BY);
        writer.append(">\n");
    }
}

