/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.shutdown;

import java.sql.SQLException;
import workbench.db.ConnectionMgr;
import workbench.db.ConnectionProfile;
import workbench.db.DbDriver;
import workbench.db.WbConnection;
import workbench.db.shutdown.DbShutdownHook;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.ExceptionUtil;
import workbench.util.StringUtil;

public class DerbyShutdownHook
implements DbShutdownHook {
    @Override
    public void shutdown(WbConnection wbConnection) throws SQLException {
        if (ConnectionMgr.getInstance().isActive(wbConnection)) {
            return;
        }
        try {
            wbConnection.rollback();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        wbConnection.shutdown();
        if (!this.canShutdown(wbConnection)) {
            return;
        }
        ConnectionProfile connectionProfile = wbConnection.getProfile();
        String string = connectionProfile.getDriverclass();
        String string2 = connectionProfile.getDriverName();
        String string3 = connectionProfile.getUrl();
        int n = string3.indexOf(59);
        if (n < 0) {
            n = string3.length();
        }
        String string4 = string3.substring(0, n) + ";shutdown=true";
        try {
            DbDriver dbDriver = ConnectionMgr.getInstance().findDriverByName(string, string2);
            LogMgr.logInfo(new CallerInfo(){}, "Local Derby connection detected. Shutting down engine...");
            dbDriver.commandConnect(string4);
        }
        catch (SQLException sQLException) {
            LogMgr.logInfo(new CallerInfo(){}, ExceptionUtil.getDisplay(sQLException));
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error when shutting down Cloudscape/Derby", throwable);
        }
    }

    private boolean canShutdown(WbConnection wbConnection) {
        String string = wbConnection.getProfile().getDriverclass();
        if (!string.equals("org.apache.derby.jdbc.EmbeddedDriver")) {
            return false;
        }
        String string2 = wbConnection.getUrl();
        int n = StringUtil.indexOf(string2, ':', 2);
        if (n < 0) {
            return true;
        }
        String string3 = string2.substring(n + 1);
        if (string2.startsWith(string3 + "net:")) {
            return false;
        }
        return !string2.startsWith(string3 + "//");
    }
}

