/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.sqlite;

import java.util.Set;
import workbench.db.DataTypeResolver;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;

public class SQLiteDataTypeResolver
implements DataTypeResolver {
    private Set<String> INTEGER_TYPES = CollectionUtil.caseInsensitiveSet("INT", "INTEGER", "TINYINT", "SMALLINT", "MEDIUMINT", "BIGINT", "UNSIGNED BIG INT", "INT2", "INT8");
    private Set<String> BIG_INTEGER_TYPES = CollectionUtil.caseInsensitiveSet("BIGINT", "UNSIGNED BIG INT", "INT8");
    private Set<String> CHARACTER_TYPES = CollectionUtil.caseInsensitiveSet("VARCHAR", "CHARACTER", "VARYING CHARACTER", "NCHAR", "NATIVE CHARACTER", "NVARCHAR", "STRING");
    private Set<String> CLOB_TYPES = CollectionUtil.caseInsensitiveSet("TEXT", "CLOB");
    private Set<String> DECIMAL_TYPES = CollectionUtil.caseInsensitiveSet("NUMERIC", "DECIMAL");
    private Set<String> DOUBLE_TYPES = CollectionUtil.caseInsensitiveSet("REAL", "DOUBLE", "DOUBLE PRECISION", "FLOAT");

    @Override
    public String getSqlTypeDisplay(String string, int n, int n2, int n3) {
        return string;
    }

    @Override
    public int fixColumnType(int n, String string) {
        String string2 = SqlUtil.getPlainTypeName(string);
        if (this.INTEGER_TYPES.contains(string2)) {
            return 4;
        }
        if (this.BIG_INTEGER_TYPES.contains(string2)) {
            return -5;
        }
        if (this.CHARACTER_TYPES.contains(string2)) {
            return 12;
        }
        if (this.DECIMAL_TYPES.contains(string2)) {
            return 3;
        }
        if (this.DOUBLE_TYPES.contains(string2)) {
            return 8;
        }
        if (this.CLOB_TYPES.contains(string2)) {
            return 2005;
        }
        if (string.equalsIgnoreCase("BLOB")) {
            return 2004;
        }
        return n;
    }

    @Override
    public String getColumnClassName(int n, String string) {
        switch (n) {
            case 3: 
            case 8: {
                return "java.lang.Double";
            }
            case -6: 
            case 4: 
            case 5: {
                return "java.lang.Integer";
            }
            case -5: {
                return "java.math.BigInt";
            }
        }
        return "java.lang.String";
    }
}

