/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.sqltemplates;

import workbench.db.ColumnIdentifier;
import workbench.resource.Settings;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class ColumnDefinitionTemplate {
    public static final String PARAM_NOT_NULL = "%not_null%";
    public static final String PARAM_COL_CONSTRAINTS = "%column_constraint%";
    public static final String PARAM_EXPRESSION = "%expression%";
    public static final String PARAM_COLLATION_NAME = "%collation%";
    public static final String PARAM_GENERATED = "%generated%";
    public static final String PARAM_EXTRA_OPTION = "%extra_option%";
    public static final String PARAM_AUTO_INC = "%auto_increment%";
    public static final String PARAM_OPTION = "%column_option%";
    private String dbid;
    private String template;
    private boolean fixDefaultExpression;

    public ColumnDefinitionTemplate() {
    }

    public ColumnDefinitionTemplate(String string) {
        this.dbid = string;
    }

    public String getColumnDefinitionSQL(ColumnIdentifier columnIdentifier, String string, int n) {
        return this.getColumnDefinitionSQL(columnIdentifier, string, n, null);
    }

    public String getColumnDefinitionSQL(ColumnIdentifier columnIdentifier, String string, int n, String string2) {
        String string3 = columnIdentifier.getComputedColumnExpression();
        boolean bl = StringUtil.isNonBlank(string3);
        String string4 = this.getTemplate(bl, columnIdentifier.isAutoincrement());
        String string5 = StringUtil.padRight(string2 == null ? columnIdentifier.getDbmsType() : string2, n);
        string4 = ColumnDefinitionTemplate.replaceArg(string4, "%datatype%", string5);
        boolean bl2 = false;
        if (StringUtil.isNonBlank(string)) {
            bl2 = string.contains("DEFAULT");
        }
        String string6 = this.getDefaultExpression(columnIdentifier);
        string4 = bl2 ? ColumnDefinitionTemplate.replaceArg(string4, "%default_value%", string) : (StringUtil.isNonBlank(string6) ? ColumnDefinitionTemplate.replaceArg(string4, "%default_value%", columnIdentifier.getDefaultClause() + " " + string6) : ColumnDefinitionTemplate.replaceArg(string4, "%default_value%", ""));
        string4 = ColumnDefinitionTemplate.replaceNullable(string4, this.dbid, columnIdentifier.isNullable(), string);
        string4 = bl2 ? ColumnDefinitionTemplate.replaceArg(string4, PARAM_COL_CONSTRAINTS, "") : ColumnDefinitionTemplate.replaceArg(string4, PARAM_COL_CONSTRAINTS, string);
        string4 = StringUtil.isEmptyString(columnIdentifier.getSQLOption()) ? ColumnDefinitionTemplate.replaceArg(string4, PARAM_OPTION, "") : ColumnDefinitionTemplate.replaceArg(string4, PARAM_OPTION, columnIdentifier.getSQLOption());
        string4 = ColumnDefinitionTemplate.replaceArg(string4, PARAM_EXPRESSION, string3);
        string4 = ColumnDefinitionTemplate.replaceArg(string4, PARAM_COLLATION_NAME, columnIdentifier.getCollationExpression());
        string4 = bl ? ColumnDefinitionTemplate.replaceArg(string4, PARAM_GENERATED, columnIdentifier.getComputedColumnExpression()) : ColumnDefinitionTemplate.replaceArg(string4, PARAM_GENERATED, columnIdentifier.getGeneratorExpression());
        string4 = ColumnDefinitionTemplate.replaceArg(string4, PARAM_EXTRA_OPTION, columnIdentifier.getSQLOption());
        string4 = columnIdentifier.isAutoincrement() ? ColumnDefinitionTemplate.replaceArg(string4, PARAM_AUTO_INC, this.getProperty("autoincrement.keyword", null)) : ColumnDefinitionTemplate.replaceArg(string4, PARAM_AUTO_INC, "");
        return string4.trim();
    }

    public void setFixDefaultValues(boolean bl) {
        this.fixDefaultExpression = bl;
    }

    public String getDefaultExpression(ColumnIdentifier columnIdentifier) {
        boolean bl;
        String string = columnIdentifier.getDefaultValue();
        if (string == null) {
            return null;
        }
        boolean bl2 = bl = this.dbid != null && this.dbid.equals("mysql");
        if (bl && SqlUtil.isNumberType(columnIdentifier.getDataType())) {
            string = string.replaceAll("^\\(+", "");
            string = string.replaceAll("\\)+$", "");
        }
        if (!this.fixDefaultExpression) {
            return string;
        }
        boolean bl3 = false;
        if (SqlUtil.isCharacterType(columnIdentifier.getDataType())) {
            if ("NULL".equalsIgnoreCase(string)) {
                return "NULL";
            }
            if (!(string.startsWith("'") || string.startsWith("N'") || string.startsWith("E'") || string.startsWith("U&'"))) {
                bl3 = true;
            }
        }
        string = string.trim();
        if (bl && SqlUtil.isDateType(columnIdentifier.getDataType()) && !string.startsWith("'") && !string.toUpperCase().startsWith("CURRENT_TIMESTAMP")) {
            bl3 = true;
        }
        if (bl3) {
            return "'" + string + "'";
        }
        return string;
    }

    public static String replaceNullable(String string, String string2, boolean bl, String string3) {
        boolean bl2;
        boolean bl3 = bl2 = string3 != null && string3.toUpperCase().trim().endsWith("NOT NULL");
        if (bl2) {
            string = ColumnDefinitionTemplate.replaceArg(string, "%nullable%", "");
            string = ColumnDefinitionTemplate.replaceArg(string, PARAM_NOT_NULL, "");
            return string;
        }
        String string4 = Settings.getInstance().getProperty("workbench.db." + string2 + ".nullkeyword", "NULL");
        if (bl) {
            string = ColumnDefinitionTemplate.replaceArg(string, "%nullable%", string4);
            string = ColumnDefinitionTemplate.replaceArg(string, PARAM_NOT_NULL, "");
        } else {
            string = ColumnDefinitionTemplate.replaceArg(string, "%nullable%", "NOT NULL");
            string = ColumnDefinitionTemplate.replaceArg(string, PARAM_NOT_NULL, "NOT NULL");
        }
        return string;
    }

    public static String replaceArg(String string, String string2, String string3) {
        if (StringUtil.isBlank(string3)) {
            return string.replaceFirst(string2 + "\\s*|" + string2 + "$", "");
        }
        return string.replace(string2, string3);
    }

    private String getTemplate(boolean bl, boolean bl2) {
        String string;
        if (this.template != null) {
            return this.template;
        }
        if (bl2 && (string = this.getProperty("coldef.autoinc", null)) != null) {
            return string;
        }
        if (bl) {
            if (bl2 && (string = this.getProperty("coldef.computed.autoinc", null)) != null) {
                return string;
            }
            string = this.getProperty("coldef.computed", null);
            if (string != null) {
                return string;
            }
        }
        return this.getProperty("coldef", "%datatype% %default_value% %not_null% %column_constraint%");
    }

    private String getProperty(String string, String string2) {
        String string3 = Settings.getInstance().getProperty("workbench.db.sql." + string, string2);
        if (StringUtil.isNonBlank(this.dbid)) {
            string3 = Settings.getInstance().getProperty("workbench.db." + this.dbid + "." + string, string3);
        }
        return string3;
    }

    void setTemplate(String string) {
        this.template = string;
    }

    public static enum ColumnType {
        regularColumn,
        computedColumn;

    }
}

