/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.teradata;

import java.sql.ResultSet;
import java.sql.Statement;
import workbench.db.JdbcProcedureReader;
import workbench.db.JdbcUtils;
import workbench.db.NoConfigException;
import workbench.db.ProcedureDefinition;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.SqlUtil;

public class TeradataProcedureReader
extends JdbcProcedureReader {
    public TeradataProcedureReader(WbConnection wbConnection) {
        super(wbConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSequence retrieveProcedureSource(ProcedureDefinition procedureDefinition) throws NoConfigException {
        String string = "show procedure " + SqlUtil.buildExpression(this.connection, procedureDefinition);
        LogMgr.logDebug(new CallerInfo(){}, "Query to retrieve procedure source: " + string);
        Statement statement = null;
        ResultSet resultSet = null;
        StringBuilder stringBuilder = new StringBuilder(100);
        try {
            statement = this.connection.createStatementForQuery();
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('\n');
                }
                stringBuilder.append(resultSet.getString(1));
            }
        }
        catch (Exception exception) {
            try {
                LogMgr.logDebug(new CallerInfo(){}, "Error retrieving procedure source using: \n" + string, exception);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return stringBuilder;
    }
}

