/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.ucanaccess;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataConverter;

public class UCanAccessDataConverter
implements DataConverter {
    private Method getValue;

    public static UCanAccessDataConverter getInstance() {
        return LazyInstanceHolder.INSTANCE;
    }

    private UCanAccessDataConverter() {
    }

    @Override
    public boolean convertsType(int n, String string) {
        return n == 1111;
    }

    @Override
    public Object convertValue(int n, String string, Object object) {
        if (n != 1111) {
            return object;
        }
        if (object == null) {
            return null;
        }
        try {
            if (object.getClass().isArray() && Array.getLength(object) > 0) {
                Method method;
                Object object2 = Array.get(object, 0);
                if (object2 == null) {
                    return object;
                }
                if (object2.getClass().getName().equals("net.ucanaccess.complex.SingleValue") && (method = this.getValueMethod(object2)) != null) {
                    Object object3 = method.invoke(object2, new Object[0]);
                    return object3;
                }
            }
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not read SingleValue", throwable);
        }
        return object;
    }

    @Override
    public Class getConvertedClass(int n, String string) {
        if (this.convertsType(n, string)) {
            return Object.class;
        }
        return null;
    }

    private synchronized Method getValueMethod(Object object) {
        if (this.getValue == null) {
            try {
                this.getValue = object.getClass().getMethod("getValue", new Class[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.getValue;
    }

    private static class LazyInstanceHolder {
        protected static final UCanAccessDataConverter INSTANCE = new UCanAccessDataConverter();

        private LazyInstanceHolder() {
        }
    }
}

