/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.vertica;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import workbench.db.JdbcUtils;
import workbench.db.SequenceDefinition;
import workbench.db.SequenceReader;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class VerticaSequenceReader
implements SequenceReader {
    private WbConnection dbConnection;
    private final String baseSql = "select current_database as sequence_catalog, \n       sequence_schema,  \n       sequence_name, \n       minimum, \n       maximum, \n       increment_by, \n       session_cache_count, \n       allow_cycle \nfrom v_catalog.sequences";

    public VerticaSequenceReader(WbConnection wbConnection) {
        this.dbConnection = wbConnection;
    }

    @Override
    public void readSequenceSource(SequenceDefinition sequenceDefinition) {
        if (sequenceDefinition == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(250);
        try {
            String string = sequenceDefinition.getSequenceName();
            Long l = (Long)sequenceDefinition.getSequenceProperty("max_value");
            Long l2 = (Long)sequenceDefinition.getSequenceProperty("min_value");
            Long l3 = (Long)sequenceDefinition.getSequenceProperty("increment");
            Long l4 = (Long)sequenceDefinition.getSequenceProperty("cache");
            Boolean bl = (Boolean)sequenceDefinition.getSequenceProperty("cycle");
            if (bl == null) {
                bl = Boolean.FALSE;
            }
            long l5 = l == null ? Long.MAX_VALUE : l;
            long l6 = l2 == null ? 1L : l2;
            long l7 = l3 == null ? 1L : l3;
            long l8 = l4 == null ? 250000L : l4;
            stringBuilder.append("CREATE SEQUENCE ");
            stringBuilder.append(string);
            stringBuilder.append("\n       INCREMENT BY ");
            stringBuilder.append(l7);
            stringBuilder.append("\n       MINVALUE ");
            stringBuilder.append(l6);
            if (l5 != Long.MAX_VALUE) {
                stringBuilder.append("\n       MAXVALUE ");
                stringBuilder.append(Long.toString(l5));
            }
            if (l8 != 250000L) {
                stringBuilder.append("\n       CACHE ");
                stringBuilder.append(l8);
            }
            stringBuilder.append("\n       ");
            if (!bl.booleanValue()) {
                stringBuilder.append("NO");
            }
            stringBuilder.append(" CYCLE");
            stringBuilder.append(";\n");
            if (StringUtil.isNonBlank(sequenceDefinition.getComment())) {
                stringBuilder.append('\n');
                stringBuilder.append("COMMENT ON SEQUENCE ").append(sequenceDefinition.getSequenceName()).append(" IS '").append(sequenceDefinition.getComment().replace("'", "''")).append("';");
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error reading sequence definition", exception);
        }
        sequenceDefinition.setSource(stringBuilder);
    }

    @Override
    public CharSequence getSequenceSource(String string, String string2, String string3) {
        SequenceDefinition sequenceDefinition = this.getSequenceDefinition(string, string2, string3);
        return sequenceDefinition.getSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SequenceDefinition> getSequences(String string, String string2, String string3) {
        ArrayList<SequenceDefinition> arrayList = new ArrayList<SequenceDefinition>();
        ResultSet resultSet = null;
        Statement statement = null;
        Savepoint savepoint = null;
        if (string3 == null) {
            string3 = "%";
        }
        String string4 = this.buildSql(string2, null);
        try {
            if (this.dbConnection.getDbSettings().useSavePointForDML()) {
                savepoint = this.dbConnection.setSavepoint();
            }
            statement = this.dbConnection.createStatementForQuery();
            resultSet = statement.executeQuery(string4);
            DataStore dataStore = new DataStore(resultSet, this.dbConnection, true);
            for (int i = 0; i < dataStore.getRowCount(); ++i) {
                arrayList.add(this.createDefinition(dataStore, i));
            }
            this.dbConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            try {
                this.dbConnection.rollback(savepoint);
                LogMgr.logError(new CallerInfo(){}, "Error retrieving sequences using:\n" + string4, sQLException);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return arrayList;
    }

    private SequenceDefinition createDefinition(DataStore dataStore, int n) {
        String string = dataStore.getValueAsString(n, "sequence_catalog");
        String string2 = dataStore.getValueAsString(n, "sequence_name");
        String string3 = dataStore.getValueAsString(n, "sequence_schema");
        SequenceDefinition sequenceDefinition = new SequenceDefinition(string, string3, string2);
        sequenceDefinition.setSequenceProperty("increment", dataStore.getValue(0, "increment_by"));
        sequenceDefinition.setSequenceProperty("max_value", dataStore.getValue(0, "maximum"));
        sequenceDefinition.setSequenceProperty("min_value", dataStore.getValue(0, "minimum"));
        sequenceDefinition.setSequenceProperty("cache", dataStore.getValue(0, "session_cache_count"));
        sequenceDefinition.setSequenceProperty("cycle", dataStore.getValue(0, "allow_cycle"));
        return sequenceDefinition;
    }

    private SequenceDefinition retrieveSequenceDetails(String string, String string2, String string3) {
        DataStore dataStore = this.getRawSequenceDefinition(string, string2, string3);
        if (dataStore.getRowCount() == 0) {
            return null;
        }
        SequenceDefinition sequenceDefinition = this.createDefinition(dataStore, 0);
        this.readSequenceSource(sequenceDefinition);
        return sequenceDefinition;
    }

    @Override
    public SequenceDefinition getSequenceDefinition(String string, String string2, String string3) {
        return this.retrieveSequenceDetails(string, string2, string3);
    }

    @Override
    public DataStore getRawSequenceDefinition(String string, String string2, String string3) {
        if (string3 == null) {
            return null;
        }
        DataStore dataStore = null;
        try {
            String string4 = this.buildSql(string2, string3);
            dataStore = SqlUtil.getResultData(this.dbConnection, string4, true);
        }
        catch (SQLException sQLException) {
            LogMgr.logDebug(new CallerInfo(){}, "Error reading sequence definition", sQLException);
        }
        return dataStore;
    }

    private String buildSql(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("select current_database as sequence_catalog, \n       sequence_schema,  \n       sequence_name, \n       minimum, \n       maximum, \n       increment_by, \n       session_cache_count, \n       allow_cycle \nfrom v_catalog.sequences");
        if (string != null || string2 != null) {
            stringBuilder.append(" WHERE ");
            boolean bl = false;
            if (string2 != null) {
                SqlUtil.appendExpression(stringBuilder, "sequence_name", string2, this.dbConnection);
                bl = true;
            }
            if (bl) {
                SqlUtil.appendAndCondition(stringBuilder, "sequence_schema", string, this.dbConnection);
            } else {
                SqlUtil.appendExpression(stringBuilder, "sequence_schema", string, this.dbConnection);
                bl = true;
            }
            if (Settings.getInstance().getDebugMetadataSql()) {
                LogMgr.logDebug(new CallerInfo(){}, "Using SQL=\n" + stringBuilder);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public String getSequenceTypeName() {
        return "SEQUENCE";
    }
}

