/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import workbench.gui.MainWindow;
import workbench.gui.WbSwingUtilities;
import workbench.gui.sql.SqlPanel;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.WbFile;

class DropHandler
implements DropTargetListener {
    private final MainWindow client;
    private final DropTarget target;

    DropHandler(MainWindow mainWindow, Component component) {
        this.client = mainWindow;
        this.target = new DropTarget(component, 1, this);
    }

    public void dispose() {
        if (this.target != null) {
            this.target.removeDropTargetListener(this);
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.acceptDrag(1);
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dropTargetDropEvent.acceptDrop(1);
                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                if (this.isWorkspaceFile(list)) {
                    WbFile wbFile = new WbFile((File)list.get(0));
                    this.client.loadWorkspace(wbFile.getFullPath(), true);
                } else if (list != null) {
                    this.openFiles(list);
                }
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }
        catch (UnsupportedFlavorException | IOException exception) {
            LogMgr.logError(new CallerInfo(){}, "Error processing drop event", exception);
            dropTargetDropEvent.rejectDrop();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    private boolean isWorkspaceFile(List list) {
        if (list == null) {
            return false;
        }
        if (list.size() != 1) {
            return false;
        }
        WbFile wbFile = new WbFile((File)list.get(0));
        return wbFile.getExtension().equalsIgnoreCase("wksp");
    }

    private void openFiles(List list) {
        WbSwingUtilities.invokeLater(() -> {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                File file = (File)list.get(i);
                boolean bl = i == n - 1;
                SqlPanel sqlPanel = (SqlPanel)this.client.addTab(bl, bl, true, true);
                sqlPanel.readFile(file.getAbsolutePath(), null);
            }
        });
    }
}

