/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Window;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.PlainEditor;
import workbench.gui.components.WbOptionPane;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ErrorPromptType;
import workbench.resource.GuiSettings;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.sql.ErrorDescriptor;

public class ErrorContinueDialog {
    private int dialogChoice;
    private ErrorDescriptor errorDetails;
    private String question;

    public ErrorContinueDialog(ErrorDescriptor errorDescriptor, String string) {
        this.errorDetails = errorDescriptor;
        this.question = string;
    }

    public int askContinue(Component component) {
        WbSwingUtilities.invoke(() -> {
            this.dialogChoice = this.showDialog(component);
        });
        return this.dialogChoice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int showDialog(Component component) {
        Object[] objectArray = new String[]{ResourceMgr.getString("LblIgnoreThis"), ResourceMgr.getString("LblIgnoreAllErr"), ResourceMgr.getPlainString("LblStopScript")};
        Window window = null;
        int n = 2;
        try {
            Object object = this.getMessage();
            WbOptionPane wbOptionPane = new WbOptionPane(object, -1, 1, null, objectArray);
            window = wbOptionPane.createDialog(WbSwingUtilities.getWindowAncestor(component), "SQL Workbench/J");
            ((JDialog)window).setDefaultCloseOperation(2);
            ((Dialog)window).setResizable(true);
            window.pack();
            ((Dialog)window).setVisible(true);
            Object object2 = wbOptionPane.getValue();
            n = object2 == null ? 2 : (object2.equals(objectArray[0]) ? 3042 : (object2.equals(objectArray[1]) ? 2042 : (object2.equals(objectArray[2]) ? 2 : 2)));
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error displaying error dialog", throwable);
        }
        finally {
            if (window != null) {
                window.dispose();
            }
        }
        return n;
    }

    private Object getMessage() {
        if (GuiSettings.getErrorPromptType() == ErrorPromptType.PromptWithErroressage && this.errorDetails != null && this.errorDetails.getErrorMessage() != null) {
            try {
                return this.createMessagePanel();
            }
            catch (Throwable throwable) {
                LogMgr.logError(new CallerInfo(){}, "Could not create message panel", throwable);
            }
        }
        return this.question;
    }

    private JComponent createMessagePanel() {
        Serializable serializable;
        JPanel jPanel = WbSwingUtilities.getMultilineLabel(this.question);
        String string = this.errorDetails != null ? this.errorDetails.getErrorMessage() : "";
        int n = IconMgr.getInstance().getSizeForLabel();
        Font font = UIManager.getFont("OptionPane.messageFont");
        if (font != null) {
            serializable = jPanel.getFontMetrics(font);
            if (serializable != null) {
                n = ((FontMetrics)serializable).getHeight();
            }
        } else {
            LogMgr.logWarning(new CallerInfo(){}, "No font available for OptionPane.messageFont");
        }
        jPanel.setBorder(new EmptyBorder(0, 0, n / 4, 0));
        serializable = new JPanel(new BorderLayout(0, 0));
        PlainEditor plainEditor = WbSwingUtilities.createErrorMessagePanel(string, "workbench.sql.error.wordwrap", GuiSettings.allowWordWrapForErrorMessage());
        ((Container)serializable).add(jPanel, "First");
        ((Container)serializable).add(plainEditor, "Center");
        return serializable;
    }
}

