/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import workbench.WbManager;
import workbench.db.ConnectionMgr;
import workbench.db.ConnectionProfile;
import workbench.db.WbConnection;
import workbench.db.objectcache.DbObjectCacheFactory;
import workbench.gui.DropHandler;
import workbench.gui.WbKeyDispatcher;
import workbench.gui.WbSwingUtilities;
import workbench.gui.WindowTitleBuilder;
import workbench.gui.actions.AboutAction;
import workbench.gui.actions.AddMacroAction;
import workbench.gui.actions.AddTabAction;
import workbench.gui.actions.AssignWorkspaceAction;
import workbench.gui.actions.BookmarksAction;
import workbench.gui.actions.CloseWorkspaceAction;
import workbench.gui.actions.ConfigureShortcutsAction;
import workbench.gui.actions.ConfigureToolbarAction;
import workbench.gui.actions.CreateNewConnection;
import workbench.gui.actions.DataPumperAction;
import workbench.gui.actions.DisconnectTabAction;
import workbench.gui.actions.EditWorkspaceVarsAction;
import workbench.gui.actions.FileCloseAction;
import workbench.gui.actions.FileConnectAction;
import workbench.gui.actions.FileDiscardAction;
import workbench.gui.actions.FileDisconnectAction;
import workbench.gui.actions.FileExitAction;
import workbench.gui.actions.FileNewWindowAction;
import workbench.gui.actions.FileReconnectAction;
import workbench.gui.actions.FileSaveProfiles;
import workbench.gui.actions.HelpConnectionInfoAction;
import workbench.gui.actions.HelpContactAction;
import workbench.gui.actions.ImportProfilesAction;
import workbench.gui.actions.InsertTabAction;
import workbench.gui.actions.LoadMacrosAction;
import workbench.gui.actions.LoadWorkspaceAction;
import workbench.gui.actions.ManageDriversAction;
import workbench.gui.actions.ManageMacroAction;
import workbench.gui.actions.NewDbExplorerPanelAction;
import workbench.gui.actions.NewDbExplorerWindowAction;
import workbench.gui.actions.NextTabAction;
import workbench.gui.actions.ObjectSearchAction;
import workbench.gui.actions.OpenFileAction;
import workbench.gui.actions.OptionsDialogAction;
import workbench.gui.actions.PrevTabAction;
import workbench.gui.actions.ReloadProfileWkspAction;
import workbench.gui.actions.RemoveTabAction;
import workbench.gui.actions.RenameTabAction;
import workbench.gui.actions.SaveAsNewWorkspaceAction;
import workbench.gui.actions.SaveMacrosAction;
import workbench.gui.actions.SaveWorkspaceAction;
import workbench.gui.actions.SearchAllEditorsAction;
import workbench.gui.actions.SelectTabAction;
import workbench.gui.actions.ShowDbExplorerAction;
import workbench.gui.actions.ShowDbTreeAction;
import workbench.gui.actions.ShowDbmsManualAction;
import workbench.gui.actions.ShowHelpAction;
import workbench.gui.actions.ShowMacroPopupAction;
import workbench.gui.actions.ShowManualAction;
import workbench.gui.actions.VersionCheckAction;
import workbench.gui.actions.ViewLineNumbers;
import workbench.gui.actions.ViewLogfileAction;
import workbench.gui.actions.ViewToolbarAction;
import workbench.gui.actions.WbAction;
import workbench.gui.actions.WhatsNewAction;
import workbench.gui.bookmarks.BookmarkManager;
import workbench.gui.bookmarks.NamedScriptLocation;
import workbench.gui.components.ConnectionSelector;
import workbench.gui.components.DividerBorder;
import workbench.gui.components.GuiPosition;
import workbench.gui.components.MenuScroller;
import workbench.gui.components.RunningJobIndicator;
import workbench.gui.components.TabCloser;
import workbench.gui.components.TabbedPaneHistory;
import workbench.gui.components.WbMenu;
import workbench.gui.components.WbSplitPane;
import workbench.gui.components.WbTabbedPane;
import workbench.gui.components.WbToolbar;
import workbench.gui.dbobjects.DbExplorerPanel;
import workbench.gui.dbobjects.DbExplorerWindow;
import workbench.gui.dbobjects.objecttree.DbTreePanel;
import workbench.gui.dbobjects.objecttree.DbTreeSettings;
import workbench.gui.dbobjects.objecttree.TreePosition;
import workbench.gui.fontzoom.DecreaseFontSize;
import workbench.gui.fontzoom.FontZoomer;
import workbench.gui.fontzoom.IncreaseFontSize;
import workbench.gui.fontzoom.ResetFontSize;
import workbench.gui.lnf.LnFHelper;
import workbench.gui.macros.MacroMenuBuilder;
import workbench.gui.menu.RecentFileManager;
import workbench.gui.menu.SqlTabPopup;
import workbench.gui.profiles.ConnectionGuiHelper;
import workbench.gui.sql.EditorPanel;
import workbench.gui.sql.PanelType;
import workbench.gui.sql.RenameableTab;
import workbench.gui.sql.SqlPanel;
import workbench.gui.tabhistory.ClosedTabManager;
import workbench.interfaces.Connectable;
import workbench.interfaces.DbExecutionListener;
import workbench.interfaces.Disposable;
import workbench.interfaces.FilenameChangeListener;
import workbench.interfaces.MacroChangeListener;
import workbench.interfaces.MainPanel;
import workbench.interfaces.Moveable;
import workbench.interfaces.StatusBar;
import workbench.interfaces.ToolWindow;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.DbExplorerSettings;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.resource.ShortcutManager;
import workbench.sql.VariablePool;
import workbench.sql.macros.MacroManager;
import workbench.util.ClasspathUtil;
import workbench.util.CollectionUtil;
import workbench.util.ExceptionUtil;
import workbench.util.FileDialogUtil;
import workbench.util.FileUtil;
import workbench.util.FileVersioner;
import workbench.util.HtmlUtil;
import workbench.util.NumberStringCache;
import workbench.util.StringUtil;
import workbench.util.VersionNumber;
import workbench.util.WbFile;
import workbench.util.WbProperties;
import workbench.util.WbThread;
import workbench.util.WbWorkspace;

public class MainWindow
extends JFrame
implements MouseListener,
WindowListener,
ChangeListener,
MacroChangeListener,
DbExecutionListener,
Connectable,
PropertyChangeListener,
Moveable,
RenameableTab,
TabCloser,
FilenameChangeListener,
ComponentListener {
    private static final String DEFAULT_WORKSPACE = "Default.wksp";
    private static final String RECENTMACROS_NAME = "recent-macros";
    private static final String DB_TREE_PROPS = "dbtree";
    private static int instanceCount;
    private final int windowId;
    private String deviceId;
    private boolean exitOnCancel = false;
    private WbConnection currentConnection;
    private ConnectionProfile currentProfile;
    protected ConnectionSelector connectionSelector;
    private EditWorkspaceVarsAction editWorkspaceVariables;
    private CloseWorkspaceAction closeWorkspaceAction;
    private SaveWorkspaceAction saveWorkspaceAction;
    private SaveAsNewWorkspaceAction saveAsWorkspaceAction;
    private LoadWorkspaceAction loadWorkspaceAction;
    private AssignWorkspaceAction assignWorkspaceAction;
    private ReloadProfileWkspAction reloadWorkspace;
    private HelpConnectionInfoAction connectionInfoAction;
    private ShowDbmsManualAction showDbmsManual;
    private FileDisconnectAction disconnectAction;
    private FileConnectAction connectAction;
    private FileReconnectAction reconnectAction;
    private CreateNewConnection createNewConnection;
    private DisconnectTabAction disconnectTab;
    private ShowDbExplorerAction dbExplorerAction;
    private NewDbExplorerPanelAction newDbExplorerPanel;
    private NewDbExplorerWindowAction newDbExplorerWindow;
    private FileSaveProfiles saveProfilesAction;
    private FileNewWindowAction newWindowAction;
    private ShowDbTreeAction showDbTree;
    private FileCloseAction fileCloseAction;
    private OpenFileAction fileOpenAction;
    private FileExitAction fileExitAction;
    private final WbTabbedPane sqlTab;
    private final TabbedPaneHistory tabHistory;
    private WbToolbar currentToolbar;
    private final List<JMenuBar> panelMenus = Collections.synchronizedList(new ArrayList(15));
    private final Object workspaceLock = new Object();
    private WbWorkspace currentWorkspace;
    private boolean workspaceIsSaving;
    private final NextTabAction nextTab;
    private final PrevTabAction prevTab;
    private boolean ignoreTabChange;
    private boolean connectInProgress;
    private AddMacroAction createMacro;
    private ManageMacroAction manageMacros;
    private LoadMacrosAction loadMacros;
    private SaveMacrosAction saveMacros;
    private ShowMacroPopupAction showMacroPopup;
    private final List<ToolWindow> explorerWindows = new ArrayList<ToolWindow>();
    private RunningJobIndicator jobIndicator;
    protected WbThread connectThread;
    private DropHandler dropHandler;
    private DbTreePanel treePanel;
    private boolean shouldShowTree;
    private final ClosedTabManager closedTabHistory = new ClosedTabManager(this);

    public MainWindow(GraphicsConfiguration graphicsConfiguration) {
        super("SQL Workbench/J", graphicsConfiguration);
        this.getRootPane().putClientProperty("apple.awt.brushMetalLook", GuiSettings.getUseBrushedMetal());
        this.windowId = ++instanceCount;
        this.sqlTab = new WbTabbedPane();
        this.tabHistory = new TabbedPaneHistory(this.sqlTab);
        this.setDefaultCloseOperation(0);
        this.nextTab = new NextTabAction(this.sqlTab);
        this.prevTab = new PrevTabAction(this.sqlTab);
        MacroManager.getInstance().addChangeListener(this, this.getMacroClientId());
        this.initMenu();
        ResourceMgr.setWindowIcons((Window)this, "workbench");
        this.getContentPane().add((Component)this.sqlTab, "Center");
        this.restoreSettings();
        this.updateTabPolicy();
        Color color = GuiSettings.getEditorTabHighlightColor();
        if (color != null) {
            int n = GuiSettings.getEditorTabHighlightWidth();
            GuiPosition guiPosition = GuiSettings.getEditorTabHighlightLocation();
            this.sqlTab.setTabHighlight(color, n, guiPosition);
        }
        this.sqlTab.addChangeListener(this);
        this.sqlTab.addMouseListener(this);
        this.sqlTab.hideDisabledButtons(false);
        if (GuiSettings.getShowSqlTabCloseButton()) {
            this.sqlTab.showCloseButton(this);
        }
        this.addWindowListener(this);
        this.addComponentListener(this);
        this.dropHandler = new DropHandler(this, this.sqlTab);
        this.sqlTab.enableDragDropReordering(this);
        Settings.getInstance().addPropertyChangeListener(this, "workbench.gui.mainwindow.showtoolbar", "workbench.gui.toolbar.actions", "workbench.gui.tabs.showindex", "workbench.gui.display.sqltab.closebutton", "workbench.gui.mainwindow.tabpolicy", "workbench.gui.display.name_at_end", "workbench.gui.display.showpworkspace", "workbench.gui.display.showurl", "workbench.gui.display.showprofilegroup", "workbench.gui.display.showfilename", "workbench.gui.display.titlegroupsep", "workbench.gui.display.titlegroupbracket", "workbench.gui.display.showurl.includeuser");
        ShortcutManager.getInstance().addChangeListener(this);
    }

    private String getCurrentDeviceID() {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        GraphicsDevice graphicsDevice = graphicsConfiguration.getDevice();
        return graphicsDevice.getIDstring();
    }

    protected final void updateTabPolicy() {
        if (LnFHelper.isWebLaf()) {
            return;
        }
        JComponent jComponent = (JComponent)this.getContentPane();
        WbSwingUtilities.invoke(() -> {
            int n = Settings.getInstance().getIntProperty("workbench.gui.mainwindow.tabpolicy", 0);
            this.sqlTab.setTabLayoutPolicy(n);
            this.sqlTab.invalidate();
            jComponent.revalidate();
        });
        WbSwingUtilities.repaintLater(this);
    }

    public void display() {
        this.restoreState();
        this.setVisible(true);
        this.addTab();
        this.updateWindowTitle();
        boolean bl = Settings.getInstance().getBoolProperty(this.getClass().getName() + ".macropopup.visible", false);
        if (bl) {
            EventQueue.invokeLater(this.showMacroPopup::showPopup);
        }
    }

    public boolean isDbTreeVisible() {
        return this.treePanel != null && this.treePanel.isVisible();
    }

    public void showDbTree() {
        this.showDbTree(true);
    }

    public void showDbTree(boolean bl) {
        if (this.treePanel == null) {
            this.treePanel = new DbTreePanel();
            this.getContentPane().remove(this.sqlTab);
            WbSplitPane wbSplitPane = new WbSplitPane();
            wbSplitPane.setDividerBorder(WbSwingUtilities.EMPTY_BORDER);
            wbSplitPane.setOneTouchExpandable(true);
            TreePosition treePosition = DbTreeSettings.getDbTreePosition();
            if (treePosition == TreePosition.left) {
                this.treePanel.setBorder(new DividerBorder(2));
                this.sqlTab.setBorder(new DividerBorder(1));
                wbSplitPane.setLeftComponent(this.treePanel);
                wbSplitPane.setRightComponent(this.sqlTab);
            } else {
                this.treePanel.setBorder(new DividerBorder(1));
                this.sqlTab.setBorder(new DividerBorder(2));
                wbSplitPane.setLeftComponent(this.sqlTab);
                wbSplitPane.setRightComponent(this.treePanel);
            }
            this.treePanel.restoreSettings(this.getToolProperties(DB_TREE_PROPS));
            this.getContentPane().add((Component)wbSplitPane, "Center");
            this.invalidate();
            this.sqlTab.invalidate();
            EventQueue.invokeLater(this::validate);
        }
        if (DbTreeSettings.useTabConnection()) {
            this.treePanel.setConnectionToUse(this.getCurrentConnection());
        } else if (this.treePanel.getConnection() == null) {
            this.treePanel.connect(this.currentProfile);
        }
        if (bl) {
            this.treePanel.requestFocusInWindow();
        }
        int n = this.getTabCount();
        for (int i = 0; i < n; ++i) {
            this.getPanel(i).ifPresent(mainPanel -> mainPanel.registerObjectFinder(this.treePanel));
        }
    }

    public void hideDbTree() {
        if (this.treePanel == null) {
            return;
        }
        if (!this.treePanel.isVisible()) {
            return;
        }
        this.treePanel.saveSettings(this.getToolProperties(DB_TREE_PROPS));
        this.treePanel.setVisible(false);
    }

    public void restoreDbTree() {
        if (this.treePanel == null) {
            return;
        }
        if (this.treePanel.isVisible()) {
            return;
        }
        this.treePanel.restoreSettings(this.getToolProperties(DB_TREE_PROPS));
        this.treePanel.setVisible(true);
    }

    public DbTreePanel getDbTree() {
        return this.treePanel;
    }

    public void closeDbTree() {
        if (this.treePanel != null) {
            this.treePanel.saveSettings(this.getToolProperties(DB_TREE_PROPS));
            JSplitPane jSplitPane = (JSplitPane)this.treePanel.getParent();
            jSplitPane.remove(this.sqlTab);
            this.getContentPane().remove(jSplitPane);
            this.getContentPane().add((Component)this.sqlTab, "Center");
            this.sqlTab.invalidate();
            this.sqlTab.setBorder(WbSwingUtilities.EMPTY_BORDER);
            this.invalidate();
            this.treePanel.disconnectInBackground();
            this.treePanel = null;
            int n = this.getTabCount();
            for (int i = 0; i < n; ++i) {
                this.getPanel(i).ifPresent(mainPanel -> mainPanel.registerObjectFinder(null));
            }
            EventQueue.invokeLater(this::validate);
        }
    }

    @Override
    public void fileNameChanged(Object object, String string) {
        if (this.ignoreTabChange) {
            return;
        }
        this.updateWindowTitle();
        if (object instanceof SqlPanel) {
            if (string != null) {
                this.updateRecentFiles();
            }
            SqlPanel sqlPanel = (SqlPanel)object;
            BookmarkManager.getInstance().updateInBackground(this, sqlPanel, true);
        }
    }

    public void addFilenameChangeListener(FilenameChangeListener filenameChangeListener) {
        for (int i = 0; i < this.sqlTab.getTabCount(); ++i) {
            this.getSqlPanel(i).ifPresent(sqlPanel -> sqlPanel.addFilenameChangeListener(filenameChangeListener));
        }
    }

    public void removeFilenameChangeListener(FilenameChangeListener filenameChangeListener) {
        for (int i = 0; i < this.sqlTab.getTabCount(); ++i) {
            this.getSqlPanel(i).ifPresent(sqlPanel -> sqlPanel.removeFilenameChangeListener(filenameChangeListener));
        }
    }

    @Override
    public void addTabChangeListener(ChangeListener changeListener) {
        this.sqlTab.addChangeListener(changeListener);
    }

    public void removeIndexChangeListener(ChangeListener changeListener) {
        this.sqlTab.removeChangeListener(changeListener);
    }

    public void addExecutionListener(DbExecutionListener dbExecutionListener) {
        int n = this.sqlTab.getTabCount();
        for (int i = 0; i < n; ++i) {
            this.getSqlPanel(i).ifPresent(sqlPanel -> sqlPanel.addDbExecutionListener(dbExecutionListener));
        }
    }

    public void removeExecutionListener(DbExecutionListener dbExecutionListener) {
        int n = this.sqlTab.getTabCount();
        for (int i = 0; i < n; ++i) {
            this.getSqlPanel(i).ifPresent(sqlPanel -> sqlPanel.removeDbExecutionListener(dbExecutionListener));
        }
    }

    public boolean hasProfileWorkspace() {
        return this.currentProfile != null && StringUtil.isNonEmpty(this.currentProfile.getWorkspaceFile());
    }

    protected void checkWorkspaceActions() {
        boolean bl = this.currentWorkspace != null;
        this.saveWorkspaceAction.setEnabled(bl);
        this.assignWorkspaceAction.setEnabled(bl && this.currentProfile != null);
        this.closeWorkspaceAction.setEnabled(bl);
        this.editWorkspaceVariables.setEnabled(bl);
        this.checkReloadWkspAction();
    }

    private void initMenu() {
        this.disconnectAction = new FileDisconnectAction(this);
        this.reconnectAction = new FileReconnectAction(this);
        this.assignWorkspaceAction = new AssignWorkspaceAction(this);
        this.reloadWorkspace = new ReloadProfileWkspAction(this);
        this.closeWorkspaceAction = new CloseWorkspaceAction(this);
        this.editWorkspaceVariables = new EditWorkspaceVarsAction(this);
        this.saveAsWorkspaceAction = new SaveAsNewWorkspaceAction(this);
        this.createNewConnection = new CreateNewConnection(this);
        this.disconnectTab = new DisconnectTabAction(this);
        this.loadWorkspaceAction = new LoadWorkspaceAction(this);
        this.saveWorkspaceAction = new SaveWorkspaceAction(this);
        this.createMacro = new AddMacroAction(this.getMacroClientId());
        this.manageMacros = new ManageMacroAction(this);
        this.loadMacros = new LoadMacrosAction(this, this.getMacroClientId());
        this.saveMacros = new SaveMacrosAction(this, this.getMacroClientId());
        this.showMacroPopup = new ShowMacroPopupAction(this);
        this.dbExplorerAction = new ShowDbExplorerAction(this);
        this.newDbExplorerPanel = new NewDbExplorerPanelAction(this);
        this.newDbExplorerWindow = new NewDbExplorerWindowAction(this);
        this.showDbTree = new ShowDbTreeAction(this);
        this.showDbmsManual = new ShowDbmsManualAction();
        this.connectionInfoAction = new HelpConnectionInfoAction(this);
        this.connectionInfoAction.setEnabled(false);
        int n = this.sqlTab.getTabCount();
        for (int i = 0; i < n; ++i) {
            MainPanel mainPanel = (MainPanel)((Object)this.sqlTab.getComponentAt(i));
            JMenuBar jMenuBar = this.createMenuForPanel(mainPanel);
            this.panelMenus.add(jMenuBar);
        }
    }

    private void adjustMenuHeight(JMenuBar jMenuBar) {
        if (!GuiSettings.limitMenuLength()) {
            return;
        }
        int n = Math.min(WbSwingUtilities.calculateMaxMenuItems(this) - 4, GuiSettings.maxMenuItems());
        int n2 = jMenuBar.getMenuCount();
        for (int i = 0; i < n2; ++i) {
            int n3;
            JMenu jMenu = jMenuBar.getMenu(i);
            if (jMenu == null || (n3 = jMenu.getItemCount()) <= n) continue;
            MenuScroller.setScrollerFor(jMenu, n - 4);
        }
    }

    private JMenuBar createMenuForPanel(MainPanel mainPanel) {
        Serializable serializable;
        WbAction wbAction;
        Object object;
        Disposable disposable;
        Object object22;
        HashMap<String, JMenu> hashMap = new HashMap<String, JMenu>(10);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.setBorderPainted(false);
        jMenuBar.putClientProperty("jgoodies.headerStyle", "Single");
        JMenu jMenu = new WbMenu(ResourceMgr.getString("MnuTxtFile"));
        jMenu.setName("MnuTxtFile");
        jMenuBar.add(jMenu);
        hashMap.put("MnuTxtFile", jMenu);
        this.connectAction = new FileConnectAction(this);
        this.connectAction.addToMenu(jMenu);
        this.disconnectAction.addToMenu(jMenu);
        this.reconnectAction.addToMenu(jMenu);
        this.fileCloseAction = new FileCloseAction(this);
        this.fileCloseAction.addToMenu(jMenu);
        jMenu.addSeparator();
        this.createNewConnection.addToMenu(jMenu);
        this.disconnectTab.addToMenu(jMenu);
        jMenu.addSeparator();
        this.saveProfilesAction = new FileSaveProfiles();
        this.saveProfilesAction.addToMenu(jMenu);
        this.newWindowAction = new FileNewWindowAction();
        this.newWindowAction.addToMenu(jMenu);
        this.fileOpenAction = new OpenFileAction(this);
        jMenu.addSeparator();
        this.fileOpenAction.addToMenu(jMenu);
        List<Object> list = mainPanel.getMenuItems();
        if (this.isSQLPanel(mainPanel)) {
            jMenu = new WbMenu(ResourceMgr.getString("MnuTxtEdit"));
            jMenu.setName("MnuTxtEdit");
            jMenu.setVisible(false);
            jMenuBar.add(jMenu);
            hashMap.put("MnuTxtEdit", jMenu);
        }
        jMenu = new WbMenu(ResourceMgr.getString("MnuTxtView"));
        jMenu.setName("MnuTxtView");
        jMenu.setVisible(true);
        jMenuBar.add(jMenu);
        hashMap.put("MnuTxtView", jMenu);
        int n = this.sqlTab.getTabCount();
        for (int i = 0; i < n; ++i) {
            jMenu.add(new SelectTabAction(this.sqlTab, i));
        }
        jMenu.addSeparator();
        jMenu.add(this.nextTab.getMenuItem());
        jMenu.add(this.prevTab.getMenuItem());
        if (this.isSQLPanel(mainPanel)) {
            jMenu = new WbMenu(ResourceMgr.getString("MnuTxtData"));
            jMenu.setName("MnuTxtData");
            jMenu.setVisible(false);
            jMenuBar.add(jMenu);
            hashMap.put("MnuTxtData", jMenu);
            jMenu = new WbMenu(ResourceMgr.getString("MnuTxtSQL"));
            jMenu.setName("MnuTxtSQL");
            jMenu.setVisible(false);
            jMenuBar.add(jMenu);
            hashMap.put("MnuTxtSQL", jMenu);
            WbMenu wbMenu = new WbMenu(ResourceMgr.getString("MnuTxtMacro"));
            wbMenu.setName("MnuTxtMacro");
            wbMenu.setVisible(true);
            jMenuBar.add(wbMenu);
            hashMap.put("MnuTxtMacro", wbMenu);
            this.buildMacroMenu(wbMenu);
        }
        jMenu = new WbMenu(ResourceMgr.getString("MnuTxtWorkspace"));
        jMenu.setName("MnuTxtWorkspace");
        jMenuBar.add(jMenu);
        hashMap.put("MnuTxtWorkspace", jMenu);
        jMenu.add(this.saveWorkspaceAction);
        jMenu.add(this.saveAsWorkspaceAction);
        jMenu.add(this.loadWorkspaceAction);
        jMenu.add(this.reloadWorkspace);
        jMenu.add(this.editWorkspaceVariables);
        jMenu.addSeparator();
        jMenu.add(this.closeWorkspaceAction);
        jMenu.add(this.assignWorkspaceAction);
        jMenu.addSeparator();
        JMenu jMenu2 = new JMenu(ResourceMgr.getString("MnuTxtRecentWorkspace"));
        jMenu2.setName("recent-workspace");
        RecentFileManager.getInstance().populateRecentWorkspaceMenu(jMenu2, this);
        jMenu.add(jMenu2);
        for (Object object22 : list) {
            disposable = null;
            object = null;
            wbAction = null;
            boolean bl = false;
            if (object22 instanceof WbAction) {
                wbAction = (WbAction)object22;
                object = wbAction.getMenuItemName();
                bl = wbAction.getCreateMenuSeparator();
            } else if (object22 instanceof WbMenu) {
                disposable = (WbMenu)object22;
                object = disposable.getParentMenuId();
                bl = disposable.getCreateMenuSeparator();
            }
            if (object == null) continue;
            jMenu = (JMenu)hashMap.get(object);
            if (jMenu == null) {
                jMenu = new WbMenu(ResourceMgr.getString((String)object));
                jMenuBar.add(jMenu);
                hashMap.put((String)object, jMenu);
            }
            if (bl) {
                jMenu.addSeparator();
            }
            if (wbAction != null) {
                wbAction.addToMenu(jMenu);
                if (wbAction instanceof FileDiscardAction) {
                    serializable = new JMenu(ResourceMgr.getString("MnuTxtRecentFiles"));
                    ((Component)serializable).setName("recent-files");
                    RecentFileManager.getInstance().populateRecentFilesMenu((JMenu)serializable, this);
                    jMenu.add((JMenuItem)serializable);
                }
            } else if (disposable != null) {
                jMenu.add((JMenuItem)((Object)disposable));
                disposable.setVisible(true);
            }
            jMenu.setVisible(true);
        }
        JMenu jMenu3 = (JMenu)hashMap.get("MnuTxtFile");
        jMenu3.addSeparator();
        jMenu3.add(new ManageDriversAction());
        jMenu3.add(new ImportProfilesAction());
        jMenu3.addSeparator();
        this.fileExitAction = new FileExitAction();
        jMenu3.add(this.fileExitAction);
        object22 = (JMenu)hashMap.get("MnuTxtView");
        disposable = new AddTabAction(this);
        ((JMenu)object22).addSeparator();
        ((JMenu)object22).add((Action)((Object)disposable));
        object = new InsertTabAction(this);
        ((JMenu)object22).add((Action)object);
        wbAction = new RemoveTabAction(this);
        ((JMenu)object22).add(wbAction);
        ((JMenu)object22).add(new RenameTabAction(this));
        ((JMenu)object22).addSeparator();
        ViewLineNumbers viewLineNumbers = new ViewLineNumbers();
        viewLineNumbers.addToMenu((JMenu)object22);
        serializable = new ViewToolbarAction();
        ((WbAction)serializable).addToMenu((JMenu)object22);
        if (this.isSQLPanel(mainPanel)) {
            JMenu jMenu4 = new JMenu(ResourceMgr.getString("TxtZoom"));
            SqlPanel sqlPanel = (SqlPanel)mainPanel;
            EditorPanel editorPanel = sqlPanel.getEditor();
            FontZoomer fontZoomer = editorPanel.getFontZoomer();
            IncreaseFontSize increaseFontSize = new IncreaseFontSize(fontZoomer);
            DecreaseFontSize decreaseFontSize = new DecreaseFontSize(fontZoomer);
            ResetFontSize resetFontSize = new ResetFontSize(fontZoomer);
            jMenu4.add(new JMenuItem(increaseFontSize));
            jMenu4.add(new JMenuItem(decreaseFontSize));
            jMenu4.addSeparator();
            jMenu4.add(new JMenuItem(resetFontSize));
            ((JMenu)object22).add(jMenu4);
        }
        jMenuBar.add(this.buildToolsMenu());
        jMenuBar.add(this.buildHelpMenu());
        this.adjustMenuHeight(jMenuBar);
        return jMenuBar;
    }

    public List<WbAction> getAllActions() {
        SqlPanel sqlPanel = null;
        int n = this.sqlTab.getTabCount();
        for (int i = 0; i < n; ++i) {
            if (!this.isSQLPanel(this.sqlTab.getComponent(i))) continue;
            sqlPanel = (SqlPanel)this.sqlTab.getComponent(i);
            break;
        }
        if (sqlPanel == null) {
            sqlPanel = new SqlPanel(-1);
        }
        ArrayList<WbAction> arrayList = new ArrayList<WbAction>(100);
        arrayList.addAll(this.getGlobalActions());
        arrayList.addAll(sqlPanel.getAllActions());
        return arrayList;
    }

    private List<WbAction> getGlobalActions() {
        ArrayList<WbAction> arrayList = new ArrayList<WbAction>(15);
        arrayList.add(this.editWorkspaceVariables);
        arrayList.add(this.closeWorkspaceAction);
        arrayList.add(this.saveWorkspaceAction);
        arrayList.add(this.saveAsWorkspaceAction);
        arrayList.add(this.loadWorkspaceAction);
        arrayList.add(this.assignWorkspaceAction);
        arrayList.add(this.reloadWorkspace);
        arrayList.add(this.connectionInfoAction);
        arrayList.add(this.showDbmsManual);
        arrayList.add(this.disconnectAction);
        arrayList.add(this.connectAction);
        arrayList.add(this.reconnectAction);
        arrayList.add(this.createNewConnection);
        arrayList.add(this.disconnectTab);
        arrayList.add(this.dbExplorerAction);
        arrayList.add(this.newDbExplorerPanel);
        arrayList.add(this.newDbExplorerWindow);
        arrayList.add(this.showDbTree);
        arrayList.add(this.fileCloseAction);
        arrayList.add(this.fileOpenAction);
        arrayList.add(this.newWindowAction);
        arrayList.add(this.saveProfilesAction);
        arrayList.add(this.fileExitAction);
        arrayList.add(this.manageMacros);
        arrayList.add(this.loadMacros);
        arrayList.add(this.saveMacros);
        arrayList.add(this.showMacroPopup);
        arrayList.add(this.disconnectTab);
        arrayList.add(new ManageDriversAction());
        arrayList.add(new DataPumperAction(this));
        arrayList.add(new ObjectSearchAction(this));
        arrayList.add(new BookmarksAction(this));
        arrayList.add(new SearchAllEditorsAction(this));
        arrayList.add(new ShowHelpAction());
        arrayList.add(new ShowManualAction());
        arrayList.add(ViewLogfileAction.getInstance());
        return arrayList;
    }

    private void updateToolbarVisibility(boolean bl) {
        JComponent jComponent = (JComponent)this.getContentPane();
        if (this.currentToolbar != null) {
            jComponent.remove(this.currentToolbar);
            this.currentToolbar = null;
        }
        if (GuiSettings.getShowToolbar()) {
            this.getCurrentPanel().ifPresent(mainPanel -> {
                this.currentToolbar = mainPanel.getToolbar(this.getGlobalActions(), bl);
                jComponent.add((Component)this.currentToolbar, "North");
            });
        }
        jComponent.revalidate();
    }

    public void forceRedraw() {
        WbSwingUtilities.invoke(() -> {
            JComponent jComponent = (JComponent)this.getContentPane();
            this.sqlTab.validate();
            jComponent.validate();
        });
        WbSwingUtilities.repaintLater(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("workbench.gui.mainwindow.showtoolbar".equals(string) || "workbench.gui.toolbar.actions".equals(string)) {
            this.updateToolbarVisibility("workbench.gui.toolbar.actions".equals(string));
        } else if ("workbench.gui.tabs.showindex".equals(string)) {
            this.renumberTabs();
        } else if ("workbench.gui.display.sqltab.closebutton".equals(string)) {
            if (GuiSettings.getShowSqlTabCloseButton()) {
                this.sqlTab.showCloseButton(this);
            } else {
                this.sqlTab.showCloseButton(null);
            }
        } else if ("workbench.gui.mainwindow.tabpolicy".equals(string)) {
            this.updateTabPolicy();
        } else if (GuiSettings.WINDOW_TITLE_PROPS.contains(string)) {
            this.updateWindowTitle();
        }
    }

    private void checkMacroMenuForPanel(int n) {
        this.getPanel(n).ifPresent(mainPanel -> {
            try {
                JMenu jMenu = this.getMacroMenu(n);
                this.setMacroMenuItemStates(jMenu, mainPanel.isConnected());
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error during macro update", exception);
            }
        });
    }

    private void setMacroMenuEnabled(boolean bl) {
        int n = this.sqlTab.getTabCount();
        for (int i = 0; i < n; ++i) {
            JMenu jMenu = this.getMacroMenu(i);
            this.setMacroMenuItemStates(jMenu, bl);
        }
    }

    private void setMacroMenuItemStates(JMenu jMenu, boolean bl) {
        if (jMenu != null) {
            JMenuItem jMenuItem;
            int n;
            int n2 = jMenu.getItemCount();
            int n3 = -1;
            for (n = 0; n < n2; ++n) {
                jMenuItem = jMenu.getItem(n);
                if (jMenuItem == null || jMenuItem.getName() == null || !jMenuItem.getName().equals(RECENTMACROS_NAME)) continue;
                n3 = n + 1;
            }
            if (n3 == -1) {
                LogMgr.logWarning(new CallerInfo(){}, "Start of macro menu items not found!");
                return;
            }
            for (n = n3; n < n2; ++n) {
                jMenuItem = jMenu.getItem(n);
                if (jMenuItem == null) continue;
                jMenuItem.setEnabled(bl);
            }
        }
    }

    @Override
    public void macroListChanged() {
        EventQueue.invokeLater(this::updateMacros);
    }

    private void updateMacros() {
        int n = this.sqlTab.getTabCount();
        for (int i = 0; i < n; ++i) {
            JMenu jMenu = this.getMacroMenu(i);
            if (jMenu == null) continue;
            this.buildMacroMenu(jMenu);
            this.getPanel(i).ifPresent(mainPanel -> this.setMacroMenuItemStates(jMenu, mainPanel.isConnected()));
        }
    }

    private void buildMacroMenu(JMenu jMenu) {
        jMenu.removeAll();
        this.createMacro.addToMenu(jMenu);
        this.manageMacros.addToMenu(jMenu);
        this.showMacroPopup.addToMenu(jMenu);
        jMenu.addSeparator();
        this.loadMacros.addToMenu(jMenu);
        this.saveMacros.addToMenu(jMenu);
        JMenu jMenu2 = new JMenu(ResourceMgr.getString("MnuTxtRecentMacros"));
        jMenu2.setName(RECENTMACROS_NAME);
        RecentFileManager.getInstance().populateRecentMacrosMenu(this.getMacroClientId(), jMenu2);
        jMenu.add(jMenu2);
        MacroMenuBuilder macroMenuBuilder = new MacroMenuBuilder();
        macroMenuBuilder.buildMacroMenu(this, jMenu);
    }

    public int getCurrentPanelIndex() {
        return this.sqlTab.getSelectedIndex();
    }

    public int getIndexForPanel(Optional<MainPanel> optional) {
        return optional.map(MainPanel::getId).map(this::getIndexForPanel).orElse(-1);
    }

    public int getIndexForPanel(String string) {
        if (string == null) {
            return -1;
        }
        int n = this.sqlTab.getTabCount();
        for (int i = 0; i < n; ++i) {
            String string2 = this.getPanel(i).map(MainPanel::getId).orElse(null);
            if (!string.equals(string2)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WbProperties getToolProperties(String string) {
        if (this.currentWorkspace == null) {
            return new WbProperties(0);
        }
        Object object = this.workspaceLock;
        synchronized (object) {
            Map<String, WbProperties> map = this.currentWorkspace.getToolProperties();
            WbProperties wbProperties = map.get(string);
            if (wbProperties == null) {
                wbProperties = new WbProperties(1);
                map.put(string, wbProperties);
            }
            return wbProperties;
        }
    }

    public List<String> getPanelLabels() {
        int n = this.sqlTab.getTabCount();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            String string = this.getSqlPanel(i).map(SqlPanel::getTabTitle).orElse(null);
            arrayList.add(string);
        }
        return arrayList;
    }

    public Optional<MainPanel> getCurrentPanel() {
        int n = this.sqlTab.getSelectedIndex();
        if (n > -1) {
            return this.getPanel(n);
        }
        return Optional.empty();
    }

    public ClosedTabManager getClosedTabHistory() {
        return this.closedTabHistory;
    }

    public SqlPanel getCurrentSqlPanel() {
        return this.getCurrentPanel().filter(SqlPanel.class::isInstance).map(SqlPanel.class::cast).orElse(null);
    }

    public int getTabCount() {
        return this.sqlTab.getTabCount();
    }

    public Optional<MainPanel> getPanel(int n) {
        if (n < 0 || n >= this.sqlTab.getTabCount()) {
            return Optional.empty();
        }
        try {
            return Optional.of((MainPanel)((Object)this.sqlTab.getComponentAt(n)));
        }
        catch (Exception exception) {
            LogMgr.logDebug(new CallerInfo(){}, "Invalid index [" + n + "] specified!", exception);
            return Optional.empty();
        }
    }

    public Optional<SqlPanel> getSqlPanel(int n) {
        return this.getPanel(n).filter(SqlPanel.class::isInstance).map(SqlPanel.class::cast);
    }

    public void selectTab(int n) {
        this.sqlTab.setSelectedIndex(n);
    }

    public boolean isConnectInProgress() {
        return this.connectInProgress;
    }

    private void clearConnectIsInProgress() {
        this.connectInProgress = false;
    }

    private void setConnectIsInProgress() {
        this.connectInProgress = true;
    }

    public void checkConnectionForPanel(Optional<MainPanel> optional) {
        if (this.isConnectInProgress()) {
            return;
        }
        optional.filter(((Predicate<MainPanel>)MainPanel::isConnected).negate()).ifPresent(mainPanel -> {
            try {
                if (this.currentProfile != null && this.currentProfile.getUseSeparateConnectionPerTab()) {
                    this.createNewConnectionForPanel(optional);
                } else if (this.currentConnection != null) {
                    this.currentConnection.setShared(true);
                    mainPanel.setConnection(this.currentConnection);
                }
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error when checking connection", exception);
            }
        });
    }

    public void disconnectCurrentPanel() {
        if (this.currentProfile == null) {
            return;
        }
        if (this.currentProfile.getUseSeparateConnectionPerTab()) {
            return;
        }
        this.getCurrentPanel().ifPresent(mainPanel -> {
            WbConnection wbConnection = mainPanel.getConnection();
            if (wbConnection == this.currentConnection) {
                return;
            }
            WbThread wbThread = new WbThread("Disconnect panel " + mainPanel.getId(), (MainPanel)mainPanel){
                final /* synthetic */ MainPanel val$p;
                {
                    this.val$p = mainPanel;
                    super(string);
                }

                @Override
                public void run() {
                    MainWindow.this.disconnectPanel(Optional.of(this.val$p));
                }
            };
            wbThread.start();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnectPanel(Optional<MainPanel> optional) {
        if (this.isConnectInProgress()) {
            return;
        }
        boolean bl = this.isConnectInProgress();
        if (!bl) {
            this.setConnectIsInProgress();
        }
        this.showDisconnectInfo();
        this.showStatusMessage(ResourceMgr.getString("MsgDisconnecting"));
        try {
            optional.ifPresent(mainPanel -> {
                WbConnection wbConnection = mainPanel.getConnection();
                mainPanel.disconnect();
                wbConnection.disconnect();
                mainPanel.setConnection(this.currentConnection);
            });
            int n = this.getIndexForPanel(optional);
            this.sqlTab.setForegroundAt(n, null);
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error when disconnecting panel " + optional.map(MainPanel::getId).orElse("-"), throwable);
            String string = ExceptionUtil.getDisplay(throwable);
            WbSwingUtilities.showErrorMessage(this, string);
        }
        finally {
            this.showStatusMessage("");
            this.closeConnectingInfo();
            if (!bl) {
                this.clearConnectIsInProgress();
            }
        }
        EventQueue.invokeLater(() -> {
            this.createNewConnection.checkState();
            this.disconnectTab.checkState();
        });
    }

    public boolean canUseSeparateConnection() {
        if (this.currentProfile == null) {
            return false;
        }
        return !this.currentProfile.getUseSeparateConnectionPerTab();
    }

    public boolean usesSeparateConnection() {
        if (!this.canUseSeparateConnection()) {
            return false;
        }
        return this.usesSeparateConnection(this.getCurrentPanel());
    }

    public boolean usesSeparateConnection(Optional<MainPanel> optional) {
        if (!this.canUseSeparateConnection()) {
            return false;
        }
        return optional.map(MainPanel::getConnection).map(wbConnection -> !wbConnection.isShared()).orElse(false);
    }

    public void createNewConnectionForCurrentPanel() {
        Optional<MainPanel> optional = this.getCurrentPanel();
        this.createNewConnectionForPanel(optional);
        EventQueue.invokeLater(() -> {
            int n = this.getIndexForPanel(optional);
            this.sqlTab.setForegroundAt(n, Color.BLUE);
        });
    }

    protected void createNewConnectionForPanel(final Optional<MainPanel> optional) {
        if (this.isConnectInProgress()) {
            return;
        }
        if (this.connectThread != null) {
            return;
        }
        if (!optional.isPresent()) {
            LogMgr.logDebug(new CallerInfo(){}, "createNewConnectionForPanel() called without a panel!", new Exception("Backtrace"));
            return;
        }
        this.showConnectingInfo();
        this.connectThread = new WbThread("Panel Connect " + optional.get().getId()){

            @Override
            public void run() {
                MainWindow.this.connectPanel(optional);
            }
        };
        this.connectThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectPanel(Optional<MainPanel> optional) {
        if (this.isConnectInProgress()) {
            return;
        }
        this.setConnectIsInProgress();
        try {
            this.sqlTab.setEnabled(false);
            WbConnection wbConnection = this.getConnectionForTab(optional, true);
            int n = this.getIndexForPanel(optional);
            this.tabConnected(optional, wbConnection, n);
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error when connecting panel " + optional.map(MainPanel::getId).orElse("-"), throwable);
            this.showStatusMessage("");
            String string = ExceptionUtil.getDisplay(throwable);
            WbSwingUtilities.showFriendlyErrorMessage(this, ResourceMgr.getString("ErrConnectFailed"), string);
        }
        finally {
            this.sqlTab.setEnabled(true);
            this.closeConnectingInfo();
            this.clearConnectIsInProgress();
            this.connectThread = null;
        }
    }

    public void waitForConnection() {
        if (this.connectThread != null) {
            try {
                this.connectThread.join();
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error joining connection thread", exception);
            }
        }
    }

    private boolean isSQLPanel(Object object) {
        return object instanceof SqlPanel;
    }

    private void tabConnected(Optional<MainPanel> optional, WbConnection wbConnection, int n) {
        this.closeConnectingInfo();
        optional.ifPresent(mainPanel -> mainPanel.setConnection(wbConnection));
        if (this.isSQLPanel(optional.orElse(null)) && this.isDbTreeVisible() && DbTreeSettings.useTabConnection()) {
            this.treePanel.setConnectionToUse(wbConnection);
        }
        WbSwingUtilities.invoke(() -> this.updateGuiForTab(n));
    }

    private void updateGuiForTab(int n) {
        if (n < 0) {
            return;
        }
        if (n > this.sqlTab.getTabCount() - 1) {
            return;
        }
        this.getPanel(n).ifPresent(mainPanel -> {
            JMenuBar jMenuBar = null;
            if (n > -1 && n < this.panelMenus.size()) {
                jMenuBar = this.panelMenus.get(n);
            }
            if (jMenuBar == null) {
                return;
            }
            this.setJMenuBar(jMenuBar);
            this.updateToolbarVisibility(false);
            this.createNewConnection.checkState();
            this.disconnectTab.checkState();
            this.checkMacroMenuForPanel(n);
            this.forceRedraw();
            SwingUtilities.invokeLater(mainPanel::panelSelected);
        });
    }

    public void currentTabChanged() {
        int n = this.getCurrentPanelIndex();
        this.tabSelected(n);
    }

    protected void tabSelected(int n) {
        if (n < 0) {
            return;
        }
        if (n >= this.sqlTab.getTabCount()) {
            return;
        }
        WbSwingUtilities.invoke(() -> this.updateCurrentTab(n));
        int n2 = this.sqlTab.getPreviousTabIndex();
        if (n2 > -1 && n2 < this.sqlTab.getTabCount()) {
            BookmarkManager.getInstance().updateInBackground(this, this.getPanel(n2).orElse(null), false);
        }
        Predicate<MainPanel> predicate = mainPanel -> mainPanel instanceof DbExplorerPanel;
        if (this.getCurrentPanel().filter(predicate).isPresent()) {
            this.hideDbTree();
        } else {
            this.getPanel(n2).filter(predicate).map(DbExplorerPanel.class::cast).ifPresent(dbExplorerPanel -> {
                if (this.shouldShowTree) {
                    this.showDbTree(false);
                    this.shouldShowTree = false;
                } else {
                    this.restoreDbTree();
                }
            });
        }
    }

    private void updateCurrentTab(int n) {
        Optional<MainPanel> optional = this.getPanel(n);
        this.checkConnectionForPanel(optional);
        this.updateAddMacroAction();
        this.updateGuiForTab(n);
        this.updateWindowTitle();
        this.updateRecentFiles();
    }

    protected void updateAddMacroAction() {
        SqlPanel sqlPanel = this.getCurrentSqlPanel();
        if (sqlPanel != null) {
            this.createMacro.setClient(sqlPanel.getEditor());
        }
    }

    public void restoreState() {
        String string = Settings.getInstance().getProperty(this.getClass().getName() + ".state", "0");
        int n = StringUtil.getIntValue(string, 0);
        if (n == 6) {
            this.setExtendedState(n);
        }
    }

    public final void restoreSettings() {
        Settings settings = Settings.getInstance();
        if (!settings.restoreWindowSize(this)) {
            Dimension dimension = WbSwingUtilities.getScreenSize();
            int n = (int)((double)dimension.width * 0.75);
            int n2 = (int)((double)n * 0.75);
            this.setSize(n, n2);
        }
        if (!settings.restoreWindowPosition(this)) {
            WbSwingUtilities.center(this, null);
        }
    }

    public void saveSettings() {
        Settings settings = Settings.getInstance();
        int n = this.getExtendedState();
        settings.setProperty(this.getClass().getName() + ".state", n);
        settings.setProperty(this.getClass().getName() + ".screen", this.deviceId);
        if (n != 6) {
            settings.storeWindowPosition(this);
            settings.storeWindowSize(this);
        }
        boolean bl = this.showMacroPopup != null && this.showMacroPopup.isPopupVisible();
        settings.setProperty(this.getClass().getName() + ".macropopup.visible", bl);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        if (graphicsConfiguration == null) {
            return;
        }
        GraphicsDevice graphicsDevice = graphicsConfiguration.getDevice();
        if (graphicsDevice == null) {
            return;
        }
        this.deviceId = graphicsDevice.getIDstring();
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        this.deviceId = this.getCurrentDeviceID();
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        LogMgr.logDebug(new CallerInfo(){}, "Main window closing");
        WbManager.getInstance().closeMainWindow(this);
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        if (GuiSettings.installFocusManager()) {
            WbKeyDispatcher.getInstance().grabActions(null, null);
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        if (GuiSettings.installFocusManager()) {
            WbKeyDispatcher.getInstance().grabActions(this.nextTab, this.prevTab);
        }
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    public void showStatusMessage(String string) {
        this.getCurrentPanel().filter(mainPanel -> mainPanel instanceof StatusBar).map(StatusBar.class::cast).ifPresent(statusBar -> WbSwingUtilities.invoke(() -> {
            if (StringUtil.isEmptyString(string)) {
                statusBar.clearStatusMessage();
            } else {
                statusBar.setStatusMessage(string);
            }
        }));
    }

    public void showLogMessage(String string) {
        this.getCurrentPanel().ifPresent(mainPanel -> mainPanel.showLogMessage(string));
    }

    @Override
    public boolean connectBegin(ConnectionProfile connectionProfile, StatusBar statusBar, boolean bl) {
        if (this.isBusy() || this.isCancelling()) {
            WbSwingUtilities.showErrorMessageKey(this, "MsgDisconnectBusy");
            return false;
        }
        if (this.currentWorkspace != null && WbManager.getInstance().getSettingsShouldBeSaved() && !this.saveWorkspace(this.currentWorkspace.getFilename(), true)) {
            return false;
        }
        if (this.isConnected()) {
            this.showDisconnectInfo();
        }
        this.disconnect(false, false, false, false);
        this.setConnectIsInProgress();
        this.currentProfile = connectionProfile;
        this.showStatusMessage(ResourceMgr.getString("MsgLoadingWorkspace"));
        if (statusBar != null) {
            statusBar.setStatusMessage(ResourceMgr.getString("MsgLoadingWorkspace"));
        }
        if (bl) {
            this.loadCurrentProfileWorkspace();
        }
        Settings.getInstance().setLastConnection(this.currentProfile);
        this.showStatusMessage(ResourceMgr.getFormattedString("MsgConnectingTo", this.currentProfile.getName()));
        return true;
    }

    public int getMacroClientId() {
        return this.windowId;
    }

    public String getWindowId() {
        return NumberStringCache.getNumberString(this.windowId);
    }

    private String getConnectionIdForPanel(String string, Optional<MainPanel> optional) {
        if (!optional.isPresent()) {
            LogMgr.logError(new CallerInfo(){}, "Requested connection ID for NULL panel!", new Exception());
            return string;
        }
        if (GuiSettings.useTabIndexForConnectionId()) {
            return string + " TAB-" + (this.getIndexForPanel(optional) + 1);
        }
        return string + "-" + (String)optional.map(MainPanel::getId).orElse(null);
    }

    @Override
    public String getDefaultIconName() {
        return "workbench";
    }

    @Override
    public String getConnectionId(ConnectionProfile connectionProfile) {
        String string = this.getConnIdPrefix();
        if (connectionProfile != null && connectionProfile.getUseSeparateConnectionPerTab()) {
            return this.getConnectionIdForPanel(string, this.getCurrentPanel());
        }
        return string;
    }

    private String getConnIdPrefix() {
        return "WbWin-" + this.getWindowId();
    }

    private ConnectionSelector getSelector() {
        if (this.connectionSelector == null) {
            this.connectionSelector = new ConnectionSelector(this, this);
        }
        return this.connectionSelector;
    }

    public void connectTo(ConnectionProfile connectionProfile, boolean bl, boolean bl2) {
        if (!ConnectionGuiHelper.doPrompt(this, connectionProfile)) {
            LogMgr.logWarning(new CallerInfo(){}, "Can't directly connect to a profile that requires prompting for a password or username");
            return;
        }
        this.getSelector().connectTo(connectionProfile, bl, bl2);
    }

    private void loadMacrosForProfile() {
        if (this.currentProfile == null) {
            return;
        }
        WbFile wbFile = this.currentProfile.getMacroFile();
        MacroManager.getInstance().removeChangeListener(this, this.getMacroClientId());
        if (wbFile != null && wbFile.exists()) {
            MacroManager.getInstance().loadMacros(this.getMacroClientId(), wbFile);
        } else {
            MacroManager.getInstance().loadDefaultMacros(this.getMacroClientId());
        }
        this.macroListChanged();
        MacroManager.getInstance().addChangeListener(this, this.getMacroClientId());
    }

    @Override
    public void connected(WbConnection wbConnection) {
        Optional<MainPanel> optional = this.getCurrentPanel();
        if (!optional.isPresent()) {
            Thread.yield();
            optional = this.getCurrentPanel();
            LogMgr.logError(new CallerInfo(){}, "Connection established but no current panel!", new NullPointerException("Backtrace"));
        }
        if (this.currentProfile.getUseSeparateConnectionPerTab()) {
            optional.ifPresent(mainPanel -> mainPanel.setConnection(wbConnection));
        } else {
            this.setConnection(wbConnection);
        }
        this.setMacroMenuEnabled(true);
        this.updateWindowTitle();
        this.dbExplorerAction.setEnabled(true);
        this.newDbExplorerPanel.setEnabled(true);
        this.newDbExplorerWindow.setEnabled(true);
        if (this.showDbTree != null) {
            this.showDbTree.setEnabled(true);
        }
        this.disconnectAction.setEnabled(true);
        this.reconnectAction.setEnabled(true);
        this.createNewConnection.checkState();
        this.disconnectTab.checkState();
        this.showMacroPopup.workspaceChanged();
        optional.ifPresent(mainPanel -> {
            mainPanel.clearLog();
            mainPanel.showResultPanel();
        });
        VersionNumber versionNumber = wbConnection.getDatabaseVersion();
        this.showDbmsManual.setDbms(wbConnection.getDbId(), versionNumber);
        this.connectionInfoAction.setEnabled(true);
        this.showConnectionWarnings(wbConnection, optional);
        if (this.isDbTreeVisible()) {
            if (DbTreeSettings.useTabConnection()) {
                this.treePanel.setConnectionToUse(wbConnection);
            } else {
                this.treePanel.connect(this.currentProfile);
            }
        }
        this.selectCurrentEditor();
    }

    @Override
    public void connectFailed(String string) {
        this.disconnected(true);
        this.tabSelected(0);
        if (string == null) {
            return;
        }
        WbSwingUtilities.showFriendlyErrorMessage(this, ResourceMgr.getString("ErrConnectFailed"), string.trim());
    }

    @Override
    public void connectCancelled() {
        if (this.exitOnCancel) {
            WbManager.getInstance().closeMainWindow(this);
        }
    }

    @Override
    public void connectEnded() {
        for (int i = 0; i < this.sqlTab.getTabCount(); ++i) {
            this.getPanel(i).filter(mainPanel -> mainPanel instanceof StatusBar).map(StatusBar.class::cast).ifPresent(StatusBar::clearStatusMessage);
        }
        this.logVariables();
        this.clearConnectIsInProgress();
    }

    private LoadWorkspaceChoice checkNonExistingWorkspace() {
        return this.promptWorkspaceAction(ResourceMgr.getString("MsgProfileWorkspaceNotFound"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoadWorkspaceChoice promptWorkspaceAction(String string) {
        Object[] objectArray = new String[]{ResourceMgr.getString("LblCreateWorkspace"), ResourceMgr.getString("LblLoadWorkspace"), ResourceMgr.getString("LblIgnore")};
        JOptionPane jOptionPane = new JOptionPane(string, 3, 1, null, objectArray);
        InputMap inputMap = jOptionPane.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "none");
        JDialog jDialog = jOptionPane.createDialog(this, "SQL Workbench/J");
        try {
            jDialog.setDefaultCloseOperation(0);
            jDialog.setResizable(true);
            jDialog.pack();
            jDialog.setVisible(true);
        }
        finally {
            jDialog.dispose();
        }
        Object object = jOptionPane.getValue();
        if (object == null || object.equals(objectArray[0])) {
            return LoadWorkspaceChoice.CREATE;
        }
        if (object.equals(objectArray[1])) {
            return LoadWorkspaceChoice.LOAD_OTHER;
        }
        return LoadWorkspaceChoice.IGNORE;
    }

    private String getRealWorkspaceFilename(String string) {
        if (string == null) {
            return string;
        }
        WbFile wbFile = new WbFile(string = FileDialogUtil.makeWorkspacePath(string));
        if (!wbFile.isAbsolute()) {
            wbFile = new WbFile(Settings.getInstance().getWorkspaceDir(), string);
            string = wbFile.getFullPath();
        }
        return string;
    }

    public boolean loadWorkspace(String string, boolean bl) {
        Object object;
        if (this.isBusy()) {
            WbSwingUtilities.showMessageKey(this, "ErrLoadWkspBusy");
            return false;
        }
        if (string == null) {
            return false;
        }
        String string2 = this.getRealWorkspaceFilename(string);
        WbFile wbFile = new WbFile(string2);
        if (!wbFile.exists()) {
            this.resetWorkspace(string2);
            return true;
        }
        WbWorkspace wbWorkspace = null;
        boolean bl2 = false;
        while (!bl2) {
            wbWorkspace = new WbWorkspace(string2);
            try {
                bl2 = wbWorkspace.openForReading();
            }
            catch (Throwable throwable) {
                bl2 = false;
            }
            if (bl2) continue;
            FileUtil.closeQuietely(wbWorkspace);
            object = ResourceMgr.getFormattedString("ErrLoadingWorkspace", wbWorkspace.getLoadError());
            LoadWorkspaceChoice loadWorkspaceChoice = this.promptWorkspaceAction((String)object);
            switch (loadWorkspaceChoice) {
                case IGNORE: {
                    this.currentWorkspace = null;
                    this.currentProfile.setWorkspaceFile(null);
                    return false;
                }
                case CREATE: {
                    this.resetWorkspace(string2);
                    return true;
                }
                case LOAD_OTHER: {
                    FileDialogUtil fileDialogUtil = new FileDialogUtil();
                    String string3 = fileDialogUtil.getWorkspaceFilename(this, false, true);
                    string2 = this.getRealWorkspaceFilename(string3);
                }
            }
        }
        if (wbWorkspace != null) {
            object = wbWorkspace;
            WbSwingUtilities.invoke(() -> this.lambda$loadWorkspace$30((WbWorkspace)object, bl));
        }
        return this.currentWorkspace != null;
    }

    private void resetWorkspace(String string) {
        this.closeWorkspace();
        this.currentWorkspace = new WbWorkspace(string);
        this.updateWindowTitle();
        this.checkWorkspaceActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadWorkspace(WbWorkspace wbWorkspace, boolean bl) {
        CallerInfo callerInfo = new CallerInfo(){};
        long l = System.currentTimeMillis();
        try {
            Optional<MainPanel> optional;
            int n;
            this.removeAllPanels(false);
            this.setIgnoreTabChange(true);
            int n2 = wbWorkspace.getEntryCount();
            for (n = 0; n < n2; ++n) {
                if (wbWorkspace.getPanelType(n) == PanelType.dbExplorer) {
                    this.newDbExplorerPanel(false);
                } else {
                    this.addTabAtIndex(false, false, false, -1);
                }
                optional = this.getPanel(n);
                if (!optional.isPresent()) continue;
                MainPanel mainPanel = optional.get();
                ((JComponent)((Object)mainPanel)).validate();
                mainPanel.readFromWorkspace(wbWorkspace, n);
            }
            if (n2 == 0) {
                LogMgr.logWarning(callerInfo, "No panels stored in the workspace: " + wbWorkspace.getFilename());
                this.addTabAtIndex(false, false, false, -1);
            }
            this.currentWorkspace = wbWorkspace;
            this.renumberTabs();
            this.updateWindowTitle();
            this.checkWorkspaceActions();
            this.updateAddMacroAction();
            this.applyWorkspaceVariables();
            this.setIgnoreTabChange(false);
            int n3 = n = n2 > 0 ? wbWorkspace.getSelectedTab() : 0;
            if (n < this.sqlTab.getTabCount()) {
                this.sqlTab.setSelectedIndex(n);
            }
            optional = this.getCurrentPanel();
            this.checkConnectionForPanel(optional);
            this.setMacroMenuEnabled(true);
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(callerInfo, "Error loading workspace  " + wbWorkspace.getFilename(), throwable);
            this.currentWorkspace = null;
        }
        finally {
            this.updateTabHistoryMenu();
            this.checkReloadWkspAction();
            this.setIgnoreTabChange(false);
            FileUtil.closeQuietely(wbWorkspace);
            this.updateGuiForTab(this.sqlTab.getSelectedIndex());
        }
        if (bl) {
            RecentFileManager.getInstance().workspaceLoaded(new WbFile(wbWorkspace.getFilename()));
            EventQueue.invokeLater(this::updateRecentWorkspaces);
        }
        this.shouldShowTree = this.getToolProperties(DB_TREE_PROPS).getBoolProperty("tree.visible", false);
        if (this.shouldShowTree && this.getCurrentSqlPanel() != null) {
            EventQueue.invokeLater(() -> {
                this.showDbTree(false);
                this.shouldShowTree = false;
            });
        }
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(new CallerInfo(){}, "Loading workspace " + this.currentWorkspace + " took " + l2 + "ms");
        BookmarkManager.getInstance().updateInBackground(this);
    }

    private void applyWorkspaceVariables() {
        if (this.currentWorkspace == null) {
            return;
        }
        WbProperties wbProperties = this.currentWorkspace.getVariables();
        if (CollectionUtil.isNonEmpty(wbProperties)) {
            LogMgr.logInfo(new CallerInfo(){}, "Applying variables defined in the workspace: " + wbProperties);
            VariablePool.getInstance().readFromProperties(wbProperties, "workspace " + this.currentWorkspace.getFilename());
        }
    }

    private void logVariables() {
        this.getCurrentPanel().ifPresent(mainPanel -> {
            StringBuilder stringBuilder = new StringBuilder();
            VariablePool variablePool = VariablePool.getInstance();
            if (this.currentProfile != null) {
                this.appendVariables(stringBuilder, variablePool.removeGlobalVars(this.currentProfile.getConnectionVariables()), ResourceMgr.getString("TxtProfile"));
            }
            if (this.currentWorkspace != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\n");
                }
                this.appendVariables(stringBuilder, variablePool.removeGlobalVars(this.currentWorkspace.getVariables()), ResourceMgr.getString("TxtWorkspace"));
            }
            if (stringBuilder.length() > 0) {
                mainPanel.appendToLog(stringBuilder.toString());
            }
        });
    }

    private void appendVariables(StringBuilder stringBuilder, Properties properties, String string) {
        if (CollectionUtil.isNonEmpty(properties)) {
            stringBuilder.append(ResourceMgr.getFormattedString("MsgVarsLoaded", string) + ":\n");
            Set<Map.Entry<Object, Object>> set = properties.entrySet();
            for (Map.Entry<Object, Object> entry : set) {
                stringBuilder.append(entry.getKey() + "=" + entry.getValue() + "\n");
            }
        }
    }

    private void checkReloadWkspAction() {
        String string;
        String string2 = string = this.currentProfile != null ? this.currentProfile.getWorkspaceFile() : null;
        if (StringUtil.isNonEmpty(string)) {
            boolean bl = false;
            WbFile wbFile = new WbFile(this.getRealWorkspaceFilename(string));
            if (this.currentWorkspace != null) {
                WbFile wbFile2 = new WbFile(this.currentWorkspace.getFilename());
                bl = wbFile2.equals(wbFile);
            }
            this.reloadWorkspace.setEnabled(!bl);
        } else {
            this.reloadWorkspace.setEnabled(false);
        }
    }

    public void loadCurrentProfileWorkspace() {
        if (this.currentProfile == null) {
            LogMgr.logError(new CallerInfo(){}, "No current profile defined!", new IllegalStateException("No current profile"));
            return;
        }
        this.loadMacrosForProfile();
        String string = null;
        boolean bl = false;
        String string2 = this.currentProfile.getWorkspaceFile();
        if (StringUtil.isBlank(string2)) {
            string2 = DEFAULT_WORKSPACE;
            bl = true;
        }
        string = this.getRealWorkspaceFilename(string2);
        WbFile wbFile = new WbFile(string);
        if (string.length() > 0 && !wbFile.exists()) {
            LoadWorkspaceChoice loadWorkspaceChoice = bl ? LoadWorkspaceChoice.CREATE : this.checkNonExistingWorkspace();
            switch (loadWorkspaceChoice) {
                case LOAD_OTHER: {
                    FileDialogUtil fileDialogUtil = new FileDialogUtil();
                    string2 = fileDialogUtil.getWorkspaceFilename(this, false, true);
                    this.currentProfile.setWorkspaceFile(string2);
                    break;
                }
                case IGNORE: {
                    string2 = null;
                    this.currentProfile.setWorkspaceFile(null);
                    break;
                }
                default: {
                    this.closeWorkspace();
                }
            }
        }
        if (StringUtil.isNonBlank(string2)) {
            this.loadWorkspace(string2, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceDisconnect() {
        if (this.isConnectInProgress()) {
            return;
        }
        this.saveWorkspace(false);
        this.setConnectIsInProgress();
        this.showDisconnectInfo();
        try {
            final ArrayList<WbConnection> arrayList = new ArrayList<WbConnection>();
            for (int i = 0; i < this.sqlTab.getTabCount(); ++i) {
                MainPanel mainPanel = (MainPanel)((Object)this.sqlTab.getComponentAt(i));
                if (mainPanel == null) continue;
                if (this.isSQLPanel(mainPanel)) {
                    ((SqlPanel)mainPanel).forceAbort();
                }
                mainPanel.disconnect();
                WbConnection wbConnection = mainPanel.getConnection();
                if (wbConnection != null) {
                    arrayList.add(wbConnection);
                }
                for (ToolWindow toolWindow : this.explorerWindows) {
                    WbConnection wbConnection2 = toolWindow.getConnection();
                    if (wbConnection2 == this.currentConnection || wbConnection2 == null) continue;
                    arrayList.add(wbConnection2);
                }
            }
            this.closeExplorerWindows(false);
            WbThread wbThread = new WbThread("Abort connections"){

                @Override
                public void run() {
                    ConnectionMgr.getInstance().abortAll(arrayList);
                }
            };
            wbThread.start();
        }
        finally {
            this.closeConnectingInfo();
            WbSwingUtilities.invoke(() -> this.disconnected(true));
        }
    }

    @Override
    public void dispose() {
        if (this.treePanel != null) {
            this.treePanel.dispose();
        }
        this.sqlTab.removeAll();
        WbAction.dispose(this.assignWorkspaceAction, this.closeWorkspaceAction, this.reloadWorkspace, this.loadWorkspaceAction, this.saveAsWorkspaceAction, this.saveWorkspaceAction, this.dbExplorerAction, this.disconnectAction, this.reconnectAction, this.disconnectTab, this.createNewConnection, this.newDbExplorerPanel, this.newDbExplorerWindow, this.showDbTree, this.nextTab, this.prevTab, this.showDbmsManual, this.manageMacros, this.showMacroPopup, this.createMacro, this.loadMacros, this.saveMacros);
        for (JMenuBar jMenuBar : this.panelMenus) {
            this.disposeMenu(jMenuBar);
        }
        this.panelMenus.clear();
        this.explorerWindows.clear();
        JMenuBar jMenuBar = this.getJMenuBar();
        this.disposeMenu(jMenuBar);
        if (this.dropHandler != null) {
            this.dropHandler.dispose();
        }
        ShortcutManager.getInstance().removeChangeListener(this);
        super.dispose();
    }

    public void disconnect(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (this.isConnectInProgress()) {
            LogMgr.logWarning(new CallerInfo(){}, "Cannot disconnect because a disconnect is already in progress");
            return;
        }
        this.setConnectIsInProgress();
        if (bl3) {
            this.saveWorkspace(false);
        }
        if (bl4) {
            this.showDisconnectInfo();
        }
        Runnable runnable = () -> {
            try {
                this.doDisconnect();
                if (bl2) {
                    this.closeWorkspace(bl);
                }
            }
            finally {
                this.clearConnectIsInProgress();
                if (bl4) {
                    this.closeConnectingInfo();
                }
            }
        };
        if (bl) {
            WbThread wbThread = new WbThread(runnable, "MainWindow Disconnect");
            wbThread.start();
        } else {
            runnable.run();
        }
    }

    private void saveCache() {
        this.getCurrentPanel().map(MainPanel::getConnection).ifPresent(wbConnection -> DbObjectCacheFactory.getInstance().saveCache((WbConnection)wbConnection));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDisconnect() {
        this.saveCache();
        try {
            if (this.treePanel != null) {
                this.treePanel.disconnect();
            }
            WbConnection wbConnection = null;
            for (int i = 0; i < this.sqlTab.getTabCount(); ++i) {
                MainPanel mainPanel = (MainPanel)((Object)this.sqlTab.getComponentAt(i));
                if (mainPanel == null) continue;
                if (this.isSQLPanel(mainPanel)) {
                    ((SqlPanel)mainPanel).abortExecution();
                }
                wbConnection = mainPanel.getConnection();
                mainPanel.disconnect();
                if (wbConnection == null || wbConnection.isClosed()) continue;
                this.showStatusMessage(ResourceMgr.getString("MsgDisconnecting"));
                wbConnection.disconnect();
            }
            this.closeExplorerWindows(true);
        }
        finally {
            WbSwingUtilities.invoke(() -> this.disconnected(false));
        }
    }

    protected void disconnected(boolean bl) {
        this.currentProfile = null;
        this.currentConnection = null;
        if (bl) {
            this.closeWorkspace(false);
        }
        this.setMacroMenuEnabled(false);
        this.getJobIndicator().allJobsEnded();
        this.updateWindowTitle();
        this.disconnectAction.setEnabled(false);
        this.reconnectAction.setEnabled(false);
        this.showDbmsManual.clearDbms();
        this.connectionInfoAction.setEnabled(false);
        this.createNewConnection.checkState();
        this.disconnectTab.checkState();
        this.dbExplorerAction.setEnabled(false);
        this.newDbExplorerPanel.setEnabled(false);
        this.newDbExplorerWindow.setEnabled(false);
        if (this.showDbTree != null) {
            this.showDbTree.setEnabled(false);
        }
        this.showStatusMessage("");
        for (int i = 0; i < this.sqlTab.getTabCount(); ++i) {
            this.sqlTab.setForegroundAt(i, null);
        }
    }

    public void abortAll() {
        try {
            for (int i = 0; i < this.sqlTab.getTabCount(); ++i) {
                MainPanel mainPanel = (MainPanel)((Object)this.sqlTab.getComponentAt(i));
                if (!this.isSQLPanel(mainPanel)) continue;
                SqlPanel sqlPanel = (SqlPanel)mainPanel;
                sqlPanel.forceAbort();
            }
        }
        catch (Exception exception) {
            LogMgr.logWarning(new CallerInfo(){}, "Error stopping execution", exception);
        }
    }

    public void requestEditorFocus() {
        SqlPanel sqlPanel = this.getCurrentSqlPanel();
        if (sqlPanel != null) {
            sqlPanel.requestEditorFocus();
        }
    }

    private void selectCurrentEditor() {
        SqlPanel sqlPanel = this.getCurrentSqlPanel();
        if (sqlPanel != null) {
            sqlPanel.selectEditorLater();
        }
    }

    protected String getCurrentEditorFile() {
        String string = null;
        SqlPanel sqlPanel = this.getCurrentSqlPanel();
        if (sqlPanel != null) {
            string = sqlPanel.getCurrentFileName();
        }
        return string;
    }

    protected synchronized RunningJobIndicator getJobIndicator() {
        if (this.jobIndicator == null) {
            this.jobIndicator = new RunningJobIndicator(this);
        }
        return this.jobIndicator;
    }

    protected void updateWindowTitle() {
        EventQueue.invokeLater(() -> {
            WindowTitleBuilder windowTitleBuilder = new WindowTitleBuilder();
            String string = windowTitleBuilder.getWindowTitle(this.getCurrentConnection(), this.getCurrentWorkspaceFile(), this.getCurrentEditorFile());
            this.setTitle(string);
            this.getJobIndicator().baseTitleChanged();
        });
    }

    protected void closeConnectingInfo() {
        this.getSelector().closeConnectingInfo();
    }

    protected void showDisconnectInfo() {
        this.getSelector().showDisconnectInfo();
    }

    protected void showConnectingInfo() {
        this.getSelector().showConnectingInfo();
    }

    private WbConnection getCurrentConnection() {
        if (this.currentConnection != null) {
            return this.currentConnection;
        }
        Optional<MainPanel> optional = this.getCurrentPanel();
        if (optional.isPresent()) {
            return optional.get().getConnection();
        }
        return null;
    }

    private void setConnection(WbConnection wbConnection) {
        int n = this.sqlTab.getTabCount();
        if (wbConnection != null) {
            wbConnection.setShared(true);
        }
        for (int i = 0; i < n; ++i) {
            MainPanel mainPanel = (MainPanel)((Object)this.sqlTab.getComponentAt(i));
            mainPanel.setConnection(wbConnection);
        }
        this.currentConnection = wbConnection;
        if (this.currentProfile == null && wbConnection != null) {
            this.currentProfile = wbConnection.getProfile();
        }
    }

    public void selectConnection() {
        this.selectConnection(false, false);
    }

    public void selectConnection(boolean bl, boolean bl2) {
        ClasspathUtil classpathUtil;
        List<File> list;
        if (bl2 && (list = (classpathUtil = new ClasspathUtil()).checkLibsToMove()).size() > 1) {
            String string = list.stream().map(file -> "<li>" + file.getName() + "</li>").collect(Collectors.joining(""));
            WbFile wbFile = new ClasspathUtil().getExtDir();
            String string2 = ResourceMgr.getFormattedString("MsgExtDirWarning", classpathUtil.getJarPath(), string, wbFile.getFullPath());
            WbSwingUtilities.showMessage((Component)this, (Object)string2, 2);
            String string3 = "Please move the following files to " + wbFile.getFullPath() + "\n" + list.stream().map(file -> file.getAbsolutePath()).collect(Collectors.joining("\n"));
            LogMgr.logWarning(new CallerInfo(){}, string3);
        }
        this.exitOnCancel = bl;
        this.getSelector().selectConnection();
    }

    public JMenu getRecentWorkspaceMenu(int n) {
        return this.getSubMenuItem("MnuTxtWorkspace", "recent-workspace", n);
    }

    public JMenu getRecentFilesMenu(int n) {
        return this.getSubMenuItem("MnuTxtFile", "recent-files", n);
    }

    private JMenu getSubMenuItem(String string, String string2, int n) {
        JMenu jMenu = this.getMenu(string, n);
        if (jMenu == null) {
            return null;
        }
        int n2 = jMenu.getItemCount();
        for (int i = 0; i < n2; ++i) {
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (jMenuItem == null || !string2.equals(jMenuItem.getName())) continue;
            return (JMenu)jMenuItem;
        }
        return null;
    }

    private JMenu getTabHistoryMenu(int n) {
        return this.getSubMenuItem("MnuTxtTools", "MnuTxtTabHistory", n);
    }

    public JMenu getMacroMenu(int n) {
        JMenu jMenu = this.getMenu("MnuTxtMacro", n);
        return jMenu;
    }

    public JMenu getViewMenu(int n) {
        return this.getMenu("MnuTxtView", n);
    }

    public JMenu getMenu(String string, int n) {
        if (n < 0 || n >= this.panelMenus.size()) {
            return null;
        }
        if (string == null) {
            return null;
        }
        JMenuBar jMenuBar = this.panelMenus.get(n);
        int n2 = jMenuBar.getMenuCount();
        for (int i = 0; i < n2; ++i) {
            JMenu jMenu = jMenuBar.getMenu(i);
            if (jMenu == null || !string.equals(jMenu.getName())) continue;
            return jMenu;
        }
        return null;
    }

    public void updateTabHistoryMenu() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            JMenu jMenu = this.getTabHistoryMenu(i);
            this.closedTabHistory.updateMenu(jMenu);
        }
    }

    protected void updateRecentWorkspaces() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            JMenu jMenu = this.getRecentWorkspaceMenu(i);
            RecentFileManager.getInstance().populateRecentWorkspaceMenu(jMenu, this);
        }
    }

    protected void updateRecentFiles() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            JMenu jMenu = this.getRecentFilesMenu(i);
            RecentFileManager.getInstance().populateRecentFilesMenu(jMenu, this);
        }
    }

    protected void updateViewMenu(int n, String string) {
        int n2 = this.panelMenus.size();
        if (string == null) {
            string = ResourceMgr.getDefaultTabLabel();
        }
        for (int i = 0; i < n2; ++i) {
            JMenu jMenu = this.getViewMenu(i);
            if (jMenu == null) continue;
            int n3 = jMenu.getItemCount();
            for (int j = 0; j < n3; ++j) {
                SelectTabAction selectTabAction;
                Action action;
                JMenuItem jMenuItem = jMenu.getItem(j);
                if (jMenuItem == null || (action = jMenuItem.getAction()) == null || !(action instanceof SelectTabAction) || (selectTabAction = (SelectTabAction)action).getIndex() != n) continue;
                selectTabAction.setMenuText(string);
                break;
            }
            WbSwingUtilities.repaintNow(jMenu);
        }
    }

    public void addToViewMenu(SelectTabAction selectTabAction) {
        int n = this.panelMenus.size();
        int n2 = -1;
        SelectTabAction selectTabAction2 = null;
        for (int i = 0; i < n; ++i) {
            Action action;
            int n3;
            JMenu jMenu = this.getViewMenu(i);
            int n4 = jMenu.getItemCount();
            int n5 = -1;
            for (n3 = 0; n3 < n4; ++n3) {
                SelectTabAction selectTabAction3;
                JMenuItem jMenuItem = jMenu.getItem(n3);
                if (jMenuItem == null || (action = jMenuItem.getAction()) == null) continue;
                if (!(action instanceof SelectTabAction)) break;
                selectTabAction2 = selectTabAction3 = (SelectTabAction)action;
                n2 = n3;
                if (selectTabAction3.getIndex() <= selectTabAction.getIndex()) continue;
                jMenu.insert(selectTabAction, n3);
                n5 = n3;
                break;
            }
            if (n5 == -1) {
                if (n2 == -1) {
                    if (!(jMenu.getItem(n4 - 1).getAction() instanceof SelectTabAction)) {
                        jMenu.addSeparator();
                    }
                    jMenu.add(selectTabAction);
                    continue;
                }
                if (selectTabAction2 == null || selectTabAction2.getIndex() == selectTabAction.getIndex()) continue;
                jMenu.insert(selectTabAction, n2 + 1);
                continue;
            }
            n3 = selectTabAction.getIndex() + 1;
            for (int j = n5 + 1; j < n; ++j) {
                action = (SelectTabAction)jMenu.getItem(j).getAction();
                ((SelectTabAction)action).setNewIndex(n3);
                ++n3;
            }
        }
    }

    private void updateViewShortcuts() {
        int n = this.sqlTab.getTabCount();
        for (int i = 0; i < n; ++i) {
            JMenu jMenu = this.getViewMenu(i);
            for (int j = 0; j < n; ++j) {
                JMenuItem jMenuItem = jMenu.getItem(j);
                Action action = jMenuItem.getAction();
                if (!(action instanceof SelectTabAction)) continue;
                SelectTabAction selectTabAction = (SelectTabAction)action;
                selectTabAction.setNewIndex(j);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WbConnection getConnectionForTab(Optional<MainPanel> optional, boolean bl) throws Exception {
        if (this.currentConnection != null && !bl) {
            return this.currentConnection;
        }
        String string = this.getConnectionIdForPanel(this.getConnIdPrefix(), optional);
        StatusBar statusBar = optional.filter(mainPanel -> mainPanel instanceof StatusBar).map(StatusBar.class::cast).orElse(null);
        if (statusBar != null) {
            statusBar.setStatusMessage(ResourceMgr.getFormattedString("MsgConnectingTo", this.currentProfile.getName()));
        }
        ConnectionMgr connectionMgr = ConnectionMgr.getInstance();
        WbConnection wbConnection = null;
        try {
            wbConnection = connectionMgr.getConnection(this.currentProfile, string);
            wbConnection.setShared(false);
        }
        finally {
            if (statusBar != null) {
                statusBar.clearStatusMessage();
            }
        }
        this.showConnectionWarnings(wbConnection, optional);
        return wbConnection;
    }

    private void showConnectionWarnings(WbConnection wbConnection, Optional<MainPanel> optional) {
        optional.ifPresent(mainPanel -> {
            String string;
            String string2 = string = wbConnection != null ? wbConnection.getWarnings() : null;
            if (string != null) {
                mainPanel.showResultPanel();
                mainPanel.showLogMessage(ResourceMgr.getString("MsgConnectMsg") + "\n");
                mainPanel.appendToLog(string);
            }
        });
    }

    public void addDbExplorerTab(DbExplorerPanel dbExplorerPanel) {
        JMenuBar jMenuBar = this.createMenuForPanel(dbExplorerPanel);
        this.sqlTab.add(dbExplorerPanel);
        dbExplorerPanel.setTabTitle(this.sqlTab, this.sqlTab.getTabCount() - 1);
        SelectTabAction selectTabAction = new SelectTabAction(this.sqlTab, this.sqlTab.getTabCount() - 1);
        selectTabAction.setMenuText(dbExplorerPanel.getTabTitle());
        this.panelMenus.add(jMenuBar);
        this.addToViewMenu(selectTabAction);
    }

    public List<ToolWindow> getExplorerWindows() {
        return Collections.unmodifiableList(this.explorerWindows);
    }

    public void closeExplorerWindows(boolean bl) {
        try {
            ArrayList<ToolWindow> arrayList = new ArrayList<ToolWindow>(this.explorerWindows);
            for (ToolWindow toolWindow : arrayList) {
                WbConnection wbConnection = toolWindow.getConnection();
                if (wbConnection != null && bl && wbConnection != this.currentConnection) {
                    wbConnection.disconnect();
                }
                toolWindow.closeWindow();
            }
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error when closing explorer windows", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeOtherPanels(Optional<MainPanel> optional) {
        boolean bl;
        if (GuiSettings.getConfirmMultipleTabClose() && !(bl = WbSwingUtilities.getYesNo(this.sqlTab, ResourceMgr.getString("MsgConfirmCloseOtherTabs")))) {
            return;
        }
        MainPanel mainPanel = optional.orElse(null);
        boolean bl2 = this.connectInProgress;
        if (!bl2) {
            this.setConnectIsInProgress();
        }
        try {
            this.setIgnoreTabChange(true);
            int n = 0;
            while (n < this.sqlTab.getTabCount()) {
                MainPanel mainPanel2 = this.getPanel(n).orElse(null);
                if (mainPanel2 != null && mainPanel2 != mainPanel && !mainPanel2.isLocked()) {
                    if (mainPanel2.isModified()) {
                        this.selectTab(n);
                        this.tabSelected(n);
                    }
                    if (!mainPanel2.canClosePanel(true)) break;
                    this.removeTab(n, false, true);
                    continue;
                }
                ++n;
            }
            this.renumberTabs();
            this.updateCurrentTab(this.getCurrentPanelIndex());
            this.tabHistory.clear();
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when removing all panels", exception);
        }
        finally {
            this.setIgnoreTabChange(false);
            if (!bl2) {
                this.clearConnectIsInProgress();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllPanels(boolean bl) {
        boolean bl2 = this.connectInProgress;
        if (!bl2) {
            this.setConnectIsInProgress();
        }
        BookmarkManager.getInstance().clearBookmarksForWindow(this.getWindowId());
        try {
            int n;
            this.setIgnoreTabChange(true);
            this.closeDbTree();
            int n2 = n = bl ? 1 : 0;
            while (this.sqlTab.getTabCount() > n) {
                this.removeTab(n, false, false);
            }
            if (bl) {
                Optional<MainPanel> optional = this.getPanel(0);
                if (!optional.isPresent()) {
                    this.addTabAtIndex(false, false, false, -1);
                    optional = this.getPanel(0);
                } else {
                    optional.get().reset();
                }
                this.resetTabTitles();
                this.updateCurrentTab(0);
            }
            this.tabHistory.clear();
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when removing all panels", exception);
        }
        finally {
            this.setIgnoreTabChange(false);
            if (!bl2) {
                this.clearConnectIsInProgress();
            }
        }
    }

    public int findFirstExplorerTab() {
        int n = this.sqlTab.getTabCount();
        if (n <= 0) {
            return -1;
        }
        for (int i = 0; i < n; ++i) {
            Component component = this.sqlTab.getComponentAt(i);
            if (!(component instanceof DbExplorerPanel)) continue;
            return i;
        }
        return -1;
    }

    public void newDbExplorerWindow() {
        boolean bl;
        DbExplorerPanel dbExplorerPanel = new DbExplorerPanel(this);
        dbExplorerPanel.restoreSettings();
        DbExplorerWindow dbExplorerWindow = dbExplorerPanel.openWindow(this.currentProfile);
        boolean bl2 = bl = DbExplorerSettings.getAlwaysUseSeparateConnForDbExpWindow() || this.currentProfile.getUseSeparateConnectionPerTab() || this.currentConnection == null;
        if (bl) {
            dbExplorerPanel.connect(this.currentProfile);
        } else {
            LogMgr.logDebug(new CallerInfo(){}, "Re-using current connection for DbExplorer Window");
            dbExplorerPanel.setConnection(this.currentConnection);
        }
        this.explorerWindows.add(dbExplorerWindow);
    }

    public void explorerWindowClosed(DbExplorerWindow dbExplorerWindow) {
        this.explorerWindows.remove(dbExplorerWindow);
    }

    public void newDbExplorerPanel(boolean bl) {
        DbExplorerPanel dbExplorerPanel = new DbExplorerPanel(this);
        dbExplorerPanel.restoreSettings();
        this.addDbExplorerTab(dbExplorerPanel);
        if (bl) {
            this.sqlTab.setSelectedIndex(this.sqlTab.getTabCount() - 1);
        }
    }

    public ConnectionProfile getCurrentProfile() {
        return this.currentProfile;
    }

    public JMenu buildHelpMenu() {
        WbMenu wbMenu = new WbMenu(ResourceMgr.getString("MnuTxtHelp"));
        wbMenu.setName("MnuTxtHelp");
        new ShowHelpAction().addToMenu(wbMenu);
        new ShowManualAction().addToMenu(wbMenu);
        wbMenu.add(this.showDbmsManual);
        wbMenu.add(this.connectionInfoAction);
        wbMenu.addSeparator();
        wbMenu.add(new HelpContactAction(this));
        wbMenu.add(WhatsNewAction.getInstance());
        wbMenu.addSeparator();
        wbMenu.add(ViewLogfileAction.getInstance());
        wbMenu.add(new VersionCheckAction());
        wbMenu.add(new AboutAction(this));
        return wbMenu;
    }

    public JMenu buildToolsMenu() {
        WbMenu wbMenu = new WbMenu(ResourceMgr.getString("MnuTxtTools"));
        wbMenu.setName("MnuTxtTools");
        wbMenu.add(this.dbExplorerAction);
        wbMenu.add(this.newDbExplorerPanel);
        wbMenu.add(this.newDbExplorerWindow);
        if (this.showDbTree != null) {
            wbMenu.add(this.showDbTree);
        }
        wbMenu.addSeparator();
        wbMenu.add(new DataPumperAction(this));
        wbMenu.add(new ObjectSearchAction(this));
        wbMenu.addSeparator();
        wbMenu.add(new BookmarksAction(this));
        wbMenu.add(new SearchAllEditorsAction(this));
        WbMenu wbMenu2 = new WbMenu(ResourceMgr.getString("MnuTxtTabHistory"));
        wbMenu2.setName("MnuTxtTabHistory");
        wbMenu.add(wbMenu2);
        wbMenu.addSeparator();
        new OptionsDialogAction().addToMenu(wbMenu);
        new ConfigureShortcutsAction().addToMenu(wbMenu);
        new ConfigureToolbarAction().addToMenu(wbMenu);
        return wbMenu;
    }

    private boolean checkMakeProfileWorkspace() {
        boolean bl = false;
        boolean bl2 = WbSwingUtilities.getYesNo(this, ResourceMgr.getString("MsgAttachWorkspaceToProfile"));
        if (bl2) {
            this.assignWorkspace();
            bl = true;
        }
        return bl;
    }

    private void resetTabTitles() {
        String string = ResourceMgr.getDefaultTabLabel();
        int n = this.sqlTab.getTabCount();
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            this.getSqlPanel(i).ifPresent(sqlPanel -> {
                sqlPanel.closeFile(true, false);
                this.setTabTitle(n2, string);
            });
        }
    }

    public boolean isCancelling() {
        int n = this.sqlTab.getTabCount();
        for (int i = 0; i < n; ++i) {
            if (!this.getPanel(i).map(MainPanel::isCancelling).orElse(false).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isConnected() {
        if (this.currentConnection != null) {
            return true;
        }
        int n = this.sqlTab.getTabCount();
        for (int i = 0; i < n; ++i) {
            if (!this.getPanel(i).map(MainPanel::isConnected).orElse(false).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isBusy() {
        int n = this.sqlTab.getTabCount();
        for (int i = 0; i < n; ++i) {
            if (!this.getPanel(i).map(MainPanel::isBusy).orElse(false).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public void replaceWorkspaceVariables(Properties properties) {
        if (this.currentWorkspace == null) {
            return;
        }
        this.currentWorkspace.setVariables(properties);
    }

    public Properties getCurrentWorkspaceVariables() {
        if (this.currentWorkspace == null) {
            return null;
        }
        return this.currentWorkspace.getVariables();
    }

    public String getCurrentWorkspaceFile() {
        if (this.currentWorkspace == null) {
            return null;
        }
        return this.currentWorkspace.getFilename();
    }

    public void loadWorkspace() {
        this.saveWorkspace();
        FileDialogUtil fileDialogUtil = new FileDialogUtil();
        String string = fileDialogUtil.getWorkspaceFilename(this, false, true);
        if (string == null) {
            return;
        }
        boolean bl = this.loadWorkspace(string, true);
        if (bl && Settings.getInstance().getBoolProperty("workbench.gui.workspace.load.askassign", true)) {
            this.checkMakeProfileWorkspace();
        }
        WbSwingUtilities.repaintLater(this);
    }

    private void closeWorkspace() {
        this.closeWorkspace(false);
    }

    public boolean closeWorkspace(boolean bl) {
        if (bl) {
            int n = this.sqlTab.getTabCount();
            boolean bl2 = true;
            boolean bl3 = this.currentConnection != null;
            for (int i = 0; i < n; ++i) {
                Optional<MainPanel> optional = this.getPanel(i);
                if (bl3) {
                    boolean bl4 = bl2 = i == 0;
                }
                if (!optional.isPresent() || optional.get().canClosePanel(bl2)) continue;
                return false;
            }
        }
        WbSwingUtilities.invoke(() -> {
            try {
                this.removeAllPanels(true);
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error when resetting workspace", exception);
            }
            this.updateWindowTitle();
            this.checkWorkspaceActions();
        });
        if (this.currentWorkspace != null) {
            VariablePool.getInstance().removeVariables(this.currentWorkspace.getVariables());
        }
        this.currentWorkspace = null;
        return true;
    }

    public void assignWorkspace() {
        if (this.currentWorkspace == null) {
            return;
        }
        if (this.currentProfile == null) {
            return;
        }
        String string = FileDialogUtil.removeConfigDir(this.currentWorkspace.getFilename());
        this.currentProfile.setWorkspaceFile(string);
        ConnectionProfile connectionProfile = ConnectionMgr.getInstance().getProfile(this.currentProfile.getKey());
        if (connectionProfile != null) {
            connectionProfile.setWorkspaceFile(string);
        }
        this.updateWindowTitle();
    }

    public boolean saveWorkspace() {
        return this.saveWorkspace(true);
    }

    public boolean saveWorkspace(boolean bl) {
        if (this.currentWorkspace != null) {
            return this.saveWorkspace(this.currentWorkspace.getFilename(), bl);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveWorkspace(String string, boolean bl) {
        if (this.workspaceIsSaving) {
            LogMgr.logWarning(new CallerInfo(){}, "Workspace is being saved. Ignoring this save request.");
            return false;
        }
        Object object = this.workspaceLock;
        synchronized (object) {
            boolean bl2;
            try {
                this.workspaceIsSaving = true;
                bl2 = this._doSaveWorkspace(string, bl);
                this.workspaceIsSaving = false;
            }
            catch (Throwable throwable) {
                this.workspaceIsSaving = false;
                throw throwable;
            }
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _doSaveWorkspace(String string, boolean bl) {
        Object object;
        int n;
        int n2;
        boolean bl2;
        Object object2;
        if (!WbManager.getInstance().getSettingsShouldBeSaved()) {
            return true;
        }
        CallerInfo callerInfo = new CallerInfo(){};
        if (this.currentWorkspace != null && this.currentWorkspace.isOpen()) {
            LogMgr.logWarning(callerInfo, "Current workspace " + this.currentWorkspace.getFilename() + " is already open in window \"" + this.getTitle() + "\". Can't save it now.", new Exception("Backtrace"));
            return true;
        }
        boolean bl3 = false;
        if (string == null) {
            bl3 = true;
            object2 = new FileDialogUtil();
            string = ((FileDialogUtil)object2).getWorkspaceFilename(this, true, true);
            if (string == null) {
                return true;
            }
        }
        object2 = this.getRealWorkspaceFilename(string);
        WbFile wbFile = new WbFile((String)object2);
        if (this.currentWorkspace == null) {
            this.currentWorkspace = new WbWorkspace((String)object2);
        } else {
            this.currentWorkspace.setFilename((String)object2);
            this.currentWorkspace.prepareForSaving();
        }
        long l = System.currentTimeMillis();
        File file = null;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = bl2 = !Settings.getInstance().getCreateWorkspaceBackup();
        if (Settings.getInstance().getCreateWorkspaceBackup()) {
            n2 = Settings.getInstance().getMaxBackupFiles();
            String string2 = Settings.getInstance().getBackupDir();
            n = Settings.getInstance().getFileVersionDelimiter();
            object = new FileVersioner(n2, string2, (char)n);
            try {
                file = ((FileVersioner)object).createBackup(wbFile);
            }
            catch (IOException iOException) {
                LogMgr.logWarning(callerInfo, "Error when creating backup file!", iOException);
                bl2 = true;
            }
        }
        if (bl2) {
            file = wbFile.makeBackup();
            LogMgr.logDebug(callerInfo, "Created temporary backup file: " + file);
            bl4 = true;
        }
        this.showMacroPopup.saveWorkspaceSettings();
        this.getToolProperties(DB_TREE_PROPS).setProperty("tree.visible", this.isDbTreeVisible());
        if (this.treePanel != null) {
            this.treePanel.saveSettings(this.getToolProperties(DB_TREE_PROPS));
        }
        try {
            n2 = this.sqlTab.getTabCount();
            if (bl) {
                boolean bl7 = true;
                for (n = 0; n < n2; ++n) {
                    object = (MainPanel)((Object)this.sqlTab.getComponentAt(n));
                    if (this.currentConnection != null) {
                        boolean bl8 = bl7 = n == 0;
                    }
                    if (object.canClosePanel(bl7)) continue;
                    boolean bl9 = false;
                    return bl9;
                }
            }
            this.currentWorkspace.setSelectedTab(this.sqlTab.getSelectedIndex());
            this.currentWorkspace.setEntryCount(n2);
            for (int i = 0; i < n2; ++i) {
                Optional<MainPanel> optional = this.getPanel(i);
                if (!optional.isPresent()) continue;
                optional.get().storeInWorkspace(this.currentWorkspace, i);
            }
            this.currentWorkspace.openForWriting();
            this.currentWorkspace.save();
            long l2 = System.currentTimeMillis() - l;
            LogMgr.logDebug(callerInfo, "Workspace " + wbFile + " saved in " + l2 + "ms");
            if (bl4 && file != null) {
                LogMgr.logDebug(callerInfo, "Deleting temporary backup file: " + file.getAbsolutePath());
                file.delete();
            }
        }
        catch (Throwable throwable) {
            LogMgr.logError(callerInfo, "Error saving workspace: " + (String)object2, throwable);
            WbSwingUtilities.showErrorMessage(this, ResourceMgr.getString("ErrSavingWorkspace") + "\n" + ExceptionUtil.getDisplay(throwable));
            bl5 = true;
        }
        finally {
            FileUtil.closeQuietely(this.currentWorkspace);
        }
        if (bl5 && file != null) {
            LogMgr.logWarning(callerInfo, "Restoring the old workspace file from backup: " + file.getAbsolutePath());
            FileUtil.copySilently(file, wbFile);
        }
        if (bl3) {
            this.checkMakeProfileWorkspace();
            RecentFileManager.getInstance().workspaceLoaded(wbFile);
            EventQueue.invokeLater(this::updateRecentWorkspaces);
        }
        this.updateWindowTitle();
        this.checkWorkspaceActions();
        return true;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.sqlTab) {
            if (this.ignoreTabChange) {
                return;
            }
            int n = this.sqlTab.getSelectedIndex();
            this.tabSelected(n);
        } else if (changeEvent.getSource() == ShortcutManager.getInstance()) {
            this.updateViewShortcuts();
        }
    }

    public MainPanel insertTab() {
        return this.addTab(true, true, false, true);
    }

    public MainPanel addTab() {
        return this.addTab(true, true, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MainPanel addTab(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n = -1;
        if (bl3) {
            n = this.findFirstExplorerTab();
            if (n < this.sqlTab.getTabCount() - 1) {
                n = -1;
            }
        } else {
            n = this.sqlTab.getSelectedIndex() + 1;
        }
        try {
            this.setIgnoreTabChange(true);
            MainPanel mainPanel = this.addTabAtIndex(bl, bl2, bl4, n);
            if (bl) {
                this.currentTabChanged();
            }
            MainPanel mainPanel2 = mainPanel;
            return mainPanel2;
        }
        finally {
            this.setIgnoreTabChange(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlPanel restoreTab(int n) {
        try {
            this.setIgnoreTabChange(true);
            MainPanel mainPanel = this.addTabAtIndex(true, true, true, n);
            this.currentTabChanged();
            SqlPanel sqlPanel = (SqlPanel)mainPanel;
            return sqlPanel;
        }
        finally {
            this.setIgnoreTabChange(false);
        }
    }

    private MainPanel addTabAtIndex(boolean bl, boolean bl2, boolean bl3, int n) {
        SqlPanel sqlPanel = new SqlPanel(this.getMacroClientId());
        sqlPanel.registerObjectFinder(this.treePanel);
        this.addTabAtIndex(sqlPanel, bl, bl2, bl3, n);
        return sqlPanel;
    }

    private void addTabAtIndex(SqlPanel sqlPanel, boolean bl, boolean bl2, boolean bl3, int n) {
        if (n == -1) {
            n = this.sqlTab.getTabCount();
        }
        sqlPanel.setConnectionClient(this);
        sqlPanel.addDbExecutionListener(this);
        sqlPanel.addFilenameChangeListener(this);
        this.sqlTab.add((Component)sqlPanel, n);
        sqlPanel.setTabTitle(this.sqlTab, n);
        JMenuBar jMenuBar = this.createMenuForPanel(sqlPanel);
        this.panelMenus.add(n, jMenuBar);
        if (bl2) {
            this.checkConnectionForPanel(Optional.of(sqlPanel));
        }
        this.setMacroMenuEnabled(sqlPanel.isConnected());
        if (bl3) {
            this.renumberTabs();
        }
        sqlPanel.initDivider(this.sqlTab.getHeight() - this.sqlTab.getTabHeight());
        if (bl) {
            this.sqlTab.setSelectedIndex(n);
        }
        if (this.sqlTab.getTabCount() > 0) {
            this.sqlTab.setCloseButtonEnabled(0, this.sqlTab.getTabCount() > 1);
        }
    }

    public void jumpToBookmark(NamedScriptLocation namedScriptLocation) {
        if (namedScriptLocation == null) {
            return;
        }
        int n = this.getTabIndexById(namedScriptLocation.getTabId());
        if (n < 0) {
            LogMgr.logWarning(new CallerInfo(){}, "Tab with ID=" + namedScriptLocation.getTabId() + " not found!");
            return;
        }
        Optional<MainPanel> optional = this.getPanel(n);
        boolean bl = n != this.sqlTab.getSelectedIndex();
        EventQueue.invokeLater(() -> {
            if (bl) {
                this.selectTab(n);
                this.invalidate();
            }
            optional.ifPresent(mainPanel -> mainPanel.jumpToBookmark(namedScriptLocation));
        });
    }

    public String getTabTitle(int n) {
        return this.getPanel(n).map(MainPanel::getTabTitle).orElse(null);
    }

    private int getTabIndexById(String string) {
        int n = this.sqlTab.getTabCount();
        for (int i = 0; i < n; ++i) {
            String string2 = this.getPanel(i).map(MainPanel::getId).orElse(null);
            if (string2 == null || !string2.equals(string)) continue;
            return i;
        }
        return -1;
    }

    public String getTabTitleById(String string) {
        int n = this.getTabIndexById(string);
        if (n > -1) {
            return HtmlUtil.cleanHTML(this.sqlTab.getTitleAt(n));
        }
        return null;
    }

    @Override
    public String getCurrentTabTitle() {
        int n = this.sqlTab.getSelectedIndex();
        return this.getTabTitle(n);
    }

    @Override
    public void setCurrentTabTitle(String string) {
        int n = this.sqlTab.getSelectedIndex();
        if (string != null) {
            this.setTabTitle(n, string);
        }
    }

    public void setTabTitle(int n, String string) {
        this.getPanel(n).ifPresent(mainPanel -> {
            mainPanel.setTabName(string);
            mainPanel.setTabTitle(this.sqlTab, n);
            this.updateViewMenu(n, mainPanel.getTabTitle());
        });
    }

    public void removeLastTab(boolean bl) {
        int n = this.sqlTab.getTabCount() - 1;
        if (!bl) {
            while (this.getPanel(n).get() instanceof DbExplorerPanel) {
                --n;
            }
        }
        this.tabCloseButtonClicked(n);
    }

    public boolean canCloseTab() {
        int n = this.sqlTab.getSelectedIndex();
        return this.canCloseTab(n);
    }

    @Override
    public boolean canCloseTab(int n) {
        if (n < 0) {
            return false;
        }
        Optional<MainPanel> optional = this.getPanel(n);
        if (!optional.isPresent() || optional.get().isLocked()) {
            return false;
        }
        int n2 = this.sqlTab.getTabCount();
        return n2 > 1;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public boolean canRenameTab() {
        return this.currentWorkspace != null;
    }

    public void removeCurrentTab() {
        int n = this.sqlTab.getSelectedIndex();
        this.tabCloseButtonClicked(n);
    }

    private void renumberTabs() {
        int n;
        int n2 = this.sqlTab.getTabCount();
        for (n = 0; n < n2; ++n) {
            int n3 = n;
            this.getPanel(n).ifPresent(mainPanel -> mainPanel.setTabTitle(this.sqlTab, n3));
        }
        for (n = 0; n < n2; ++n) {
            this.rebuildViewMenu(n);
        }
    }

    private void rebuildViewMenu(int n) {
        JMenu jMenu = this.getViewMenu(n);
        JMenuItem jMenuItem = jMenu.getItem(0);
        while (jMenuItem != null && jMenuItem.getAction() instanceof SelectTabAction) {
            jMenuItem.removeAll();
            jMenu.remove(0);
            jMenuItem = jMenu.getItem(0);
        }
        int n2 = this.sqlTab.getTabCount();
        for (int i = 0; i < n2; ++i) {
            SelectTabAction selectTabAction = new SelectTabAction(this.sqlTab, i);
            selectTabAction.setMenuText(this.getTabTitle(i));
            jMenu.insert(selectTabAction, i);
        }
        if (this.sqlTab.getSelectedIndex() == n) {
            WbSwingUtilities.repaintNow(jMenu);
        }
    }

    public void moveTabLeft() {
        int n = this.getCurrentPanelIndex();
        if (n <= 0) {
            return;
        }
        this.moveTab(n, n - 1);
    }

    public void moveTabRight() {
        int n;
        int n2 = this.getCurrentPanelIndex();
        if (n2 >= (n = this.sqlTab.getTabCount())) {
            return;
        }
        this.moveTab(n2, n2 + 1);
    }

    @Override
    public void moveCancelled() {
    }

    @Override
    public void endMove(int n) {
        this.tabSelected(n);
    }

    @Override
    public boolean startMove(int n) {
        return true;
    }

    private void setIgnoreTabChange(boolean bl) {
        this.ignoreTabChange = bl;
    }

    @Override
    public boolean moveTab(int n, int n2) {
        Optional<MainPanel> optional = this.getPanel(n);
        if (!optional.isPresent()) {
            return false;
        }
        JMenuBar jMenuBar = this.panelMenus.get(n);
        this.sqlTab.remove(n);
        this.panelMenus.remove(n);
        this.panelMenus.add(n2, jMenuBar);
        this.sqlTab.add((Component)((JComponent)((Object)optional.get())), n2);
        this.sqlTab.setSelectedIndex(n2);
        this.renumberTabs();
        this.validate();
        return true;
    }

    @Override
    public void tabCloseButtonClicked(int n) {
        boolean bl;
        Optional<MainPanel> optional = this.getPanel(n);
        if (!optional.map(mainPanel -> mainPanel.canClosePanel(true)).orElse(false).booleanValue()) {
            return;
        }
        if (GuiSettings.getConfirmTabClose() && !(bl = WbSwingUtilities.getYesNo(this.sqlTab, ResourceMgr.getString("MsgConfirmCloseTab")))) {
            return;
        }
        if (GuiSettings.getUseLRUForTabs()) {
            this.tabHistory.restoreLastTab();
        }
        this.removeTab(n, true, true);
    }

    protected void removeTab(int n, boolean bl, boolean bl2) {
        this.getPanel(n).ifPresent(mainPanel -> {
            int n2 = -1;
            boolean bl3 = this.isConnectInProgress();
            if (!bl3) {
                this.setConnectIsInProgress();
            }
            if (bl2) {
                this.closedTabHistory.addToTabHistory((MainPanel)mainPanel, n);
            }
            try {
                this.setIgnoreTabChange(true);
                WbConnection wbConnection = mainPanel.getConnection();
                boolean bl4 = wbConnection != null && !wbConnection.isShared();
                mainPanel.dispose();
                BookmarkManager.getInstance().clearBookmarksForPanel(this.getWindowId(), mainPanel.getId());
                if (bl4) {
                    this.disconnectInBackground(wbConnection);
                }
                this.disposeMenu(this.panelMenus.get(n));
                this.panelMenus.remove(n);
                this.sqlTab.removeTabAt(n);
                if (bl) {
                    this.renumberTabs();
                    n2 = this.sqlTab.getSelectedIndex();
                    if (mainPanel instanceof DbExplorerPanel) {
                        this.restoreDbTree();
                    }
                }
            }
            catch (Throwable throwable) {
                LogMgr.logError(new CallerInfo(){}, "Error removing tab index=" + n, throwable);
            }
            finally {
                this.setIgnoreTabChange(false);
                if (!bl3) {
                    this.clearConnectIsInProgress();
                }
            }
            if (n2 >= 0 && bl) {
                this.tabSelected(n2);
            }
            if (this.sqlTab.getTabCount() > 0) {
                this.sqlTab.setCloseButtonEnabled(0, this.sqlTab.getTabCount() > 1);
            }
            this.updateTabHistoryMenu();
        });
    }

    private void disconnectInBackground(final WbConnection wbConnection) {
        if (wbConnection == null) {
            return;
        }
        WbThread wbThread = new WbThread("Disconnect " + wbConnection.getId()){

            @Override
            public void run() {
                try {
                    wbConnection.disconnect();
                }
                catch (Throwable throwable) {
                    LogMgr.logWarning(new CallerInfo(){}, "Error when closing connection");
                }
            }
        };
        wbThread.start();
    }

    private void disposeMenu(JMenuBar jMenuBar) {
        if (jMenuBar == null) {
            return;
        }
        int n = jMenuBar.getMenuCount();
        for (int i = 0; i < n; ++i) {
            JMenu jMenu = jMenuBar.getMenu(i);
            if (jMenu == null) continue;
            jMenu.removeAll();
        }
        jMenuBar.removeAll();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.sqlTab) {
            Point point = mouseEvent.getPoint();
            int n = this.sqlTab.indexAtLocation(point.x, point.y);
            if (mouseEvent.getButton() == 2 && this.canCloseTab()) {
                this.removeCurrentTab();
            }
            if (mouseEvent.getButton() == 3) {
                SqlTabPopup sqlTabPopup = new SqlTabPopup(this);
                sqlTabPopup.show(this.sqlTab, mouseEvent.getX(), mouseEvent.getY());
            } else if (n == -1 && mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                this.addTab();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void executionEnd(WbConnection wbConnection, Object object) {
        this.getJobIndicator().jobEnded();
    }

    @Override
    public void executionStart(WbConnection wbConnection, Object object) {
        if (Settings.getInstance().getAutoSaveWorkspace()) {
            this.saveWorkspace(false);
        }
        this.getJobIndicator().jobStarted();
    }

    private /* synthetic */ void lambda$loadWorkspace$30(WbWorkspace wbWorkspace, boolean bl) {
        this.loadWorkspace(wbWorkspace, bl);
    }

    private static enum LoadWorkspaceChoice {
        CREATE,
        LOAD_OTHER,
        IGNORE;

    }
}

