/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import workbench.db.DbObject;
import workbench.db.DbObjectChanger;
import workbench.db.DbSettings;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.gui.components.WbTable;
import workbench.gui.dbobjects.RunScriptPanel;
import workbench.interfaces.Reloadable;
import workbench.resource.ResourceMgr;
import workbench.storage.DataStore;
import workbench.util.StringUtil;

public class AlterObjectAction
extends WbAction
implements TableModelListener {
    private WbTable tableList;
    private WbConnection dbConnection;
    private Reloadable client;

    public AlterObjectAction(WbTable wbTable) {
        this.tableList = wbTable;
        this.initMenuDefinition("MnuTxtAlterObjects");
        this.tableList.addTableModelListener(this);
        this.checkEnabled();
    }

    public void setReloader(Reloadable reloadable) {
        this.client = reloadable;
    }

    public void setConnection(WbConnection wbConnection) {
        this.dbConnection = wbConnection;
        this.checkEnabled();
    }

    private void checkEnabled() {
        DataStore dataStore = this.tableList != null ? this.tableList.getDataStore() : null;
        boolean bl = dataStore != null ? dataStore.isModified() : false;
        this.setEnabled(bl && this.canAlterChangedTypes());
    }

    private boolean canAlterChangedTypes() {
        Object object;
        DataStore dataStore;
        if (this.dbConnection == null) {
            return false;
        }
        DbSettings dbSettings = this.dbConnection.getDbSettings();
        if (dbSettings == null) {
            return false;
        }
        DataStore dataStore2 = dataStore = this.tableList != null ? this.tableList.getDataStore() : null;
        if (dataStore == null) {
            return false;
        }
        HashMap<DbObject, DbObject> hashMap = new HashMap<DbObject, DbObject>();
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            if (!dataStore.isRowModified(i)) continue;
            object = this.getCurrentDefinition(i);
            TableIdentifier tableIdentifier = this.getOldDefintion(i);
            hashMap.put(tableIdentifier, (DbObject)object);
        }
        DbObjectChanger dbObjectChanger = new DbObjectChanger(this.dbConnection);
        object = dbObjectChanger.getAlterScript(hashMap);
        return StringUtil.isNonEmpty((CharSequence)object);
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        String string = this.getScript();
        if (string == null) {
            WbSwingUtilities.showErrorMessageKey(this.tableList, "MsgNoAlterAvailable");
        }
        RunScriptPanel runScriptPanel = new RunScriptPanel(this.dbConnection, string);
        runScriptPanel.openWindow(this.tableList, ResourceMgr.getString("TxtAlterTable"));
        if (runScriptPanel.wasRun() && this.client != null) {
            EventQueue.invokeLater(this.client::reload);
        }
    }

    private String getScript() {
        DataStore dataStore = this.tableList.getDataStore();
        DbObjectChanger dbObjectChanger = new DbObjectChanger(this.dbConnection);
        HashMap<DbObject, DbObject> hashMap = new HashMap<DbObject, DbObject>();
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            TableIdentifier tableIdentifier = this.getOldDefintion(i);
            TableIdentifier tableIdentifier2 = this.getCurrentDefinition(i);
            hashMap.put(tableIdentifier, tableIdentifier2);
        }
        return dbObjectChanger.getAlterScript(hashMap);
    }

    private TableIdentifier getCurrentDefinition(int n) {
        if (this.tableList == null) {
            return null;
        }
        DataStore dataStore = this.tableList.getDataStore();
        String string = dataStore.getValueAsString(n, 0);
        String string2 = dataStore.getValueAsString(n, 3);
        String string3 = dataStore.getValueAsString(n, 2);
        String string4 = dataStore.getValueAsString(n, 1);
        String string5 = dataStore.getValueAsString(n, 4);
        TableIdentifier tableIdentifier = new TableIdentifier(string3, string2, string);
        tableIdentifier.setType(string4);
        tableIdentifier.setNeverAdjustCase(true);
        tableIdentifier.setComment(string5);
        return tableIdentifier;
    }

    private TableIdentifier getOldDefintion(int n) {
        if (this.tableList == null) {
            return null;
        }
        DataStore dataStore = this.tableList.getDataStore();
        String string = (String)dataStore.getOriginalValue(n, 0);
        String string2 = (String)dataStore.getOriginalValue(n, 3);
        String string3 = (String)dataStore.getOriginalValue(n, 2);
        String string4 = (String)dataStore.getOriginalValue(n, 1);
        String string5 = (String)dataStore.getOriginalValue(n, 4);
        TableIdentifier tableIdentifier = new TableIdentifier(string3, string2, string);
        tableIdentifier.setType(string4);
        tableIdentifier.setNeverAdjustCase(true);
        tableIdentifier.setComment(string5);
        return tableIdentifier;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == 0) {
            this.checkEnabled();
        }
    }

    @Override
    public boolean useInToolbar() {
        return false;
    }
}

