/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.KeyStroke;
import workbench.gui.actions.WbAction;
import workbench.interfaces.TextContainer;
import workbench.util.StringUtil;

public class CleanJavaCodeAction
extends WbAction {
    protected TextContainer client;

    public CleanJavaCodeAction(TextContainer textContainer) {
        this.client = textContainer;
        this.initMenuDefinition("MnuTxtCleanJavaCode", KeyStroke.getKeyStroke(76, 8));
        this.setMenuItemName("MnuTxtSQL");
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        String string;
        boolean bl = true;
        String string2 = this.client.getSelectedText();
        if (string2 == null || string2.length() == 0) {
            string2 = this.client.getText();
            bl = false;
        }
        if ((string = this.cleanJavaString(string2)) != null && string.length() > 0) {
            final boolean bl2 = bl;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (bl2) {
                        CleanJavaCodeAction.this.client.setSelectedText(string);
                    } else {
                        CleanJavaCodeAction.this.client.setText(string);
                    }
                }
            });
        }
    }

    public String cleanJavaString(String string) {
        if (StringUtil.isEmptyString(string)) {
            return "";
        }
        Pattern pattern = Pattern.compile("\\\\n|\\\\r");
        String[] stringArray = StringUtil.PATTERN_CRLF.split(string);
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i];
            if (string2 == null) continue;
            if (string2.trim().startsWith("//")) {
                string2 = string2.replaceFirst("//", "--");
            } else {
                string2 = string2.trim();
                int n2 = string2.indexOf("\"");
                int n3 = string2.lastIndexOf("\"");
                if (n3 == n2) {
                    n2 = 1;
                }
                if (n3 == 0) {
                    n3 = string2.length() - 1;
                }
                if (n2 > -1) {
                    ++n2;
                }
                if (n2 > -1 && n3 > -1) {
                    string2 = string2.substring(n2, n3);
                }
            }
            Matcher matcher = pattern.matcher(string2);
            string2 = matcher.replaceAll("");
            string2 = StringUtil.replace(string2, "\\\"", "\"");
            stringBuilder.append(string2);
            if (i >= n - 1) continue;
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }
}

