/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import workbench.db.ColumnDropper;
import workbench.db.ColumnIdentifier;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.sqltemplates.ColumnChanger;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.gui.components.DataStoreTableModel;
import workbench.gui.components.ExecuteSqlPanel;
import workbench.gui.components.WbTable;
import workbench.gui.dbobjects.RunScriptPanel;
import workbench.interfaces.Reloadable;
import workbench.resource.ResourceMgr;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class ColumnAlterAction
extends WbAction
implements TableModelListener {
    private WbTable definition;
    private TableIdentifier sourceTable;
    private WbConnection dbConnection;
    private Reloadable client;

    public ColumnAlterAction(WbTable wbTable) {
        this.definition = wbTable;
        this.initMenuDefinition("MnuTxtRunAlter");
        this.setEnabled(false);
        this.definition.addTableModelListener(this);
    }

    @Override
    public void dispose() {
        if (this.definition != null) {
            this.definition.removeTableModelListener(this);
        }
        super.dispose();
    }

    public void setReloader(Reloadable reloadable) {
        this.client = reloadable;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.definition.isReadOnly()) {
            return;
        }
        if (!this.isTable()) {
            this.setEnabled(false);
            return;
        }
        DataStoreTableModel dataStoreTableModel = (DataStoreTableModel)tableModelEvent.getSource();
        if (dataStoreTableModel.getDataStore().isModified()) {
            this.setEnabled(this.sourceTable != null);
        }
    }

    public void setSourceTable(WbConnection wbConnection, TableIdentifier tableIdentifier) {
        this.dbConnection = wbConnection;
        this.sourceTable = tableIdentifier;
    }

    private boolean isTable() {
        if (this.dbConnection == null) {
            return false;
        }
        if (this.sourceTable == null) {
            return false;
        }
        return this.dbConnection.getDbSettings().columnCommentAllowed(this.sourceTable.getType());
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        Object object;
        if (this.definition == null) {
            return;
        }
        this.definition.stopEditing();
        String string = this.getScript();
        if (string == null) {
            object = ResourceMgr.getString("MsgNoAlterAvailable");
            WbSwingUtilities.showMessage(this.definition, object);
        }
        object = new RunScriptPanel(this.dbConnection, string);
        ((RunScriptPanel)object).openWindow(this.definition, ResourceMgr.getString("TxtAlterTable"));
        if (((RunScriptPanel)object).wasRun() && ((ExecuteSqlPanel)object).isSuccess() && this.client != null) {
            EventQueue.invokeLater(this.client::reload);
        }
    }

    private String getScript() {
        Object object;
        int n;
        DataStore dataStore = this.definition.getDataStore();
        ColumnChanger columnChanger = new ColumnChanger(this.dbConnection);
        StringBuilder stringBuilder = new StringBuilder(200);
        for (n = 0; n < dataStore.getRowCount(); ++n) {
            ColumnIdentifier columnIdentifier;
            object = this.getOldDefintion(n);
            String string = columnChanger.getAlterScript(this.sourceTable, (ColumnIdentifier)object, columnIdentifier = this.getCurrentDefinition(n));
            if (string == null) continue;
            stringBuilder.append(string);
        }
        n = dataStore.getDeletedRowCount();
        if (n > 0) {
            object = CollectionUtil.arrayList();
            for (int i = 0; i < n; ++i) {
                object.add(this.getDeletedColumn(i));
            }
            List<String> list = ColumnDropper.getSql(this.sourceTable, (List<ColumnIdentifier>)object, this.dbConnection);
            for (String string : list) {
                stringBuilder.append(string);
                if (!string.endsWith(";")) {
                    stringBuilder.append(';');
                }
                stringBuilder.append('\n');
            }
        }
        if (this.dbConnection.generateCommitForDDL()) {
            stringBuilder.append("\nCOMMIT;\n");
        }
        return stringBuilder.toString();
    }

    private ColumnIdentifier getDeletedColumn(int n) {
        if (this.definition == null) {
            return null;
        }
        DataStore dataStore = this.definition.getDataStore();
        String string = (String)dataStore.getDeletedValue(n, 0);
        String string2 = (String)dataStore.getDeletedValue(n, 1);
        String string3 = (String)dataStore.getDeletedValue(n, 4);
        String string4 = (String)dataStore.getDeletedValue(n, 3);
        String string5 = (String)dataStore.getDeletedValue(n, 7);
        ColumnIdentifier columnIdentifier = new ColumnIdentifier(string);
        columnIdentifier.setDbmsType(string2);
        columnIdentifier.setDefaultValue(string3);
        if (StringUtil.isNonBlank(string4)) {
            columnIdentifier.setIsNullable(StringUtil.stringToBool(string4));
        }
        columnIdentifier.setComment(string5);
        return columnIdentifier;
    }

    private ColumnIdentifier getCurrentDefinition(int n) {
        if (this.definition == null) {
            return null;
        }
        DataStore dataStore = this.definition.getDataStore();
        String string = dataStore.getValueAsString(n, 0);
        String string2 = dataStore.getValueAsString(n, 1);
        String string3 = dataStore.getValueAsString(n, 4);
        String string4 = dataStore.getValueAsString(n, 3);
        String string5 = dataStore.getValueAsString(n, 7);
        ColumnIdentifier columnIdentifier = new ColumnIdentifier(string);
        columnIdentifier.setDbmsType(string2);
        columnIdentifier.setDefaultValue(string3);
        if (StringUtil.isNonBlank(string4)) {
            columnIdentifier.setIsNullable(StringUtil.stringToBool(string4));
        }
        columnIdentifier.setComment(string5);
        return columnIdentifier;
    }

    private ColumnIdentifier getOldDefintion(int n) {
        DataStore dataStore = this.definition.getDataStore();
        if (dataStore.getRowStatus(n) == 2) {
            return null;
        }
        String string = (String)dataStore.getOriginalValue(n, 0);
        String string2 = (String)dataStore.getOriginalValue(n, 1);
        String string3 = (String)dataStore.getOriginalValue(n, 4);
        String string4 = (String)dataStore.getOriginalValue(n, 3);
        String string5 = (String)dataStore.getOriginalValue(n, 7);
        ColumnIdentifier columnIdentifier = new ColumnIdentifier(string);
        columnIdentifier.setDbmsType(string2);
        columnIdentifier.setDefaultValue(string3);
        if (StringUtil.isNonBlank(string4)) {
            columnIdentifier.setIsNullable(StringUtil.stringToBool(string4));
        }
        columnIdentifier.setComment(string5);
        return columnIdentifier;
    }

    @Override
    public boolean useInToolbar() {
        return false;
    }
}

