/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.gui.dbobjects.DbObjectList;
import workbench.gui.dbobjects.TableRowCountPanel;
import workbench.interfaces.WbSelectionListener;
import workbench.interfaces.WbSelectionModel;

public class CountTableRowsAction
extends WbAction
implements WbSelectionListener {
    private JMenuItem menuItem;
    private DbObjectList source;
    private WbSelectionModel selection;

    public CountTableRowsAction(DbObjectList dbObjectList, WbSelectionModel wbSelectionModel) {
        this.initMenuDefinition("MnuTxtCountRows");
        this.source = dbObjectList;
        this.selection = wbSelectionModel;
        this.setVisible(false);
        this.setEnabled(wbSelectionModel.hasSelection());
    }

    public void setVisible(boolean bl) {
        if (this.menuItem == null) {
            this.menuItem = this.getMenuItem();
        }
        this.menuItem.setVisible(bl);
    }

    public void setConnection(WbConnection wbConnection) {
        if (wbConnection != null) {
            this.setVisible(true);
            this.selection.addSelectionListener(this);
            this.checkState();
        } else {
            this.selection.removeSelectionListener(this);
            this.setVisible(false);
            this.setEnabled(false);
        }
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        this.countRows();
    }

    private void countRows() {
        if (!WbSwingUtilities.isConnectionIdle(this.source.getComponent(), this.source.getConnection())) {
            return;
        }
        List<TableIdentifier> list = this.getSelectedObjects();
        if (list == null || list.isEmpty()) {
            return;
        }
        TableRowCountPanel tableRowCountPanel = new TableRowCountPanel(list, this.source.getConnection());
        tableRowCountPanel.showWindow(SwingUtilities.getWindowAncestor(this.source.getComponent()));
    }

    private List<TableIdentifier> getSelectedObjects() {
        List<DbObject> list = this.source.getSelectedObjects();
        if (list == null || list.isEmpty()) {
            return null;
        }
        DbMetadata dbMetadata = this.source.getConnection().getMetadata();
        Set<String> set = dbMetadata.getObjectsWithData();
        ArrayList<TableIdentifier> arrayList = new ArrayList<TableIdentifier>();
        for (DbObject dbObject : list) {
            String string = dbObject.getObjectType();
            if (!set.contains(string) || !(dbObject instanceof TableIdentifier)) continue;
            arrayList.add((TableIdentifier)dbObject);
        }
        return arrayList;
    }

    private void checkState() {
        List<TableIdentifier> list = this.getSelectedObjects();
        this.setEnabled(list != null && list.size() > 0);
    }

    @Override
    public void selectionChanged(WbSelectionModel wbSelectionModel) {
        EventQueue.invokeLater(this::checkState);
    }

    @Override
    public boolean useInToolbar() {
        return false;
    }
}

