/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import workbench.WbManager;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.DropScriptGenerator;
import workbench.db.TableIdentifier;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.gui.dbobjects.DbObjectList;
import workbench.gui.dbobjects.ObjectScripterUI;
import workbench.interfaces.WbSelectionListener;
import workbench.interfaces.WbSelectionModel;
import workbench.util.CollectionUtil;

public class CreateDropScriptAction
extends WbAction
implements WbSelectionListener {
    private DbObjectList source;
    private WbSelectionModel selection;

    public CreateDropScriptAction(DbObjectList dbObjectList, WbSelectionModel wbSelectionModel) {
        this.initMenuDefinition("MnuTxtGenerateDrop");
        this.source = dbObjectList;
        this.selectionChanged(wbSelectionModel);
        this.selection = wbSelectionModel;
        this.selection.addSelectionListener(this);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.selection != null) {
            this.selection.removeSelectionListener(this);
        }
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        if (this.source == null) {
            return;
        }
        if (!WbSwingUtilities.isConnectionIdle(this.source.getComponent(), this.source.getConnection())) {
            return;
        }
        List<DbObject> list = this.source.getSelectedObjects();
        ArrayList<TableIdentifier> arrayList = new ArrayList<TableIdentifier>(list.size());
        DbMetadata dbMetadata = this.source.getConnection().getMetadata();
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        set.addAll(dbMetadata.getTableTypes());
        for (DbObject object2 : list) {
            if (!set.contains(object2.getObjectType())) continue;
            arrayList.add((TableIdentifier)object2);
        }
        DropScriptGenerator dropScriptGenerator = new DropScriptGenerator(this.source.getConnection());
        dropScriptGenerator.setEndTransaction(true);
        if (CreateDropScriptAction.isCtrlPressed(actionEvent)) {
            dropScriptGenerator.setIncludeRecreateStatements(false);
        }
        if (CreateDropScriptAction.isAltPressed(actionEvent)) {
            dropScriptGenerator.setIncludeDropTable(false);
        }
        dropScriptGenerator.setTables(arrayList);
        ObjectScripterUI objectScripterUI = new ObjectScripterUI(dropScriptGenerator);
        objectScripterUI.show(WbManager.getInstance().getCurrentWindow());
    }

    @Override
    public void selectionChanged(WbSelectionModel wbSelectionModel) {
        if (wbSelectionModel.hasSelection()) {
            List<DbObject> list = this.source.getSelectedObjects();
            DbMetadata dbMetadata = this.source.getConnection().getMetadata();
            Set<String> set = CollectionUtil.caseInsensitiveSet();
            set.addAll(dbMetadata.getTableTypes());
            for (DbObject dbObject : list) {
                if (!set.contains(dbObject.getObjectType())) {
                    this.setEnabled(false);
                    return;
                }
                this.setEnabled(true);
            }
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public boolean useInToolbar() {
        return false;
    }
}

