/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DbObject;
import workbench.db.IndexColumn;
import workbench.db.IndexReader;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.gui.dbobjects.DbObjectList;
import workbench.gui.dbobjects.RunScriptPanel;
import workbench.interfaces.IndexChangeListener;
import workbench.resource.ResourceMgr;
import workbench.util.CollectionUtil;

public class CreateIndexAction
extends WbAction {
    private DbObjectList source;
    private WbConnection dbConnection;
    private IndexChangeListener changeListener;

    public CreateIndexAction(DbObjectList dbObjectList, IndexChangeListener indexChangeListener) {
        this.initMenuDefinition("MnuTxtCreateIndex");
        this.source = dbObjectList;
        this.changeListener = indexChangeListener;
        this.setEnabled(false);
    }

    public void setConnection(WbConnection wbConnection) {
        this.dbConnection = wbConnection;
        this.setEnabled(this.dbConnection != null);
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        this.createIndex();
    }

    /*
     * WARNING - void declaration
     */
    protected void createIndex() {
        void var6_11;
        if (this.source == null) {
            return;
        }
        if (!WbSwingUtilities.isConnectionIdle(this.source.getComponent(), this.dbConnection)) {
            return;
        }
        List<DbObject> list = this.source.getSelectedObjects();
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        ArrayList<IndexColumn> arrayList = new ArrayList<IndexColumn>();
        String string = ResourceMgr.getString("TxtNewIndexName");
        TableIdentifier tableIdentifier = this.source.getObjectTable();
        for (DbObject object2 : list) {
            if (!(object2 instanceof ColumnIdentifier)) continue;
            arrayList.add(new IndexColumn(((ColumnIdentifier)object2).getColumnName(), null));
        }
        if (arrayList.isEmpty()) {
            return;
        }
        IndexReader indexReader = this.dbConnection.getMetadata().getIndexReader();
        String string2 = indexReader.buildCreateIndexSql(tableIdentifier, string, false, arrayList);
        if (!string2.trim().endsWith(";")) {
            String string3 = string2 + ";\n";
        }
        String string4 = ResourceMgr.getString("TxtWindowTitleCreateIndex");
        if (this.dbConnection.generateCommitForDDL()) {
            void var6_9;
            String string5 = (String)var6_9 + "\nCOMMIT;\n";
        }
        RunScriptPanel runScriptPanel = new RunScriptPanel(this.dbConnection, (String)var6_11);
        runScriptPanel.openWindow(this.source.getComponent(), string4, string);
        if (runScriptPanel.wasRun() && this.changeListener != null) {
            this.changeListener.indexChanged(tableIdentifier, string);
        }
    }

    @Override
    public boolean useInToolbar() {
        return false;
    }
}

