/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import workbench.db.DbObject;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.gui.dbobjects.DbObjectList;
import workbench.gui.dbobjects.TableDeleterUI;
import workbench.interfaces.TableDeleteListener;
import workbench.interfaces.WbSelectionListener;
import workbench.interfaces.WbSelectionModel;

public class DeleteTablesAction
extends WbAction
implements WbSelectionListener {
    private DbObjectList source;
    private TableDeleteListener deleteListener;
    private WbSelectionModel selection;

    public DeleteTablesAction(DbObjectList dbObjectList, WbSelectionModel wbSelectionModel, TableDeleteListener tableDeleteListener) {
        this.initMenuDefinition("MnuTxtDeleteTableData");
        this.source = dbObjectList;
        this.deleteListener = tableDeleteListener;
        this.selection = wbSelectionModel;
        this.selectionChanged(wbSelectionModel);
        this.selection.addSelectionListener(this);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.selection != null) {
            this.selection.removeSelectionListener(this);
        }
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        boolean bl;
        if (this.source == null) {
            return;
        }
        if (!WbSwingUtilities.isConnectionIdle(this.source.getComponent(), this.source.getConnection())) {
            return;
        }
        List<TableIdentifier> list = this.getSelectedTables();
        final boolean bl2 = this.source.getConnection().getAutoCommit();
        if (bl2 && !this.source.getConnection().getProfile().getAutocommit()) {
            this.source.getConnection().changeAutoCommit(false);
            bl = true;
        } else {
            bl = false;
        }
        TableDeleterUI tableDeleterUI = new TableDeleterUI(){

            @Override
            protected void closeWindow() {
                if (bl) {
                    DeleteTablesAction.this.source.getConnection().changeAutoCommit(bl2);
                }
                super.closeWindow();
            }
        };
        tableDeleterUI.addDeleteListener(this.deleteListener);
        tableDeleterUI.setObjects(list);
        tableDeleterUI.setConnection(this.source.getConnection());
        JFrame jFrame = (JFrame)SwingUtilities.getWindowAncestor(this.source.getComponent());
        tableDeleterUI.showDialog(jFrame);
    }

    private List<TableIdentifier> getSelectedTables() {
        List<DbObject> list = this.source.getSelectedObjects();
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<TableIdentifier> arrayList = new ArrayList<TableIdentifier>(list.size());
        for (DbObject dbObject : list) {
            String string;
            if (!(dbObject instanceof TableIdentifier) || !"table".equalsIgnoreCase(string = dbObject.getObjectType()) && !"view".equalsIgnoreCase(string)) continue;
            arrayList.add((TableIdentifier)dbObject);
        }
        return arrayList;
    }

    @Override
    public void selectionChanged(WbSelectionModel wbSelectionModel) {
        WbConnection wbConnection = this.source.getConnection();
        if (wbConnection == null || wbConnection.isSessionReadOnly()) {
            this.setEnabled(false);
        } else {
            List<TableIdentifier> list = DbObjectList.Util.getSelectedTableObjects(this.source);
            this.setEnabled(list.size() > 0);
        }
    }

    @Override
    public boolean useInToolbar() {
        return false;
    }
}

