/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import workbench.WbManager;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.gui.components.ValidatingDialog;
import workbench.gui.macros.MacroDefinitionPanel;
import workbench.resource.Settings;
import workbench.sql.macros.MacroDefinition;

public class EditMacroAction
extends WbAction {
    private final String windowKey = "workbench.gui.macroeditor";
    private MacroDefinition macro;

    public EditMacroAction() {
        this.setMenuTextByKey("LblEditMacro");
        this.setIcon(null);
        this.setEnabled(false);
    }

    public void setMacro(MacroDefinition macroDefinition) {
        this.macro = macroDefinition;
        this.setEnabled(this.macro != null);
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        if (this.macro == null) {
            return;
        }
        JFrame jFrame = WbManager.getInstance().getCurrentWindow();
        MacroDefinitionPanel macroDefinitionPanel = new MacroDefinitionPanel(null);
        MacroDefinition macroDefinition = this.macro.createCopy();
        macroDefinitionPanel.setMacro(macroDefinition);
        ValidatingDialog validatingDialog = new ValidatingDialog((Frame)jFrame, "Edit macro", (JComponent)macroDefinitionPanel);
        if (!Settings.getInstance().restoreWindowSize(validatingDialog, "workbench.gui.macroeditor")) {
            validatingDialog.setSize(650, 500);
        }
        WbSwingUtilities.center(validatingDialog, jFrame);
        validatingDialog.setVisible(true);
        Settings.getInstance().storeWindowSize(validatingDialog, "workbench.gui.macroeditor");
        if (!validatingDialog.isCancelled()) {
            macroDefinitionPanel.applyChanges();
            macroDefinition.copyTo(this.macro);
        }
    }

    @Override
    public boolean useInToolbar() {
        return false;
    }
}

