/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.gui.components.ValidatingDialog;
import workbench.gui.sql.SqlPanel;
import workbench.resource.ResourceMgr;
import workbench.sql.parser.ScriptParser;
import workbench.util.StringUtil;

public class JumpToStatement
extends WbAction {
    private SqlPanel client;

    public JumpToStatement(SqlPanel sqlPanel) {
        this.initMenuDefinition("MnuTxtJumpToStatementNr", KeyStroke.getKeyStroke(74, 2));
        this.setMenuItemName("MnuTxtSQL");
        this.client = sqlPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        ScriptParser scriptParser = ScriptParser.createScriptParser(this.client.getConnection());
        scriptParser.setScript(this.client.getText());
        int n2 = scriptParser.getSize();
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setEditable(true);
        for (n = 0; n < n2; ++n) {
            jComboBox.addItem(Integer.toString(n + 1));
        }
        n = scriptParser.getCommandIndexAtCursorPos(this.client.getEditor().getCaretPosition());
        jComboBox.setSelectedItem(Integer.toString(n + 1));
        jComboBox.setMinimumSize(new Dimension(50, 24));
        boolean bl = ValidatingDialog.showConfirmDialog(SwingUtilities.getWindowAncestor(this.client), jComboBox, ResourceMgr.getString("TxtJumpTo"));
        if (!bl) {
            return;
        }
        String string = jComboBox.getSelectedItem().toString();
        if (StringUtil.isBlank(string)) {
            return;
        }
        int n3 = Integer.valueOf(string);
        int n4 = scriptParser.getStartPosForCommand(n3 - 1);
        EventQueue.invokeLater(() -> this.client.getEditor().setCaretPosition(n4));
    }
}

