/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import workbench.gui.actions.WbAction;
import workbench.gui.components.WbTable;
import workbench.print.PrintPreview;
import workbench.print.TablePrinter;

public class PrintPreviewAction
extends WbAction
implements TableModelListener {
    private WbTable client;

    public PrintPreviewAction(WbTable wbTable) {
        this.setClient(wbTable);
        this.initMenuDefinition("MnuTxtPrintPreview");
        this.setMenuItemName("MnuTxtFile");
        this.setEnabled(false);
        this.setIcon("print-preview");
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        Window window = SwingUtilities.getWindowAncestor(this.client);
        JFrame jFrame = null;
        if (window instanceof JFrame) {
            jFrame = (JFrame)window;
        }
        TablePrinter tablePrinter = new TablePrinter(this.client);
        PrintPreview printPreview = new PrintPreview(jFrame, tablePrinter);
        printPreview.setVisible(true);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.setEnabled(this.client.getRowCount() > 0);
    }

    public void setClient(WbTable wbTable) {
        if (this.client != null) {
            this.client.removeTableModelListener(this);
        }
        this.client = wbTable;
        if (this.client != null) {
            this.client.addTableModelListener(this);
        }
    }
}

