/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import workbench.gui.MainWindow;
import workbench.gui.actions.WbAction;
import workbench.gui.components.WbTable;
import workbench.gui.editor.MacroExpander;
import workbench.gui.macros.MacroRunner;
import workbench.gui.sql.SqlPanel;
import workbench.resource.ResourceMgr;
import workbench.resource.StoreableKeyStroke;
import workbench.sql.macros.MacroDefinition;
import workbench.storage.DataStore;
import workbench.storage.RowData;
import workbench.util.NumberStringCache;
import workbench.util.StringUtil;

public class RunMacroAction
extends WbAction
implements ListSelectionListener {
    private MainWindow client;
    private MacroDefinition macro;
    private WbTable dataTable;
    private Map<String, String> columnMap;
    private static int internalId;

    public RunMacroAction(MainWindow mainWindow, MacroDefinition macroDefinition, int n) {
        this.macro = macroDefinition;
        this.client = mainWindow;
        this.putValue("ActionCommandKey", "run-macro-" + Integer.toString(++internalId));
        if (macroDefinition == null) {
            String string = ResourceMgr.getPlainString("LblRunMacro");
            this.setMenuText(string);
            String string2 = ResourceMgr.getDescription("MnuTxtRunMacro", true);
            string2 = string2.replaceAll("[ ]*(%macro%)[ ]*", " ");
            this.putValue("ShortDescription", string2);
        } else {
            StoreableKeyStroke storeableKeyStroke;
            String string = macroDefinition.getName();
            if (n < 10 && n > 0) {
                string = "&" + NumberStringCache.getNumberString(n) + " - " + macroDefinition.getName();
            }
            if ((storeableKeyStroke = this.macro.getShortcut()) != null) {
                KeyStroke keyStroke = storeableKeyStroke.getKeyStroke();
                this.setAccelerator(keyStroke);
            }
            this.setMenuText(string);
            this.initTooltip();
        }
        this.setMenuItemName("MnuTxtMacro");
        this.setIcon(null);
        this.setEnabled(this.macro != null && this.client != null);
    }

    public void setDataTable(WbTable wbTable, Map<String, String> map) {
        this.dataTable = wbTable;
        this.columnMap = new HashMap<String, String>(map);
        if (this.columnMap == null) {
            this.columnMap = Collections.emptyMap();
        }
        if (this.dataTable != null) {
            this.dataTable.getSelectionModel().addListSelectionListener(this);
            this.setEnabled(this.dataTable.getSelectedRowCount() == 1);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.dataTable != null) {
            this.dataTable.getSelectionModel().removeListSelectionListener(this);
        }
    }

    private void initTooltip() {
        if (this.macro == null) {
            return;
        }
        String string = this.macro.getDisplayTooltip();
        if (string == null) {
            string = ResourceMgr.getDescription("MnuTxtRunMacro", true);
            string = StringUtil.replace(string, "%macro%", "'" + this.macro.getName() + "'");
        }
        this.setTooltip(string);
    }

    public void setMacro(MacroDefinition macroDefinition) {
        this.macro = macroDefinition;
        this.initTooltip();
    }

    private void executeStandardMacro(ActionEvent actionEvent) {
        SqlPanel sqlPanel = this.client.getCurrentSqlPanel();
        if (sqlPanel == null) {
            return;
        }
        if (this.macro.getExpandWhileTyping()) {
            MacroExpander macroExpander = sqlPanel.getEditor().getMacroExpander();
            if (macroExpander != null) {
                macroExpander.insertMacroText(this.macro.getText());
                sqlPanel.selectEditorLater();
            }
        } else {
            boolean bl = RunMacroAction.isShiftPressed(actionEvent) && RunMacroAction.invokedByMouse(actionEvent);
            MacroRunner macroRunner = new MacroRunner();
            macroRunner.runMacro(this.macro, sqlPanel, bl);
        }
    }

    private void executeDataMacro() {
        if (this.dataTable == null) {
            return;
        }
        SqlPanel sqlPanel = this.client.getCurrentSqlPanel();
        if (sqlPanel == null) {
            return;
        }
        int n = this.dataTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        DataStore dataStore = this.dataTable.getDataStore();
        if (dataStore == null) {
            return;
        }
        RowData rowData = dataStore.getRow(n);
        if (rowData == null) {
            return;
        }
        MacroRunner macroRunner = new MacroRunner();
        macroRunner.runDataMacro(this.macro, dataStore.getResultInfo(), rowData, sqlPanel, this.columnMap);
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        if (this.client == null || this.macro == null) {
            return;
        }
        if (this.dataTable != null) {
            this.executeDataMacro();
        } else {
            this.executeStandardMacro(actionEvent);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (this.dataTable == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(this.dataTable.getSelectedRowCount() == 1);
    }

    @Override
    public boolean useInToolbar() {
        return false;
    }
}

