/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.SwingUtilities;
import workbench.db.DbObject;
import workbench.db.ObjectScripter;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.gui.dbobjects.DbObjectList;
import workbench.gui.dbobjects.ObjectScripterUI;
import workbench.interfaces.WbSelectionListener;
import workbench.interfaces.WbSelectionModel;
import workbench.resource.DbExplorerSettings;

public class ScriptDbObjectAction
extends WbAction
implements WbSelectionListener {
    private DbObjectList source;
    private final WbSelectionModel selection;
    private boolean showSinglePackageProcedure;

    public ScriptDbObjectAction(DbObjectList dbObjectList, WbSelectionModel wbSelectionModel) {
        this(dbObjectList, wbSelectionModel, "MnuTxtCreateScript");
    }

    public ScriptDbObjectAction(DbObjectList dbObjectList, WbSelectionModel wbSelectionModel, String string) {
        this.initMenuDefinition(string);
        this.source = dbObjectList;
        this.selection = wbSelectionModel;
        this.checkEnabled();
        this.setIcon("script");
        this.selection.addSelectionListener(this);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.selection != null) {
            this.selection.removeSelectionListener(this);
        }
    }

    public void setShowSinglePackageProcedure(boolean bl) {
        this.showSinglePackageProcedure = bl;
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        if (!WbSwingUtilities.isConnectionIdle(this.source.getComponent(), this.source.getConnection())) {
            return;
        }
        List<DbObject> list = this.source.getSelectedObjects();
        if (list == null || list.isEmpty()) {
            return;
        }
        ObjectScripter objectScripter = new ObjectScripter(list, this.source.getConnection());
        objectScripter.setEndTransaction(true);
        objectScripter.setShowPackageProcedureOnly(this.showSinglePackageProcedure);
        objectScripter.setIncludeForeignKeys(this.source.getConnection().getDbSettings().getGenerateTableFKSource());
        objectScripter.setIncludeGrants(DbExplorerSettings.getGenerateTableGrants());
        ObjectScripterUI objectScripterUI = new ObjectScripterUI(objectScripter);
        if (list.size() == 1) {
            objectScripterUI.setScriptObjectName(list.get(0).getObjectExpression(this.source.getConnection()));
        }
        objectScripterUI.setDbConnection(this.source.getConnection());
        objectScripterUI.show(SwingUtilities.getWindowAncestor(this.source.getComponent()));
    }

    private void checkEnabled() {
        if (this.selection.hasSelection()) {
            List<DbObject> list = this.source.getSelectedObjects();
            for (DbObject dbObject : list) {
                if (dbObject.supportsGetSource()) continue;
                this.setEnabled(false);
                return;
            }
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void selectionChanged(WbSelectionModel wbSelectionModel) {
        this.checkEnabled();
    }

    @Override
    public boolean useInToolbar() {
        return false;
    }
}

