/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.event.ActionEvent;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import workbench.gui.actions.WbAction;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.PlatformShortcuts;
import workbench.resource.ResourceMgr;
import workbench.resource.ShortcutManager;

public class SelectTabAction
extends WbAction {
    private JTabbedPane client;
    private int index;

    public SelectTabAction(JTabbedPane jTabbedPane, int n) {
        this.client = jTabbedPane;
        this.index = n;
        this.setIcon(null);
        this.setMenuText(ResourceMgr.getDefaultTabLabel());
        this.initAccelerator();
    }

    private void initAccelerator() {
        KeyStroke keyStroke = this.getKeyStrokeForIndex(this.index);
        if (ShortcutManager.getInstance().isKeyStrokeAssigned(keyStroke)) {
            this.setAccelerator(null);
        } else {
            this.setAccelerator(keyStroke);
        }
        this.setActionName("SelectTab" + (this.index + 1));
    }

    private KeyStroke getKeyStrokeForIndex(int n) {
        if (n >= 0 && n <= 8) {
            return KeyStroke.getKeyStroke(49 + n, PlatformShortcuts.getDefaultModifier());
        }
        return null;
    }

    public int getIndex() {
        return this.index;
    }

    public void setNewIndex(int n) {
        this.index = n;
        this.initAccelerator();
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        if (this.client != null) {
            try {
                int n = this.client.getTabCount();
                if (n > 0 && this.index < n && this.index > -1) {
                    this.client.setSelectedIndex(this.index);
                }
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error when selecting tab " + this.index, exception);
            }
        }
    }

    @Override
    public boolean useInToolbar() {
        return false;
    }
}

