/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.BrowserLauncher;
import workbench.util.ExceptionUtil;
import workbench.util.StringUtil;
import workbench.util.VersionNumber;

public class ShowDbmsManualAction
extends WbAction {
    private String onlineManualUrl;

    public ShowDbmsManualAction() {
        this.initMenuDefinition("MnuTxtDbmsHelp");
        this.setIcon("dbms-manual");
        this.setEnabled(false);
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        if (StringUtil.isNonBlank(this.onlineManualUrl)) {
            try {
                BrowserLauncher.openURL(this.onlineManualUrl);
            }
            catch (Exception exception) {
                WbSwingUtilities.showErrorMessage(ExceptionUtil.getDisplay(exception));
            }
        }
    }

    public void clearDbms() {
        this.setDbms(null, -1, -1);
    }

    public void setDbms(String string, VersionNumber versionNumber) {
        if (versionNumber == null) {
            this.setDbms(string, -1, -1);
        } else {
            this.setDbms(string, versionNumber.getMajorVersion(), versionNumber.getMinorVersion());
        }
    }

    private void setDbms(String string, int n, int n2) {
        if (StringUtil.isNonBlank(string)) {
            String string2 = null;
            if (n > 0 && n2 > 0) {
                string2 = Settings.getInstance().getProperty("workbench.db." + string + "." + Integer.toString(n) + "." + Integer.toString(n2) + ".manual", null);
            }
            if (string2 == null && n > 0) {
                string2 = Settings.getInstance().getProperty("workbench.db." + string + "." + Integer.toString(n) + ".manual", null);
            }
            if (string2 == null) {
                string2 = Settings.getInstance().getProperty("workbench.db." + string + ".manual", null);
            }
            this.onlineManualUrl = string2 != null ? MessageFormat.format(string2, n, n2) : null;
        } else {
            this.onlineManualUrl = null;
        }
        this.setEnabled(StringUtil.isNonBlank(this.onlineManualUrl));
        if (this.onlineManualUrl != null) {
            this.setTooltip("<html>" + ResourceMgr.getDescription("MnuTxtDbmsHelp") + "<br>(" + this.onlineManualUrl + ")</html>");
        } else {
            this.setTooltip(null);
        }
    }
}

