/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import workbench.db.WbConnection;
import workbench.gui.actions.CheckBoxAction;
import workbench.gui.components.WbToolbarButton;

public class ToggleAutoCommitAction
extends CheckBoxAction
implements PropertyChangeListener {
    private WbConnection connection;
    private JToggleButton toggleButton;

    public ToggleAutoCommitAction() {
        super("MnuTxtToggleAutoCommit", (String)null);
        this.setMenuItemName("MnuTxtSQL");
        this.setIcon("autocommit");
    }

    public void setConnection(WbConnection wbConnection) {
        if (this.connection != null) {
            this.connection.removeChangeListener(this);
        }
        this.connection = wbConnection;
        if (this.connection != null) {
            this.connection.addChangeListener(this);
        }
        this.checkState();
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        if (this.connection != null && this.isEnabled()) {
            this.connection.toggleAutoCommit();
            this.checkState();
        }
    }

    private void checkState() {
        if (this.connection != null) {
            this.setEnabled(true);
            this.setSwitchedOn(this.connection.getAutoCommit());
            if (this.toggleButton != null) {
                this.toggleButton.setSelected(this.isSwitchedOn());
            }
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.connection && "autocommit".equals(propertyChangeEvent.getPropertyName())) {
            this.checkState();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.connection != null) {
            this.connection.removeChangeListener(this);
        }
        if (this.toggleButton != null) {
            this.toggleButton.setAction(null);
            this.toggleButton.setIcon(null);
            this.toggleButton = null;
        }
    }

    @Override
    public void addToToolbar(JToolBar jToolBar) {
        if (this.toggleButton == null) {
            this.createButton();
        }
        jToolBar.add(this.toggleButton);
    }

    private JToggleButton createButton() {
        this.toggleButton = new JToggleButton(this);
        this.toggleButton.setMargin(WbToolbarButton.SMALL_MARGIN);
        ImageIcon imageIcon = this.getToolbarIcon();
        if (imageIcon != null) {
            this.toggleButton.setIcon(imageIcon);
            this.toggleButton.setText(null);
        }
        this.toggleButton.setSelected(this.isSwitchedOn());
        return this.toggleButton;
    }
}

