/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import workbench.gui.WbSwingUtilities;
import workbench.gui.editor.ValuesListCreator;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;

public class ValuesCreatorParameter
extends JPanel
implements DocumentListener {
    private final String delimiterProp = "workbench.gui.values.creator.delimiter";
    private final String regexProp = "workbench.gui.values.creator.regex";
    private final String emptyStringProp = "workbench.gui.values.creator.emptystring.null";
    private final String trimSepProp = "workbench.gui.values.creator.trim.delimiter";
    private String input;
    private JTextField delimiter;
    private JCheckBox emptyString;
    private JCheckBox isRegex;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTextArea previewArea;
    private JButton previewButton;
    private JCheckBox trimDelimiter;

    public ValuesCreatorParameter(String string) {
        this.initComponents();
        this.restoreSettings();
        this.input = string;
        this.previewArea.setFont(Settings.getInstance().getEditorFont());
        this.previewArea.setText(this.input);
        Color color = Settings.getInstance().getEditorBackgroundColor();
        if (color == null) {
            color = this.previewArea.getBackground();
        }
        this.previewArea.setEditable(false);
        this.previewArea.setBackground(color);
        this.previewArea.setForeground(Settings.getInstance().getEditorTextColor());
        this.previewArea.setTabSize(Settings.getInstance().getEditorTabWidth());
        this.delimiter.getDocument().addDocumentListener(this);
        WbSwingUtilities.invokeLater(this::preview);
    }

    public String getDelimiter() {
        return this.delimiter.getText();
    }

    public boolean isRegex() {
        return this.isRegex.isSelected();
    }

    public boolean getEmptyStringIsNull() {
        return this.emptyString.isSelected();
    }

    public boolean getTrimDelimiter() {
        return this.trimDelimiter.isSelected();
    }

    public void setFocusToInput() {
        this.delimiter.requestFocus();
        this.delimiter.selectAll();
    }

    public void restoreSettings() {
        String string = Settings.getInstance().getProperty("workbench.gui.values.creator.delimiter", null);
        this.delimiter.setText(string);
        this.isRegex.setSelected(Settings.getInstance().getBoolProperty("workbench.gui.values.creator.regex", false));
        this.emptyString.setSelected(Settings.getInstance().getBoolProperty("workbench.gui.values.creator.emptystring.null", false));
        this.trimDelimiter.setSelected(Settings.getInstance().getBoolProperty("workbench.gui.values.creator.trim.delimiter", true));
    }

    public void saveSettings() {
        Settings.getInstance().setProperty("workbench.gui.values.creator.delimiter", this.getDelimiter());
        Settings.getInstance().setProperty("workbench.gui.values.creator.regex", this.isRegex());
        Settings.getInstance().setProperty("workbench.gui.values.creator.emptystring.null", this.getEmptyStringIsNull());
        Settings.getInstance().setProperty("workbench.gui.values.creator.trim.delimiter", this.getTrimDelimiter());
    }

    public void preview() {
        ValuesListCreator valuesListCreator = new ValuesListCreator(this.input, this.getDelimiter(), this.isRegex());
        valuesListCreator.setEmptyStringIsNull(this.getEmptyStringIsNull());
        valuesListCreator.setTrimDelimiter(this.getTrimDelimiter());
        valuesListCreator.setLineEnding("\n");
        this.previewArea.setText(valuesListCreator.createValuesList());
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.preview();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.preview();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.preview();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.delimiter = new JTextField();
        this.isRegex = new JCheckBox();
        this.emptyString = new JCheckBox();
        this.trimDelimiter = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.previewArea = new JTextArea();
        this.jSeparator1 = new JSeparator();
        this.previewButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setText(ResourceMgr.getString("LblFieldDelimiter"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        this.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.delimiter, gridBagConstraints);
        this.isRegex.setText(ResourceMgr.getString("LblDelimIsRegex"));
        this.isRegex.setBorder(null);
        this.isRegex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ValuesCreatorParameter.this.isRegexActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.isRegex, gridBagConstraints);
        this.emptyString.setText(ResourceMgr.getString("LblEmptyStringIsNull"));
        this.emptyString.setBorder(null);
        this.emptyString.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ValuesCreatorParameter.this.emptyStringActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.emptyString, gridBagConstraints);
        this.trimDelimiter.setText(ResourceMgr.getString("LblTrimSeparator"));
        this.trimDelimiter.setBorder(null);
        this.trimDelimiter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ValuesCreatorParameter.this.trimDelimiterActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.trimDelimiter, gridBagConstraints);
        this.previewArea.setColumns(60);
        this.previewArea.setRows(10);
        this.jScrollPane1.setViewportView(this.previewArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.previewButton.setText(ResourceMgr.getString("LblPreview"));
        this.previewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ValuesCreatorParameter.this.previewButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.previewButton, gridBagConstraints);
    }

    private void previewButtonActionPerformed(ActionEvent actionEvent) {
        this.preview();
    }

    private void isRegexActionPerformed(ActionEvent actionEvent) {
        this.preview();
    }

    private void emptyStringActionPerformed(ActionEvent actionEvent) {
        this.preview();
    }

    private void trimDelimiterActionPerformed(ActionEvent actionEvent) {
        this.preview();
    }
}

