/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.bookmarks;

import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import workbench.gui.MainWindow;
import workbench.gui.bookmarks.BookmarkGroup;
import workbench.gui.bookmarks.NamedScriptLocation;
import workbench.interfaces.MainPanel;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.storage.DataStore;
import workbench.util.NumberStringCache;
import workbench.util.WbThread;

public class BookmarkManager {
    private final Map<String, Map<String, BookmarkGroup>> bookmarks = new HashMap<String, Map<String, BookmarkGroup>>();

    private BookmarkManager() {
    }

    public static BookmarkManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public synchronized void clearBookmarksForWindow(String string) {
        this.bookmarks.remove(string);
        LogMgr.logDebug(new CallerInfo(){}, "Removed all bookmarks for window: " + string);
    }

    public synchronized void clearBookmarksForPanel(String string, String string2) {
        Map<String, BookmarkGroup> map = this.bookmarks.get(string);
        if (map != null) {
            map.remove(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBookmarks(MainWindow mainWindow) {
        long l = System.currentTimeMillis();
        int n = -1;
        BookmarkManager bookmarkManager = this;
        synchronized (bookmarkManager) {
            n = mainWindow.getTabCount();
            for (int i = 0; i < n; ++i) {
                mainWindow.getPanel(i).filter(MainPanel::supportsBookmarks).ifPresent(mainPanel -> this.updateBookmarks(mainWindow, (MainPanel)mainPanel));
            }
        }
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(new CallerInfo(){}, "Parsing bookmarks for " + n + " tabs took: " + l2 + "ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BookmarkGroup updateBookmarks(MainWindow mainWindow, MainPanel mainPanel) {
        BookmarkGroup bookmarkGroup = null;
        BookmarkManager bookmarkManager = this;
        synchronized (bookmarkManager) {
            List<NamedScriptLocation> list;
            Map map = this.bookmarks.computeIfAbsent(mainWindow.getWindowId(), string -> new HashMap());
            BookmarkGroup bookmarkGroup2 = (BookmarkGroup)map.get(mainPanel.getId());
            long l = 0L;
            if (bookmarkGroup2 != null) {
                l = bookmarkGroup2.creationTime();
            }
            if ((bookmarkGroup2 == null || mainPanel.isModifiedAfter(l)) && (list = mainPanel.getBookmarks()) != null) {
                bookmarkGroup = new BookmarkGroup(list, mainPanel.getId());
                String string2 = mainPanel.getTabTitle();
                if (GuiSettings.getShowTabIndex() && string2.equals(ResourceMgr.getDefaultTabLabel())) {
                    int n = mainWindow.getIndexForPanel(Optional.ofNullable(mainPanel));
                    string2 = string2 + " " + NumberStringCache.getNumberString(n + 1);
                }
                bookmarkGroup.setName(string2);
                map.put(bookmarkGroup.getGroupId(), bookmarkGroup);
            }
        }
        return bookmarkGroup;
    }

    private Optional<Map<String, BookmarkGroup>> getBookMarkGroup(MainWindow mainWindow) {
        return Optional.ofNullable(mainWindow).map(MainWindow::getWindowId).map(this.bookmarks::get);
    }

    public synchronized List<String> getTabs(MainWindow mainWindow) {
        return this.getBookMarkGroup(mainWindow).map(Map::entrySet).map(Collection::stream).map(stream -> stream.filter(entry -> !((BookmarkGroup)entry.getValue()).getBookmarks().isEmpty()).map(Map.Entry::getKey).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public DataStore getAllBookmarks(MainWindow mainWindow) {
        return this.getBookmarks(mainWindow, null);
    }

    public DataStore getBookmarksForTab(MainWindow mainWindow, String string) {
        return this.getBookmarks(mainWindow, string);
    }

    private synchronized DataStore getBookmarks(MainWindow mainWindow, String string) {
        DataStore dataStore = this.createDataStore();
        Optional<Map<String, BookmarkGroup>> optional = this.getBookMarkGroup(mainWindow);
        if (!optional.isPresent()) {
            return dataStore;
        }
        for (BookmarkGroup bookmarkGroup : optional.get().values()) {
            if (string != null && !string.equals(bookmarkGroup.getGroupId())) continue;
            for (NamedScriptLocation namedScriptLocation : bookmarkGroup.getBookmarks()) {
                int n = dataStore.addRow();
                dataStore.setValue(n, 0, (Object)namedScriptLocation.getName());
                dataStore.setValue(n, 1, (Object)bookmarkGroup.getName());
                dataStore.setValue(n, 2, (Object)namedScriptLocation.getLineNumber());
                dataStore.getRow(n).setUserObject(namedScriptLocation);
            }
        }
        return dataStore;
    }

    private DataStore createDataStore() {
        String[] stringArray = new String[]{ResourceMgr.getPlainString("LblBookName"), ResourceMgr.getPlainString("LblBookPanel"), ResourceMgr.getPlainString("LblBookLine")};
        int[] nArray = new int[]{12, 12, 4};
        DataStore dataStore = new DataStore(stringArray, nArray);
        return dataStore;
    }

    public void updateInBackground(MainWindow mainWindow, MainPanel mainPanel, boolean bl) {
        if (mainWindow == null) {
            return;
        }
        if (mainPanel == null) {
            return;
        }
        if (!mainPanel.supportsBookmarks()) {
            return;
        }
        if (bl) {
            this.clearBookmarksForPanel(mainWindow.getWindowId(), mainPanel.getId());
        }
        new WbThread(() -> {
            Instant instant = Instant.now();
            BookmarkGroup bookmarkGroup = this.updateBookmarks(mainWindow, mainPanel);
            Duration duration = Duration.between(instant, Instant.now());
            if (bookmarkGroup != null) {
                LogMgr.logDebug(new CallerInfo(){}, "Panel '" + mainPanel.getTabTitle() + "' was updated in " + duration.toMillis() + "ms (" + bookmarkGroup.getBookmarks().size() + " bookmarks)");
            }
        }, "Update bookmarks for " + mainPanel.getId()).start();
    }

    public void updateInBackground(MainWindow mainWindow) {
        new WbThread(() -> this.updateBookmarks(mainWindow), "Update bookmarks for all tabs").start();
    }

    public void reset() {
        this.bookmarks.clear();
    }

    private static class InstanceHolder {
        private static final BookmarkManager INSTANCE = new BookmarkManager();

        private InstanceHolder() {
        }
    }
}

