/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.bookmarks;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumnModel;
import workbench.gui.MainWindow;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.CheckBoxAction;
import workbench.gui.actions.ReloadAction;
import workbench.gui.bookmarks.BookmarkManager;
import workbench.gui.bookmarks.NamedScriptLocation;
import workbench.gui.bookmarks.TabEntry;
import workbench.gui.components.ColumnWidthOptimizer;
import workbench.gui.components.DataStoreTableModel;
import workbench.gui.components.FlatButton;
import workbench.gui.components.SelectionHandler;
import workbench.gui.components.ValidatingDialog;
import workbench.gui.components.WbCheckBox;
import workbench.gui.components.WbLabel;
import workbench.gui.components.WbScrollPane;
import workbench.gui.components.WbTable;
import workbench.gui.components.WbToolbarButton;
import workbench.gui.components.WbTraversalPolicy;
import workbench.gui.renderer.RendererSetup;
import workbench.interfaces.MainPanel;
import workbench.interfaces.Reloadable;
import workbench.interfaces.ValidatingComponent;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.storage.SortDefinition;
import workbench.storage.filter.ColumnExpression;
import workbench.storage.filter.ContainsComparator;
import workbench.storage.filter.DataRowExpression;
import workbench.storage.filter.ExpressionValue;
import workbench.storage.filter.FilterExpression;
import workbench.util.StringUtil;

public class BookmarkSelector
extends JPanel
implements KeyListener,
MouseListener,
Reloadable,
ActionListener,
ValidatingComponent,
ItemListener {
    private static final String PROP_SORT_DEF = "workbench.gui.bookmarks.sort";
    private static final String PROP_USE_CURRENT_TAB = "workbench.gui.bookmarks.current.tab.default";
    private static final String PROP_SEARCH_NAME = "workbench.gui.bookmarks.search.name";
    private final JTextField filterValue;
    private final JComboBox tabSelector;
    private JLabel info;
    private WbTable bookmarks;
    private WbScrollPane scroll;
    private final MainWindow window;
    private ValidatingDialog dialog;
    private NamedScriptLocation selectedBookmark;
    private SortDefinition savedSort;
    private WbCheckBox searchNameCbx;
    private WbCheckBox useCurrentEditorCbx;
    private int[] initialColumnWidths;
    private CheckBoxAction rememberColumnWidths;
    private CheckBoxAction rememberSort;
    private SelectionHandler keyHandler;

    public BookmarkSelector(MainWindow mainWindow) {
        super(new GridBagLayout());
        this.window = mainWindow;
        this.filterValue = new JTextField();
        this.filterValue.addKeyListener(this);
        this.filterValue.addActionListener(this);
        this.filterValue.setToolTipText(ResourceMgr.getString("TxtBookmarkFilterTip"));
        this.rememberColumnWidths = new CheckBoxAction("MnuTxtBookmarksSaveWidths", "workbench.gui.bookmarks.colwidths.save");
        this.rememberSort = new CheckBoxAction("MnuTxtRememberSort", "workbench.gui.bookmarks.sort.save");
        this.bookmarks = new WbTable(false, false, false){

            @Override
            protected JPopupMenu getHeaderPopup() {
                JPopupMenu jPopupMenu = this.createLimitedHeaderPopup();
                jPopupMenu.addSeparator();
                jPopupMenu.add(BookmarkSelector.this.rememberColumnWidths.getMenuItem());
                jPopupMenu.add(BookmarkSelector.this.rememberSort.getMenuItem());
                return jPopupMenu;
            }
        };
        this.bookmarks.setSelectionMode(0);
        this.bookmarks.setReadOnly(true);
        this.bookmarks.setRendererSetup(new RendererSetup(false));
        this.bookmarks.addMouseListener(this);
        this.bookmarks.setColumnSelectionAllowed(false);
        this.bookmarks.setRowSelectionAllowed(true);
        this.bookmarks.getHeaderRenderer().setUnderlinePK(false);
        this.bookmarks.setSortIgnoreCase(true);
        this.keyHandler = new SelectionHandler(this.bookmarks);
        this.searchNameCbx = new WbCheckBox();
        this.searchNameCbx.setText(ResourceMgr.getString("LblBookFilter"));
        this.searchNameCbx.setSelected(Settings.getInstance().getBoolProperty(PROP_SEARCH_NAME, true));
        this.searchNameCbx.setToolTipText(ResourceMgr.getDescription("LblBookFilter"));
        boolean bl = Settings.getInstance().getBoolProperty(PROP_USE_CURRENT_TAB, true);
        this.useCurrentEditorCbx = new WbCheckBox();
        this.useCurrentEditorCbx.setText(ResourceMgr.getString("LblBookUseCurrent"));
        this.useCurrentEditorCbx.setToolTipText(ResourceMgr.getDescription("LblBookUseCurrent"));
        this.useCurrentEditorCbx.setSelected(bl);
        this.useCurrentEditorCbx.addItemListener(this);
        this.tabSelector = new JComboBox<Object>(this.getTabs());
        if (bl) {
            this.selectCurrentTab();
        }
        this.tabSelector.addActionListener(this);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FocusTraversalPolicy focusTraversalPolicy = BookmarkSelector.this.getFocusTraversalPolicy();
                Component component = focusTraversalPolicy.getComponentAfter(BookmarkSelector.this, BookmarkSelector.this.bookmarks);
                component.requestFocusInWindow();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FocusTraversalPolicy focusTraversalPolicy = BookmarkSelector.this.getFocusTraversalPolicy();
                Component component = focusTraversalPolicy.getComponentBefore(BookmarkSelector.this, BookmarkSelector.this.bookmarks);
                component.requestFocusInWindow();
            }
        };
        InputMap inputMap = this.bookmarks.getInputMap(0);
        inputMap.put(WbSwingUtilities.TAB, "picker-next-comp");
        inputMap.put(WbSwingUtilities.SHIFT_TAB, "picker-prev-comp");
        AbstractAction abstractAction3 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BookmarkSelector.this.selectValueAndClose();
            }
        };
        this.bookmarks.configureEnterKeyAction(abstractAction3);
        this.bookmarks.getActionMap().put("picker-next-comp", abstractAction);
        this.bookmarks.getActionMap().put("picker-prev-comp", abstractAction2);
        this.scroll = new WbScrollPane(this.bookmarks);
        JPanel jPanel = this.createFilterPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.scroll, gridBagConstraints);
        String string = null;
        String string2 = "<tt><b>@";
        String string3 = "</b></tt>";
        string = GuiSettings.getUseResultTagForBookmarks() ? string2 + "WbTag" + string3 + " " + ResourceMgr.getString("TxtOr") + " " + string2 + "WbResult" + string3 : string2 + "WbTag" + string3;
        this.info = new JLabel(ResourceMgr.getFormattedString("TxtBookmarkHelp", string));
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.add((Component)this.info, gridBagConstraints);
        WbTraversalPolicy wbTraversalPolicy = new WbTraversalPolicy();
        wbTraversalPolicy.addComponent(this.tabSelector);
        wbTraversalPolicy.addComponent(this.useCurrentEditorCbx);
        wbTraversalPolicy.addComponent(this.searchNameCbx);
        wbTraversalPolicy.addComponent(this.filterValue);
        this.setFocusCycleRoot(true);
        this.bookmarks.setFocusCycleRoot(false);
        this.setFocusTraversalPolicy(wbTraversalPolicy);
        if (GuiSettings.getSaveBookmarkSort()) {
            String string4 = Settings.getInstance().getProperty(PROP_SORT_DEF, null);
            if (StringUtil.isNonBlank(string4)) {
                this.savedSort = SortDefinition.parseDefinitionString(string4);
                if (this.savedSort != null) {
                    this.savedSort.setIgnoreCase(true);
                } else {
                    LogMgr.logWarning(new CallerInfo(){}, "Invalid sort definition saved: " + string4);
                    this.savedSort = null;
                }
            }
        } else {
            this.savedSort = null;
        }
    }

    private JPanel createFilterPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        WbLabel wbLabel = new WbLabel();
        wbLabel.setText(ResourceMgr.getString("LblFkFilterValue"));
        wbLabel.setToolTipText(this.filterValue.getToolTipText());
        wbLabel.setLabelFor(this.filterValue);
        wbLabel.setBorder(new EmptyBorder(0, 0, 0, 5));
        ReloadAction reloadAction = new ReloadAction(this);
        reloadAction.setTooltip(ResourceMgr.getString("TxtBookmarkReload"));
        FlatButton flatButton = new FlatButton(reloadAction);
        flatButton.setText(null);
        flatButton.setMargin(WbToolbarButton.SMALL_MARGIN);
        WbLabel wbLabel2 = new WbLabel();
        wbLabel2.setText(ResourceMgr.getString("LblBookPanel"));
        wbLabel2.setLabelFor(this.tabSelector);
        wbLabel2.setBorder(new EmptyBorder(2, 0, 0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = new Insets(2, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = insets;
        jPanel.add((Component)wbLabel2, gridBagConstraints);
        Dimension dimension = this.tabSelector.getPreferredSize();
        Dimension dimension2 = new Dimension((int)((double)dimension.width * 1.05), dimension.height);
        this.tabSelector.setMaximumSize(dimension2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        jPanel2.add(this.tabSelector);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(this.useCurrentEditorCbx);
        jPanel2.add(this.searchNameCbx);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = WbSwingUtilities.getEmptyInsets();
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)wbLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 5);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.filterValue, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = insets;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)flatButton, gridBagConstraints);
        return jPanel;
    }

    private Object[] getTabs() {
        List<String> list = BookmarkManager.getInstance().getTabs(this.window);
        ArrayList<TabEntry> arrayList = new ArrayList<TabEntry>();
        arrayList.add(new TabEntry(null, ResourceMgr.getString("LblBookPanelAll"), -1));
        for (String string : list) {
            int n = this.window.getIndexForPanel(string);
            if (n <= -1) continue;
            arrayList.add(new TabEntry(string, this.window.getTabTitle(n), n));
        }
        Collections.sort(arrayList, TabEntry.INDEX_SORTER);
        return arrayList.toArray();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.useCurrentEditorCbx.isSelected()) {
            this.selectCurrentTab();
        } else {
            this.tabSelector.setSelectedIndex(0);
        }
        this.filterValue.setText("");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.tabSelector) {
            this.loadBookmarks();
        }
    }

    @Override
    public void reload() {
        this.saveColumnWidths();
        BookmarkManager.getInstance().clearBookmarksForWindow(this.window.getWindowId());
        BookmarkManager.getInstance().updateBookmarks(this.window);
        this.loadBookmarks();
    }

    public void loadBookmarks() {
        TabEntry tabEntry = (TabEntry)this.tabSelector.getSelectedItem();
        long l = System.currentTimeMillis();
        DataStore dataStore = tabEntry.getId() == null ? BookmarkManager.getInstance().getAllBookmarks(this.window) : BookmarkManager.getInstance().getBookmarksForTab(this.window, tabEntry.getId());
        WbSwingUtilities.showWaitCursorOnWindow(this);
        EventQueue.invokeLater(() -> {
            SortDefinition sortDefinition;
            this.initialColumnWidths = null;
            if (this.savedSort != null) {
                sortDefinition = this.savedSort;
                this.savedSort = null;
            } else {
                sortDefinition = this.bookmarks.getCurrentSortColumns();
            }
            DataStoreTableModel dataStoreTableModel = new DataStoreTableModel(dataStore);
            dataStoreTableModel.setAllowEditing(false);
            this.bookmarks.setModel(dataStoreTableModel, true);
            this.bookmarks.getTableHeader().setReorderingAllowed(false);
            if (dataStore.getRowCount() > 0) {
                if (sortDefinition != null) {
                    dataStoreTableModel.setSortDefinition(sortDefinition);
                } else {
                    dataStoreTableModel.sortByColumn(0, true, false);
                }
                this.handleColumnWidths();
            }
            this.initialColumnWidths = this.getColumnWidths();
            this.keyHandler.selectRow(0);
            long l2 = System.currentTimeMillis() - l;
            LogMgr.logDebug(new CallerInfo(){}, "Loading bookmarks took: " + l2 + "ms");
            this.filterValue.requestFocusInWindow();
            WbSwingUtilities.showDefaultCursorOnWindow(this);
        });
    }

    private void handleColumnWidths() {
        int[] nArray = this.getSavedColumnWidths();
        if (nArray != null && GuiSettings.getSaveBookmarkColWidths()) {
            this.bookmarks.applyColumnWidths(nArray);
        } else {
            ColumnWidthOptimizer columnWidthOptimizer = new ColumnWidthOptimizer(this.bookmarks);
            int n = GuiSettings.getBookmarksMaxColumnWidth();
            int n2 = WbSwingUtilities.calculateCharWidth(this.bookmarks, n);
            columnWidthOptimizer.optimizeAllColWidth(10, n2, true);
        }
    }

    protected void resetFilter() {
        EventQueue.invokeLater(() -> {
            this.filterValue.setText("");
            this.bookmarks.resetFilter();
            this.keyHandler.selectRow(0);
        });
    }

    protected void applyFilter() {
        EventQueue.invokeLater(() -> {
            if (GuiSettings.getSaveBookmarkColWidths()) {
                this.saveColumnWidths();
            }
            ContainsComparator containsComparator = new ContainsComparator();
            FilterExpression filterExpression = this.searchNameCbx.isSelected() ? new ColumnExpression(this.bookmarks.getDataStore().getColumnName(0), containsComparator, this.filterValue.getText()) : new DataRowExpression(containsComparator, this.filterValue.getText());
            ((ExpressionValue)((Object)filterExpression)).setIgnoreCase(true);
            this.bookmarks.applyFilter(filterExpression, false);
            this.handleColumnWidths();
            this.keyHandler.selectRow(0);
        });
    }

    private void selectCurrentTab() {
        int n = this.tabSelector.getItemCount();
        int n2 = this.window.getCurrentPanelIndex();
        for (int i = 0; i < n; ++i) {
            TabEntry tabEntry = (TabEntry)this.tabSelector.getItemAt(i);
            if (tabEntry.getIndex() != n2) continue;
            this.tabSelector.setSelectedItem(tabEntry);
            return;
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.filterValue && keyEvent.getModifiers() == 0) {
            if (keyEvent.getKeyCode() == 27 && StringUtil.isNonBlank(this.filterValue.getText())) {
                keyEvent.consume();
                this.resetFilter();
            } else {
                this.keyHandler.handleKeyPressed(keyEvent);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    private boolean isAltPressed(KeyEvent keyEvent) {
        return (keyEvent.getModifiers() & 8) == 8;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.filterValue) {
            if (keyEvent.getKeyChar() == '\n') {
                this.selectValueAndClose();
            } else if (this.isAltPressed(keyEvent) && keyEvent.getKeyChar() == this.searchNameCbx.getMnemonic()) {
                this.searchNameCbx.setSelected(!this.searchNameCbx.isSelected());
                keyEvent.consume();
            } else if (this.isAltPressed(keyEvent) && keyEvent.getKeyChar() == this.useCurrentEditorCbx.getMnemonic()) {
                this.useCurrentEditorCbx.setSelected(!this.useCurrentEditorCbx.isSelected());
                keyEvent.consume();
            } else {
                this.applyFilter();
            }
        }
    }

    @Override
    public boolean validateInput() {
        if (this.bookmarks.getSelectedRowCount() == 1) {
            this.selectValue();
            return true;
        }
        return false;
    }

    @Override
    public void componentWillBeClosed() {
    }

    @Override
    public void componentDisplayed() {
        this.selectedBookmark = null;
        this.loadBookmarks();
    }

    public void selectValue() {
        int n = this.bookmarks.getSelectedRow();
        this.selectedBookmark = (NamedScriptLocation)this.bookmarks.getDataStore().getRow(n).getUserObject();
    }

    public void selectValueAndClose() {
        this.selectValue();
        this.dialog.approveAndClose();
    }

    private int[] getColumnWidths() {
        TableColumnModel tableColumnModel = this.bookmarks.getColumnModel();
        if (tableColumnModel == null) {
            return null;
        }
        int n = tableColumnModel.getColumnCount();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = tableColumnModel.getColumn(i).getWidth();
        }
        return nArray;
    }

    private void saveColumnWidths() {
        String string = StringUtil.arrayToString(this.getColumnWidths());
        Settings.getInstance().setProperty("workbench.gui.bookmarks.colwidths", string);
    }

    private int[] getSavedColumnWidths() {
        String string = Settings.getInstance().getProperty("workbench.gui.bookmarks.colwidths", null);
        return StringUtil.stringToArray(string);
    }

    private boolean columnWidthChanged() {
        if (this.initialColumnWidths == null) {
            return true;
        }
        if (this.getSavedColumnWidths() != null) {
            return true;
        }
        int[] nArray = this.getColumnWidths();
        return !Arrays.equals(nArray, this.initialColumnWidths);
    }

    public void saveSettings() {
        if (GuiSettings.getSaveBookmarkSort()) {
            SortDefinition sortDefinition = this.bookmarks.getCurrentSortColumns();
            String string = sortDefinition.getDefinitionString();
            Settings.getInstance().setProperty(PROP_SORT_DEF, string);
        }
        Settings.getInstance().setProperty(PROP_SEARCH_NAME, this.searchNameCbx.isSelected());
        Settings.getInstance().setProperty(PROP_USE_CURRENT_TAB, this.useCurrentEditorCbx.isSelected());
        if (this.columnWidthChanged() && GuiSettings.getSaveBookmarkColWidths()) {
            this.saveColumnWidths();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
            this.selectValueAndClose();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public static void selectBookmark(MainWindow mainWindow) {
        Object object;
        if (mainWindow == null) {
            LogMgr.logError(new CallerInfo(){}, "selectBookmark() called with a NULL window!", new Exception("Invalid window"));
            return;
        }
        if (GuiSettings.updateAllBookmarksOnOpen()) {
            BookmarkManager.getInstance().updateInBackground(mainWindow);
        } else {
            object = mainWindow.getCurrentPanel().orElse(null);
            BookmarkManager.getInstance().updateInBackground(mainWindow, (MainPanel)object, false);
        }
        object = new BookmarkSelector(mainWindow);
        ValidatingDialog validatingDialog = new ValidatingDialog((Frame)mainWindow, ResourceMgr.getString("TxtWinTitleBookmark"), (JComponent)object);
        ResourceMgr.setWindowIcons((Window)validatingDialog, "bookmark");
        ((BookmarkSelector)object).dialog = validatingDialog;
        String string = "workbench.gui.bookmarks.select";
        if (!Settings.getInstance().restoreWindowSize(validatingDialog, string)) {
            validatingDialog.setSize(450, 350);
        }
        WbSwingUtilities.center(validatingDialog, mainWindow);
        validatingDialog.setVisible(true);
        Settings.getInstance().storeWindowSize(validatingDialog, string);
        ((BookmarkSelector)object).saveSettings();
        if (!validatingDialog.isCancelled() && ((BookmarkSelector)object).selectedBookmark != null) {
            EventQueue.invokeLater(() -> BookmarkSelector.lambda$selectBookmark$3(mainWindow, (BookmarkSelector)object));
        }
    }

    private static /* synthetic */ void lambda$selectBookmark$3(MainWindow mainWindow, BookmarkSelector bookmarkSelector) {
        mainWindow.jumpToBookmark(bookmarkSelector.selectedBookmark);
    }
}

