/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.bookmarks;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import workbench.gui.bookmarks.NamedScriptLocation;
import workbench.resource.GuiSettings;
import workbench.sql.lexer.SQLToken;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class ProcedureBookmarks {
    private Set<String> modeKeywords = CollectionUtil.caseInsensitiveSet("OUT", "IN", "INOUT");
    private Set<String> typeKeywords = CollectionUtil.caseInsensitiveSet("PROCEDURE", "FUNCTION");
    private Set<String> createKeywords = CollectionUtil.caseInsensitiveSet("CREATE", "ALTER", "CREATE OR REPLACE");
    private Set<String> noParse = CollectionUtil.caseInsensitiveSet("DROP", "GRANT", "REVOKE", "RENAME");
    private Set<String> parameterStart = CollectionUtil.caseInsensitiveSet("(");
    private Set<String> parameterEnd = CollectionUtil.caseInsensitiveSet(")", "COLLATE", "NOT NULL");
    private Set<String> parameterDefault = CollectionUtil.caseInsensitiveSet("DEFAULT");
    private Set<String> createTerminal = CollectionUtil.caseInsensitiveSet("AS", "RETURN", "IS", "BEGIN", ";", "DECLARE", "RETURNS");
    private List<NamedScriptLocation> procedures = new ArrayList<NamedScriptLocation>();
    private final String id;
    private GlobalState globalState;
    private ParseState parseState;
    private ParameterState parmState;
    private SQLToken currentStartToken;
    private String currentIdentifier;
    private String parameterList;
    private int bracketCount;
    private boolean includeParameterNames;

    public ProcedureBookmarks() {
        this("script");
    }

    public ProcedureBookmarks(String string) {
        this.id = string;
        this.reset();
        this.includeParameterNames = GuiSettings.getProcBookmarksIncludeParmName();
    }

    public void setIncludeParameterNames(boolean bl) {
        this.includeParameterNames = bl;
    }

    public void processToken(SQLToken sQLToken) {
        if (sQLToken == null) {
            return;
        }
        if (sQLToken.isComment()) {
            return;
        }
        if (sQLToken.isWhiteSpace()) {
            return;
        }
        String string = sQLToken.getContents();
        switch (this.parseState) {
            case none: {
                if (this.createKeywords.contains(string)) {
                    this.parseState = ParseState.createKeyword;
                    this.currentStartToken = sQLToken;
                    break;
                }
                if (this.typeKeywords.contains(string)) {
                    this.parseState = ParseState.procName;
                    this.currentStartToken = sQLToken;
                    break;
                }
                if (!this.noParse.contains(string)) break;
                this.parseState = ParseState.skip;
                this.currentStartToken = null;
                this.currentIdentifier = "";
                break;
            }
            case skip: {
                if (!";".equals(string)) break;
                this.parseState = ParseState.none;
                break;
            }
            case createKeyword: {
                if (this.typeKeywords.contains(string)) {
                    this.parseState = ParseState.procType;
                    this.currentStartToken = sQLToken;
                    break;
                }
                if (string.equals("PACKAGE BODY")) {
                    this.globalState = GlobalState.packageBody;
                    this.currentStartToken = null;
                    break;
                }
                if (string.equals("PACKAGE")) {
                    this.globalState = GlobalState.packageSpec;
                    this.currentStartToken = null;
                    break;
                }
                if (!this.createTerminal.contains(string)) break;
                this.parseState = ParseState.none;
                this.currentStartToken = null;
                break;
            }
            case procType: {
                if (!sQLToken.isIdentifier()) break;
                this.parseState = ParseState.procName;
                this.currentIdentifier = string;
                break;
            }
            case procName: {
                if (this.parameterStart.contains(string)) {
                    this.parseState = ParseState.parameterList;
                    this.parmState = ParameterState.name;
                    this.parameterList = "";
                    break;
                }
                if (this.createTerminal.contains(string)) {
                    this.parseState = ParseState.none;
                    this.addCurrentProc();
                    break;
                }
                this.currentIdentifier = this.currentIdentifier + string;
                break;
            }
            case parameterList: {
                if ("(".equals(string)) {
                    ++this.bracketCount;
                }
                if (this.parameterEnd.contains(string) && this.bracketCount == 0 || this.createTerminal.contains(string)) {
                    this.parseState = ParseState.none;
                    this.parmState = ParameterState.none;
                    this.addCurrentProc();
                    break;
                }
                if (",".equals(string) && this.bracketCount == 0) {
                    this.parmState = ParameterState.name;
                } else if (this.parameterDefault.contains(string) || string.equals("=") && (this.parmState == ParameterState.dataType || this.parmState == ParameterState.none)) {
                    this.parmState = ParameterState.defaultValue;
                } else if (this.modeKeywords.contains(string)) {
                    this.parmState = ParameterState.dataType;
                } else if (this.parmState == ParameterState.none || this.parmState == ParameterState.dataType) {
                    if (this.parameterList.length() > 0 && this.bracketCount == 0) {
                        this.parameterList = this.parameterList + (this.includeParameterNames ? " " : ",");
                    }
                    this.parameterList = this.parameterList + sQLToken.getText();
                } else if (this.parmState == ParameterState.name) {
                    this.parmState = ParameterState.dataType;
                    if (this.includeParameterNames) {
                        if (this.parameterList.length() > 0) {
                            this.parameterList = this.parameterList + ", ";
                        }
                        this.parameterList = this.parameterList + sQLToken.getText();
                    }
                }
                if (!")".equals(string) || this.bracketCount <= 0) break;
                --this.bracketCount;
                this.parmState = ParameterState.none;
            }
        }
    }

    private void addCurrentProc() {
        if (this.currentStartToken != null && this.currentIdentifier != null) {
            String string = this.currentIdentifier;
            if (StringUtil.isNonEmpty(this.parameterList)) {
                string = string + "(" + this.parameterList + ")";
            }
            if (this.globalState == GlobalState.packageSpec) {
                string = GuiSettings.getBookmarksPkgSpecPrefix() + " " + string;
            }
            NamedScriptLocation namedScriptLocation = new NamedScriptLocation(string, this.currentStartToken.getCharBegin(), this.id);
            this.procedures.add(namedScriptLocation);
            this.parameterList = null;
            this.currentIdentifier = "";
            this.bracketCount = 0;
            this.currentStartToken = null;
        }
    }

    void reset() {
        this.parseState = ParseState.none;
        this.globalState = GlobalState.none;
        this.parmState = ParameterState.none;
        this.procedures.clear();
        this.currentIdentifier = "";
        this.bracketCount = 0;
        this.currentStartToken = null;
    }

    public List<NamedScriptLocation> getBookmarks() {
        return this.procedures;
    }

    private static enum ParameterState {
        none,
        name,
        dataType,
        defaultValue;

    }

    private static enum ParseState {
        none,
        skip,
        createKeyword,
        procType,
        procName,
        parameterList;

    }

    private static enum GlobalState {
        none,
        packageSpec,
        packageBody;

    }
}

