/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.completion;

import java.awt.Color;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import workbench.db.WbConnection;
import workbench.gui.completion.BaseAnalyzer;
import workbench.gui.completion.CompletionPopup;
import workbench.gui.completion.StatementContext;
import workbench.gui.editor.JEditTextArea;
import workbench.interfaces.StatusBar;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.sql.parser.ScriptParser;
import workbench.util.CollectionUtil;
import workbench.util.SqlParsingUtil;
import workbench.util.StringUtil;
import workbench.util.WbThread;

public class CompletionHandler
implements ListModel {
    private JEditTextArea editor;
    protected List elements = Collections.EMPTY_LIST;
    protected List filteredElements;
    protected WbConnection dbConnection;
    private JLabel header = new JLabel(ResourceMgr.getString("LblCompletionListTables"));
    private List<ListDataListener> listeners;
    private CompletionPopup window;
    protected StatusBar statusBar;
    private String currentWord;
    private boolean highlightNotNulls;

    public CompletionHandler() {
        this.header.setForeground(Color.BLUE);
        this.header.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
    }

    public void setStatusBar(StatusBar statusBar) {
        this.statusBar = statusBar;
    }

    public void setEditor(JEditTextArea jEditTextArea) {
        this.editor = jEditTextArea;
    }

    public void setConnection(WbConnection wbConnection) {
        this.dbConnection = wbConnection;
    }

    protected void showPopup() {
        this.filteredElements = null;
        try {
            this.statusBar.setStatusMessage(ResourceMgr.getString("MsgCompletionRetrievingObjects"));
            if (this.updateSelectionList()) {
                this.window.showPopup(this.currentWord, this.highlightNotNulls);
            }
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error retrieving completion objects", throwable);
            this.statusBar.clearStatusMessage();
        }
    }

    public void cancelPopup() {
        if (this.window != null) {
            this.window.cancelPopup();
        }
    }

    public void showCompletionPopup() {
        if (this.window == null) {
            this.window = new CompletionPopup(this.editor, this.header, this);
        }
        WbThread wbThread = new WbThread("Completion"){

            @Override
            public void run() {
                CompletionHandler.this.showPopup();
            }
        };
        wbThread.start();
    }

    private boolean updateSelectionList() {
        String string;
        boolean bl = false;
        this.highlightNotNulls = false;
        ScriptParser scriptParser = ScriptParser.createScriptParser(this.dbConnection);
        scriptParser.setScript(this.editor.getText());
        int n = this.editor.getCaretPosition();
        int n2 = scriptParser.getCommandIndexAtCursorPos(n);
        int n3 = scriptParser.getIndexInCommand(n2, n);
        String string2 = string = n2 > -1 ? scriptParser.getCommand(n2, false) : null;
        if (LogMgr.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder(string == null ? this.editor.getText() : string);
            if (n3 > -1) {
                stringBuilder.insert(n3, "^|^");
            } else {
                stringBuilder.append("\nNo command found at cursor position: " + n + ", commandIndex: " + n2 + ", cursor index in command: " + n3);
            }
            LogMgr.logDebug(new CallerInfo(){}, "Completion invoked for statement:\n" + stringBuilder.toString());
        }
        if (string == null) {
            LogMgr.logWarning(new CallerInfo(){}, "No SQL found!");
            this.showNoObjectsFoundMessage();
            return false;
        }
        try {
            long l = System.currentTimeMillis();
            StatementContext statementContext = new StatementContext(this.dbConnection, string, n3);
            if (statementContext.isStatementSupported()) {
                boolean bl2;
                BaseAnalyzer baseAnalyzer = statementContext.getAnalyzer();
                this.currentWord = this.editor.getWordLeftOfCursor(baseAnalyzer.getWordDelimiters());
                boolean bl3 = bl2 = baseAnalyzer.getOverwriteCurrentWord() && StringUtil.isNonBlank(this.currentWord);
                if (StringUtil.isNonBlank(this.currentWord) && baseAnalyzer.isWbParam() && this.currentWord.charAt(0) == '-') {
                    this.currentWord = this.currentWord.substring(1);
                }
                this.window.allowMultiSelection(statementContext.getAnalyzer().allowMultiSelection());
                this.window.selectCurrentWordInEditor(bl2);
                this.elements = statementContext.getData();
                long l2 = System.currentTimeMillis() - l;
                LogMgr.logDebug(new CallerInfo(){}, "Auto-completion invoked for " + baseAnalyzer.getSqlVerb() + ", analyzer: " + baseAnalyzer.getClass().getSimpleName() + ", context: " + baseAnalyzer.contextToString() + ", currentSchema: " + baseAnalyzer.getNamespaceForTableList() + ", element count: " + this.elements.size() + " (" + l2 + "ms)");
                this.header.setText(statementContext.getTitle());
                this.window.setContext(statementContext);
                Set<String> set = CollectionUtil.caseInsensitiveSet("insert", "update", "merge");
                this.highlightNotNulls = set.contains(baseAnalyzer.getSqlVerb());
                boolean bl4 = bl = this.getSize() > 0;
                if (bl) {
                    this.statusBar.clearStatusMessage();
                    this.fireDataChanged();
                } else {
                    this.showNoObjectsFoundMessage();
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
                this.showFailedMessage(string);
                bl = false;
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error retrieving objects", exception);
            bl = false;
            this.showNoObjectsFoundMessage();
        }
        return bl;
    }

    public void resetFilter() {
        this.filteredElements = null;
        this.fireDataChanged();
    }

    public synchronized int filterElements(String string) {
        if (StringUtil.isBlank(string)) {
            return 0;
        }
        this.filteredElements = null;
        if (this.getSize() == 0) {
            return 0;
        }
        try {
            boolean bl = GuiSettings.getPartialCompletionSearch();
            ArrayList arrayList = new ArrayList(this.getSize());
            string = string.toLowerCase();
            for (int i = 0; i < this.getSize(); ++i) {
                Object e = this.elements.get(i);
                if (e == null) continue;
                String string2 = e.toString().toLowerCase();
                if (bl) {
                    if (!string2.contains(string)) continue;
                    arrayList.add(e);
                    continue;
                }
                if (!string2.startsWith(string)) continue;
                arrayList.add(e);
            }
            if (arrayList.size() > 0) {
                this.filteredElements = arrayList;
            }
            this.fireDataChanged();
            return this.getSize();
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when applying filter", exception);
            return -1;
        }
    }

    private synchronized List getElementList() {
        if (this.filteredElements != null) {
            return this.filteredElements;
        }
        return this.elements == null ? Collections.emptyList() : this.elements;
    }

    private void showNoObjectsFoundMessage() {
        String string = ResourceMgr.getString("MsgCompletionNothingFound");
        this.statusBar.setStatusMessage(string, 2500);
    }

    private void showFailedMessage(String string) {
        String string2 = SqlParsingUtil.getInstance(this.dbConnection).getSqlVerb(string);
        String string3 = "'" + string2 + "' " + ResourceMgr.getString("MsgCompletionNotSupported");
        this.statusBar.setStatusMessage(string3, 2500);
    }

    private void fireDataChanged() {
        if (this.listeners == null) {
            return;
        }
        ListDataEvent listDataEvent = new ListDataEvent(this, 0, 0, this.getSize() - 1);
        for (ListDataListener listDataListener : this.listeners) {
            listDataListener.contentsChanged(listDataEvent);
        }
    }

    public Object getElementAt(int n) {
        return this.getElementList().get(n);
    }

    @Override
    public int getSize() {
        return this.getElementList().size();
    }

    @Override
    public void addListDataListener(ListDataListener listDataListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ListDataListener>();
        }
        this.listeners.add(listDataListener);
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listDataListener);
    }
}

