/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.completion;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import workbench.db.ColumnIdentifier;
import workbench.db.QuoteHandler;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.objectcache.Namespace;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.gui.completion.BaseAnalyzer;
import workbench.gui.completion.CompletionHandler;
import workbench.gui.completion.CompletionListRenderer;
import workbench.gui.completion.CompletionSearchField;
import workbench.gui.completion.QuickSearchList;
import workbench.gui.completion.SelectAllMarker;
import workbench.gui.completion.SelectFKValueMarker;
import workbench.gui.completion.StatementContext;
import workbench.gui.components.WbTraversalPolicy;
import workbench.gui.editor.JEditTextArea;
import workbench.gui.sql.LookupValuePicker;
import workbench.interfaces.ResultSetter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ColumnSortType;
import workbench.resource.GeneratedIdentifierCase;
import workbench.resource.GuiSettings;
import workbench.resource.Settings;
import workbench.util.Alias;
import workbench.util.ArgumentValue;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.TableAlias;
import workbench.util.WbDateFormatter;

public class CompletionPopup
implements FocusListener,
MouseListener,
KeyListener,
WindowListener,
QuickSearchList {
    protected JEditTextArea editor;
    private JScrollPane scroll;
    private JWindow window;
    private JPanel content;
    protected JList elementList;
    private ListModel data;
    private JComponent headerComponent;
    private StatementContext context;
    private boolean selectCurrentWordInEditor;
    protected CompletionSearchField searchField;
    private boolean ignoreSearchChange;
    private CompletionListRenderer listRenderer;

    public CompletionPopup(JEditTextArea jEditTextArea, JComponent jComponent, ListModel listModel) {
        this.data = listModel;
        this.editor = jEditTextArea;
        this.headerComponent = jComponent;
        this.elementList = new JList();
        this.elementList.setModel(this.data);
        this.elementList.setSelectionMode(2);
        CompoundBorder compoundBorder = new CompoundBorder(this.elementList.getBorder(), new EmptyBorder(0, 2, 0, 2));
        this.elementList.setBorder(compoundBorder);
        this.listRenderer = new CompletionListRenderer();
        this.elementList.setCellRenderer(this.listRenderer);
        this.elementList.addFocusListener(this);
        this.elementList.addMouseListener(this);
        this.content = new DummyPanel();
        this.content.setLayout(new BorderLayout());
        this.scroll = new JScrollPane(this.elementList);
        this.scroll.setBorder(new EtchedBorder(1));
        this.elementList.setVisibleRowCount(10);
        this.content.add(this.scroll);
        this.elementList.addKeyListener(this);
    }

    public void allowMultiSelection(boolean bl) {
        if (this.elementList == null) {
            return;
        }
        if (bl) {
            this.elementList.setSelectionMode(2);
        } else {
            this.elementList.setSelectionMode(0);
        }
    }

    public void setContext(StatementContext statementContext) {
        this.context = statementContext;
    }

    public void showPopup(String string, boolean bl) {
        if (!this.editor.isReallyVisible()) {
            return;
        }
        try {
            int n;
            this.listRenderer.setShowNotNulls(bl);
            this.scroll.setColumnHeaderView(this.headerComponent);
            this.headerComponent.doLayout();
            Dimension dimension = this.headerComponent.getPreferredSize();
            dimension.height += 35;
            dimension.width += 25;
            this.elementList.setMinimumSize(dimension);
            this.scroll.setMinimumSize(dimension);
            Point point = this.editor.getCursorLocation();
            SwingUtilities.convertPointToScreen(point, this.editor);
            if (this.selectCurrentWordInEditor) {
                WbSwingUtilities.invoke(() -> this.editor.selectWordAtCursor(this.context.getAnalyzer().getWordDelimiters()));
            }
            this.elementList.setVisibleRowCount((n = this.data.getSize()) < 12 ? n + 1 : 12);
            int n2 = 0;
            boolean bl2 = false;
            String string2 = null;
            if (StringUtil.isNonBlank(string)) {
                n2 = this.findEntry(string);
                string2 = string;
            }
            if (n2 == -1) {
                n2 = 0;
            } else {
                bl2 = true;
            }
            if (this.window == null) {
                this.window = new JWindow(SwingUtilities.getWindowAncestor(this.editor));
            }
            this.editor.setKeyEventInterceptor(this);
            this.elementList.validate();
            WbTraversalPolicy wbTraversalPolicy = new WbTraversalPolicy();
            wbTraversalPolicy.addComponent(this.elementList);
            wbTraversalPolicy.setDefaultComponent(this.elementList);
            this.elementList.setFocusable(true);
            this.elementList.setFocusTraversalKeysEnabled(false);
            this.window.setFocusCycleRoot(true);
            this.window.setFocusTraversalPolicy(wbTraversalPolicy);
            this.window.setContentPane(this.content);
            this.window.addKeyListener(this);
            this.window.addWindowListener(this);
            int n3 = n2;
            EventQueue.invokeLater(() -> {
                if (this.window != null) {
                    this.window.setLocation(point);
                    this.window.pack();
                    if (this.window.getWidth() < dimension.width + 5) {
                        this.window.setSize(dimension.width + 5, this.window.getHeight());
                    }
                    this.window.setVisible(true);
                    this.elementList.requestFocus();
                    this.elementList.setSelectedIndex(n3);
                    this.elementList.ensureIndexIsVisible(n3);
                }
            });
            if (bl2) {
                this.showQuickSearchValue(string2);
            }
        }
        catch (Exception exception) {
            LogMgr.logWarning(new CallerInfo(){}, "Error displaying popup window", exception);
        }
    }

    private void cleanup() {
        this.searchField = null;
        if (this.editor != null) {
            this.editor.removeKeyEventInterceptor();
        }
        if (this.window != null) {
            this.window.removeWindowListener(this);
            this.window.setVisible(false);
            this.window.dispose();
        }
        this.scroll.setColumnHeaderView(this.headerComponent);
        this.headerComponent.doLayout();
    }

    @Override
    public void closeQuickSearch() {
        this.closeQuickSearch(Settings.getInstance().getCloseAutoCompletionWithSearch());
    }

    public void closeQuickSearch(boolean bl) {
        this.searchField = null;
        this.scroll.setColumnHeaderView(this.headerComponent);
        this.headerComponent.doLayout();
        if (bl) {
            this.closePopup(false);
        } else {
            EventQueue.invokeLater(this.elementList::requestFocusInWindow);
        }
    }

    @Override
    public void quickSearchValueSelected() {
        this.closePopup(true);
    }

    private String getPasteValue(String string) {
        char c;
        if (string == null) {
            return string;
        }
        GeneratedIdentifierCase generatedIdentifierCase = Settings.getInstance().getAutoCompletionPasteCase();
        QuoteHandler quoteHandler = this.context.getAnalyzer().getQuoteHandler();
        String string2 = this.context.getAnalyzer().convertCase() ? (generatedIdentifierCase == GeneratedIdentifierCase.asIs || quoteHandler.isQuoted(string.trim()) ? string : (generatedIdentifierCase == GeneratedIdentifierCase.lower ? string.toLowerCase() : (generatedIdentifierCase == GeneratedIdentifierCase.upper ? string.toUpperCase() : string))) : string;
        if (this.context.getAnalyzer().appendDotToSelection()) {
            string2 = string2 + ".";
        }
        if (this.context.getAnalyzer().isKeywordList()) {
            string2 = string2 + " ";
        }
        if (this.context.getAnalyzer().isWbParam()) {
            string2 = "-" + string2 + "=";
        }
        if ((c = this.context.getAnalyzer().quoteCharForValue(string2)) != '\u0000') {
            string2 = c + string2 + c;
        }
        return string2;
    }

    public void cancelPopup() {
        if (this.window == null) {
            return;
        }
        this.window.setVisible(false);
        this.window.dispose();
    }

    private void selectEditor() {
        EventQueue.invokeLater(() -> {
            this.editor.requestFocus();
            this.editor.requestFocusInWindow();
        });
    }

    private List<ColumnIdentifier> getColumnsFromData() {
        int n = this.data.getSize();
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>(n);
        for (int i = 1; i < n; ++i) {
            Object e = this.data.getElementAt(i);
            if (e instanceof ColumnIdentifier) {
                arrayList.add((ColumnIdentifier)e);
                continue;
            }
            if (!(e instanceof String)) continue;
            arrayList.add(new ColumnIdentifier((String)e));
        }
        if (Settings.getInstance().getAutoCompletionColumnSortType() == ColumnSortType.position) {
            ColumnIdentifier.sortByPosition(arrayList);
        }
        return arrayList;
    }

    private void closePopup(boolean bl) {
        this.editor.removeKeyEventInterceptor();
        this.scroll.setColumnHeaderView(this.headerComponent);
        if (this.window == null) {
            return;
        }
        try {
            boolean bl2;
            if (bl && !(bl2 = this.handleFKSelection())) {
                this.doPaste();
            }
        }
        finally {
            this.window.removeWindowListener(this);
            this.window.setVisible(false);
            this.window.dispose();
            this.window = null;
            this.searchField = null;
            this.selectEditor();
        }
    }

    private boolean handleFKSelection() {
        List list = this.elementList.getSelectedValuesList();
        if (list == null) {
            return false;
        }
        if (list.size() != 1) {
            return false;
        }
        if (list.get(0) instanceof SelectFKValueMarker) {
            final SelectFKValueMarker selectFKValueMarker = (SelectFKValueMarker)list.get(0);
            WbConnection wbConnection = this.context.getAnalyzer().getConnection();
            if (!WbSwingUtilities.isConnectionIdle(this.editor, wbConnection)) {
                return false;
            }
            ResultSetter resultSetter = new ResultSetter(){

                @Override
                public Map<String, Object> getFKValues(List<String> list) {
                    return Collections.emptyMap();
                }

                @Override
                public void setResult(List<Map<String, Object>> list, Map<String, String> map) {
                    String string = selectFKValueMarker.getColumnName();
                    int n = 0;
                    StringBuilder stringBuilder = new StringBuilder(list.size() * 20);
                    for (Map<String, Object> map2 : list) {
                        for (Map.Entry<String, Object> entry : map2.entrySet()) {
                            String string2 = map.get(entry.getKey());
                            if (!SqlUtil.objectNamesAreEqual(string2, string)) continue;
                            Object object = entry.getValue();
                            if (object == null) break;
                            if (n > 0) {
                                stringBuilder.append(", ");
                            }
                            stringBuilder.append(CompletionPopup.this.getValueString(object));
                            break;
                        }
                        ++n;
                    }
                    CompletionPopup.this.editor.setSelectedText(stringBuilder.toString());
                }
            };
            LookupValuePicker.pickValue(this.editor, resultSetter, wbConnection, selectFKValueMarker.getColumnName(), selectFKValueMarker.getTable(), selectFKValueMarker.getAllowMultiSelect());
            return true;
        }
        return false;
    }

    private String getValueString(Object object) {
        if (object instanceof String) {
            return "'" + object + "'";
        }
        if (object instanceof Number) {
            return object.toString();
        }
        return WbDateFormatter.getDisplayValue(object);
    }

    protected void doPaste() {
        List list = this.elementList.getSelectedValuesList();
        if (list == null) {
            return;
        }
        ArrayList<TableIdentifier> arrayList = new ArrayList<TableIdentifier>();
        boolean bl = this.context.getAnalyzer().needsCommaForMultipleSelection();
        String string = "";
        Object object = list.iterator();
        while (object.hasNext()) {
            String string2;
            Object object2;
            Object e = object.next();
            String string3 = this.context.getAnalyzer().getPasteValue(e);
            if (string3 != null) {
                string = string + string3;
                continue;
            }
            if (e instanceof TableAlias) {
                object2 = (TableAlias)e;
                string2 = this.getPasteValue(((Alias)object2).getNameToUse());
                if (string.length() > 0) {
                    string = string + ", ";
                }
                string = string + string2;
                continue;
            }
            if (e instanceof SelectAllMarker) {
                object2 = this.getColumnsFromData();
                int n = object2.size();
                StringBuilder stringBuilder = new StringBuilder(n * 10);
                for (int i = 0; i < n; ++i) {
                    ColumnIdentifier columnIdentifier = (ColumnIdentifier)object2.get(i);
                    String string4 = columnIdentifier.getColumnName();
                    if (i > 0) {
                        stringBuilder.append(", ");
                    }
                    if (this.context.getAnalyzer().getColumnPrefix() != null && i > 0) {
                        stringBuilder.append(this.context.getAnalyzer().getColumnPrefix());
                        stringBuilder.append(".");
                    }
                    stringBuilder.append(this.getPasteValue(string4));
                }
                string = stringBuilder.toString();
                break;
            }
            if (e instanceof ArgumentValue) {
                object2 = (ArgumentValue)e;
                if (string.length() > 0) {
                    string = string + ", ";
                }
                string = string + object2.getValue();
                continue;
            }
            if (e instanceof TableIdentifier) {
                if (string.length() > 0) {
                    string = string + ", ";
                }
                if (!((string2 = this.getTableName((WbConnection)(object2 = this.context.getAnalyzer().getConnection()), (TableIdentifier)e)).contains("\"") || string2.contains("[") || string2.contains("`"))) {
                    string2 = this.getPasteValue(string2);
                }
                string = string + string2;
                arrayList.add((TableIdentifier)e);
                continue;
            }
            if (string.length() > 0 && bl) {
                string = string + ", ";
                if (e instanceof ColumnIdentifier && this.context.getAnalyzer().getColumnPrefix() != null) {
                    string = string + this.context.getAnalyzer().getColumnPrefix() + ".";
                }
            }
            string = string + this.getPasteValue(e.toString());
        }
        if (StringUtil.isNonBlank(string)) {
            this.editor.setSelectedText(string.trim());
            if (string.charAt(0) == '<' || string.charAt(0) == '>') {
                this.editor.selectWordAtCursor(" =-\t\n");
            }
        }
        if ((object = this.context.getAnalyzer().getConnection()) != null && ((WbConnection)object).getDbSettings().populateCacheInBackground()) {
            ((WbConnection)object).getObjectCache().retrieveColumnsInBackground(arrayList);
        }
    }

    private String getTableName(WbConnection wbConnection, TableIdentifier tableIdentifier) {
        Namespace namespace = this.context.getAnalyzer().getNamespaceForTableList();
        if (namespace == null) {
            return tableIdentifier.getObjectExpression(wbConnection);
        }
        BaseAnalyzer baseAnalyzer = this.context.getAnalyzer();
        int n = baseAnalyzer.getContext();
        if (n != 1 && n != 4 && n != 14 && n != 13) {
            return tableIdentifier.getObjectExpression(wbConnection);
        }
        tableIdentifier = tableIdentifier.createCopy();
        namespace.removeNamespaceIfEqual(tableIdentifier);
        return tableIdentifier.getTableExpression();
    }

    public void selectCurrentWordInEditor(boolean bl) {
        this.selectCurrentWordInEditor = bl;
    }

    @Override
    public void selectMatchingEntry(String string) {
        if (this.ignoreSearchChange) {
            return;
        }
        int n = this.findEntry(string);
        if (n >= 0) {
            this.elementList.setSelectedIndex(n);
            this.elementList.ensureIndexIsVisible(n);
        } else {
            this.elementList.clearSelection();
        }
    }

    private int findEntry(String string) {
        if (string == null) {
            return -1;
        }
        int n = this.data.getSize();
        if (n == 0) {
            return -1;
        }
        boolean bl = GuiSettings.getPartialCompletionSearch();
        boolean bl2 = GuiSettings.getFilterCompletionSearch();
        if (bl2 && this.data instanceof CompletionHandler) {
            CompletionHandler completionHandler = (CompletionHandler)this.data;
            completionHandler.filterElements(string);
            return completionHandler.getSize() == 0 ? -1 : 0;
        }
        String string2 = string.toLowerCase();
        for (int i = 0; i < n; ++i) {
            String string3 = SqlUtil.removeObjectQuotes(this.data.getElementAt(i).toString());
            if (!(bl ? string3.toLowerCase().contains(string2) : string3.toLowerCase().startsWith(string2))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.searchField == null) {
            this.closePopup(false);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getClickCount();
        if (n == 2) {
            this.closePopup(true);
        } else if (n == 1 && this.searchField != null) {
            this.closeQuickSearch(false);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyPressed(KeyEvent keyEvent) {
        Object object;
        int n = this.elementList.getSelectedIndex();
        int n2 = -1;
        boolean bl = false;
        boolean bl2 = GuiSettings.getCycleCompletionPopup();
        boolean bl3 = WbAction.isShiftPressed(keyEvent.getModifiers());
        switch (keyEvent.getKeyCode()) {
            case 9: {
                keyEvent.consume();
                break;
            }
            case 10: {
                this.closePopup(true);
                keyEvent.consume();
                break;
            }
            case 27: {
                this.closePopup(false);
                keyEvent.consume();
                break;
            }
            case 38: {
                if (bl2 && n == 0) {
                    n2 = this.data.getSize() - 1;
                } else if (n > 0) {
                    n2 = n - 1;
                }
                if (n2 == -1) break;
                if (bl3) {
                    this.elementList.addSelectionInterval(n2, n2);
                } else {
                    this.elementList.setSelectedIndex(n2);
                }
                this.elementList.ensureIndexIsVisible(n2);
                bl = true;
                keyEvent.consume();
                break;
            }
            case 40: {
                if (bl3 && ((int[])(object = this.elementList.getSelectedIndices())).length > 1) {
                    n = object[((int[])object).length - 1];
                }
                if (bl2 && n == this.data.getSize() - 1) {
                    n2 = 0;
                } else if (n < this.data.getSize() - 1) {
                    n2 = n + 1;
                }
                if (n2 == -1) break;
                if (bl3) {
                    this.elementList.addSelectionInterval(n2, n2);
                } else {
                    this.elementList.setSelectedIndex(n2);
                }
                this.elementList.ensureIndexIsVisible(n2);
                bl = true;
                keyEvent.consume();
            }
        }
        if (bl && this.searchField != null) {
            try {
                this.ignoreSearchChange = true;
                object = this.elementList.getSelectedValue();
                if (object != null) {
                    this.searchField.setText(object.toString());
                    this.searchField.selectAll();
                }
            }
            finally {
                this.ignoreSearchChange = false;
            }
        }
    }

    protected void showQuickSearchValue(String string) {
        if (StringUtil.isBlank(string)) {
            return;
        }
        EventQueue.invokeLater(() -> {
            this.openQuickSearch(string);
            this.searchField.setText(string.trim());
            this.searchField.requestFocusInWindow();
        });
        this.setSearchFieldCursor();
    }

    protected void openQuickSearch(String string) {
        if (this.searchField == null) {
            this.searchField = new CompletionSearchField(this, string);
            this.scroll.setColumnHeaderView(this.searchField);
            this.scroll.doLayout();
        }
    }

    protected void setSearchFieldCursor() {
        EventQueue.invokeLater(() -> {
            if (this.searchField != null) {
                int n = this.searchField.getText().length();
                this.searchField.setCaretPosition(n);
                this.searchField.select(n, n);
            }
        });
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (this.searchField == null) {
            String string = String.valueOf(keyEvent.getKeyChar());
            this.openQuickSearch(string);
            keyEvent.consume();
        }
        this.searchField.requestFocusInWindow();
        this.setSearchFieldCursor();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        this.cleanup();
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    private static class DummyPanel
    extends JPanel {
        private DummyPanel() {
        }

        @Override
        public boolean isManagingFocus() {
            return false;
        }

        @Override
        public boolean getFocusTraversalKeysEnabled() {
            return false;
        }
    }
}

