/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.completion;

import java.util.ArrayList;
import java.util.List;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.gui.completion.CteDefinition;
import workbench.gui.completion.CteParser;
import workbench.gui.completion.SelectAnalyzer;

public class CteAnalyzer
extends SelectAnalyzer {
    private CteParser cteParser;

    public CteAnalyzer(WbConnection wbConnection, String string, int n) {
        this(wbConnection, new CteParser(wbConnection, string), n);
    }

    private CteAnalyzer(WbConnection wbConnection, CteParser cteParser, int n) {
        super(wbConnection, cteParser.getBaseSql(), n - cteParser.getBaseSqlStart());
        this.cteParser = cteParser;
    }

    @Override
    protected void retrieveTables() {
        super.retrieveTables();
        List<CteDefinition> list = this.cteParser.getCteDefinitions();
        for (int i = 0; i < list.size(); ++i) {
            CteDefinition cteDefinition = list.get(i);
            String string = cteDefinition.getName();
            TableIdentifier tableIdentifier = new TableIdentifier(string);
            this.elements.add(i, tableIdentifier);
        }
    }

    @Override
    protected boolean retrieveColumns() {
        if (this.tableForColumnList != null) {
            String string = this.tableForColumnList.getTableName();
            for (CteDefinition cteDefinition : this.cteParser.getCteDefinitions()) {
                if (!string.equalsIgnoreCase(cteDefinition.getName())) continue;
                this.title = string + ".*";
                this.elements = new ArrayList();
                this.elements.addAll(cteDefinition.getColumns());
                return true;
            }
        }
        return super.retrieveColumns();
    }
}

