/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.completion;

import java.util.ArrayList;
import java.util.List;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.objectcache.Namespace;
import workbench.gui.completion.BaseAnalyzer;
import workbench.util.SqlParsingUtil;
import workbench.util.SqlUtil;
import workbench.util.TableAlias;

public class DeleteAnalyzer
extends BaseAnalyzer {
    public DeleteAnalyzer(WbConnection wbConnection, String string, int n) {
        super(wbConnection, string, n);
    }

    @Override
    protected void checkContext() {
        this.context = -1;
        int n = SqlParsingUtil.getInstance(this.dbConnection).getKeywordPosition("WHERE", (CharSequence)this.sql);
        this.checkOverwrite();
        if (n == -1 || n > -1 && this.cursorPos < n) {
            this.context = 1;
            this.namespaceForTableList = this.getNamespaceFromCurrentWord();
            if (this.isCurrentNameSpaceCatalog()) {
                this.namespaceForTableList = new Namespace(null, this.namespaceForTableList.toString());
                this.context = 11;
            }
        } else {
            this.context = 2;
            String string = SqlUtil.getDeleteTable(this.sql, this.catalogSeparator, this.dbConnection);
            if (string != null) {
                this.tableForColumnList = new TableIdentifier(string, this.catalogSeparator, SqlUtil.getSchemaSeparator(this.dbConnection));
                this.tableForColumnList.adjustCase(this.dbConnection);
                this.fkMarker = this.checkFkLookup();
            }
        }
    }

    @Override
    public List<TableAlias> getTables() {
        String string = SqlUtil.getDeleteTable(this.sql, this.catalogSeparator, this.dbConnection);
        TableAlias tableAlias = new TableAlias(string, SqlUtil.getCatalogSeparator(this.dbConnection), SqlUtil.getSchemaSeparator(this.dbConnection));
        ArrayList<TableAlias> arrayList = new ArrayList<TableAlias>(1);
        arrayList.add(tableAlias);
        return arrayList;
    }
}

