/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.completion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import workbench.db.WbConnection;
import workbench.gui.completion.ExplainAnalyzer;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.util.CollectionUtil;

public class MySQLExplainAnalyzer
extends ExplainAnalyzer {
    public MySQLExplainAnalyzer(WbConnection wbConnection, String string, int n) {
        super(wbConnection, string, n);
    }

    @Override
    protected int getStatementStart(String string) {
        try {
            SQLLexer sQLLexer = SQLLexerFactory.createLexer(this.dbConnection, string);
            SQLToken sQLToken = sQLLexer.getNextToken(false, false);
            while (sQLToken != null) {
                if (sQLToken.getText().equalsIgnoreCase("SELECT")) {
                    return sQLToken.getCharBegin();
                }
                sQLToken = sQLLexer.getNextToken(false, false);
            }
            return Integer.MAX_VALUE;
        }
        catch (Exception exception) {
            return Integer.MAX_VALUE;
        }
    }

    @Override
    protected void checkContext() {
        Set<String> set = CollectionUtil.caseInsensitiveSet("EXTENDED", "PARTITIONS");
        Set<String> set2 = CollectionUtil.caseInsensitiveSet();
        String string = this.getExplainSql();
        try {
            SQLLexer sQLLexer = SQLLexerFactory.createLexer(this.dbConnection, string);
            SQLToken sQLToken = sQLLexer.getNextToken(false, false);
            while (sQLToken != null) {
                String string2 = sQLToken.getText();
                if (!string2.equalsIgnoreCase("EXPLAIN")) {
                    set2.add(string2);
                }
                sQLToken = sQLLexer.getNextToken(false, false);
            }
            this.elements = set2.isEmpty() ? new ArrayList<String>(set) : Collections.emptyList();
            this.context = 9;
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error getting optiosn", exception);
            this.elements = new ArrayList();
            this.context = -1;
        }
    }
}

