/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Dialog;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.SQLException;
import workbench.WbManager;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.EditWindow;
import workbench.gui.dialogs.BlobInfoDialog;
import workbench.gui.dialogs.ImageViewer;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.EncodingUtil;
import workbench.util.FileUtil;

public class BlobHandler {
    private File uploadFile;
    private byte[] newValue;
    private boolean setToNull = false;

    public StringBuilder getByteDisplay(Object object) {
        long l = this.getBlobSize(object);
        return this.getByteDisplay(l);
    }

    public boolean setToNull() {
        return this.setToNull;
    }

    public Object getValueToUse() {
        if (this.setToNull) {
            return null;
        }
        if (this.uploadFile != null) {
            return this.uploadFile;
        }
        return this.newValue;
    }

    public File getUploadFile() {
        return this.uploadFile;
    }

    public StringBuilder getByteDisplay(long l) {
        StringBuilder stringBuilder = new StringBuilder(32);
        if (l < 1024L) {
            stringBuilder.append(Long.toString(l));
            stringBuilder.append(' ');
        } else if (l < 0x100000L) {
            stringBuilder.append(Long.toString(l / 1024L));
            stringBuilder.append(" K");
        } else {
            stringBuilder.append(Long.toString(l / 0x100000L));
            stringBuilder.append(" M");
        }
        stringBuilder.append('B');
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBlobAsArray(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Blob) {
            Blob blob = (Blob)object;
            try {
                byte[] byArray = blob.getBytes(1L, (int)blob.length());
                return byArray;
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error retrieving blob value", exception);
                return null;
            }
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof File) {
            byte[] byArray;
            BufferedInputStream bufferedInputStream = null;
            try {
                byte[] byArray2;
                File file = (File)object;
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                byArray = byArray2 = FileUtil.readBytes(bufferedInputStream);
            }
            catch (Exception exception) {
                byte[] byArray3;
                try {
                    LogMgr.logError(new CallerInfo(){}, "Error retrieving blob value", exception);
                    byArray3 = null;
                }
                catch (Throwable throwable) {
                    FileUtil.closeQuietely(bufferedInputStream);
                    throw throwable;
                }
                FileUtil.closeQuietely(bufferedInputStream);
                return byArray3;
            }
            FileUtil.closeQuietely(bufferedInputStream);
            return byArray;
        }
        return null;
    }

    public long getBlobSize(Object object) {
        if (object == null) {
            return 0L;
        }
        if (object instanceof Blob) {
            Blob blob = (Blob)object;
            try {
                return blob.length();
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Could not retrieve blob size", exception);
            }
        } else {
            if (object instanceof File) {
                return ((File)object).length();
            }
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                return byArray.length;
            }
        }
        return -1L;
    }

    private String convertArray(byte[] byArray, String string) {
        String string2 = null;
        try {
            string2 = new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LogMgr.logError(new CallerInfo(){}, "Could not convert binary to string using encoding: " + string, unsupportedEncodingException);
            string2 = new String(byArray);
        }
        return string2;
    }

    public String getBlobAsString(Object object, String string) {
        if (object == null) {
            return null;
        }
        if (this.getBlobSize(object) == 0L) {
            return "";
        }
        if (string == null) {
            string = Settings.getInstance().getDefaultBlobTextEncoding();
        }
        if (object instanceof Blob) {
            Blob blob = (Blob)object;
            try {
                byte[] byArray = blob.getBytes(1L, (int)blob.length());
                return this.convertArray(byArray, string);
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error retrieving blob value", exception);
                return "";
            }
        }
        if (object instanceof byte[]) {
            return this.convertArray((byte[])object, string);
        }
        if (object instanceof File) {
            Reader reader = null;
            try {
                File file = (File)object;
                reader = EncodingUtil.createReader(file, string);
                String string2 = FileUtil.readCharacters(reader);
                return string2;
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error retrieving blob value", exception);
                return "";
            }
        }
        return object.toString();
    }

    public static long saveBlobToFile(Object object, String string) throws IOException, SQLException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        return BlobHandler.saveBlobToFile(object, fileOutputStream);
    }

    public static long saveBlobToFile(Object object, OutputStream outputStream) throws IOException, SQLException {
        InputStream inputStream = null;
        if (object instanceof Blob) {
            Blob blob = (Blob)object;
            inputStream = blob.getBinaryStream();
        } else if (object instanceof byte[]) {
            inputStream = new ByteArrayInputStream((byte[])object);
        } else if (object instanceof File) {
            inputStream = new FileInputStream((File)object);
        } else if (object instanceof InputStream) {
            inputStream = (InputStream)object;
        }
        if (inputStream == null) {
            LogMgr.logError(new CallerInfo(){}, "No valid BLOB data found, got " + object.getClass().getName() + " instead", null);
            throw new IOException("No LOB data found");
        }
        return FileUtil.copy(inputStream, outputStream);
    }

    public void showBlobAsImage(Object object) {
        this.showBlobAsImage(null, object);
    }

    public void showBlobAsImage(Dialog dialog, Object object) {
        ImageViewer imageViewer = dialog != null ? new ImageViewer(dialog, ResourceMgr.getString("TxtBlobData")) : new ImageViewer((Frame)WbManager.getInstance().getCurrentWindow(), ResourceMgr.getString("TxtBlobData"));
        imageViewer.setData(object);
        imageViewer.setVisible(true);
    }

    public void showBlobAsText(Object object) {
        this.showBlobAsText(null, object, Settings.getInstance().getDefaultBlobTextEncoding());
    }

    public boolean showBlobAsText(Dialog dialog, Object object, final String string) {
        String string2 = this.getBlobAsString(object, string);
        String string3 = ResourceMgr.getString("TxtBlobData");
        this.newValue = null;
        boolean bl = false;
        final EditWindow editWindow = dialog != null ? new EditWindow(dialog, string3, string2, false, false) : new EditWindow((Frame)WbManager.getInstance().getCurrentWindow(), string3, string2, false, false);
        WbSwingUtilities.invoke(new Runnable(){

            @Override
            public void run() {
                editWindow.setInfoText(ResourceMgr.getString("LblFileEncoding") + ": " + string);
                editWindow.setVisible(true);
            }
        });
        if (!editWindow.isCancelled()) {
            string2 = editWindow.getText();
            try {
                if (string != null) {
                    this.newValue = string2.getBytes(string);
                    this.uploadFile = null;
                    bl = true;
                }
            }
            catch (Exception exception) {
                this.newValue = null;
                bl = false;
                LogMgr.logError(new CallerInfo(){}, "Error converting text to blob", exception);
            }
        }
        return bl;
    }

    public boolean isChanged() {
        return this.newValue != null;
    }

    public byte[] getNewValue() {
        return this.newValue;
    }

    public void showBlobInfoDialog(Frame frame, Object object, boolean bl) {
        BlobInfoDialog blobInfoDialog = new BlobInfoDialog(frame, true, bl);
        blobInfoDialog.setBlobValue(object);
        blobInfoDialog.setVisible(true);
        this.uploadFile = blobInfoDialog.getUploadedFile();
        this.setToNull = blobInfoDialog.setToNull();
        this.newValue = blobInfoDialog.getNewValue();
    }
}

