/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import com.sun.java.swing.plaf.windows.WindowsTabbedPaneUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.UIManager;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.TabHighlightSupport;
import workbench.gui.components.TabHighlighter;

public class BorderLessWindowsTabbedPaneUI
extends WindowsTabbedPaneUI
implements TabHighlightSupport {
    private static final Insets TOP_INSETS = new Insets(3, 1, 1, 1);
    private static final Insets BOTTOM_INSETS = new Insets(1, 1, 3, 1);
    private static final Insets RIGHT_INSETS = new Insets(0, 0, 0, 5);
    private static final Insets LEFT_INSETS = new Insets(1, 3, 1, 1);
    private TabHighlighter highlighter;
    private Color selColor;

    @Override
    public void setTabHighlighter(TabHighlighter tabHighlighter) {
        this.highlighter = tabHighlighter;
    }

    protected void installDefaults() {
        super.installDefaults();
        this.selColor = UIManager.getColor("TabbedPane.selected");
    }

    protected Insets getContentBorderInsets(int n) {
        switch (n) {
            case 1: {
                return TOP_INSETS;
            }
            case 3: {
                return BOTTOM_INSETS;
            }
            case 2: {
                return LEFT_INSETS;
            }
            case 4: {
                return RIGHT_INSETS;
            }
        }
        return WbSwingUtilities.getEmptyInsets();
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        super.paintTabBorder(graphics, n, n2, n3, n4, n5, n6, bl);
        if (this.highlighter != null) {
            this.highlighter.paintTabBorder(graphics, n, n2, n3, n4, n5, n6, bl);
        }
    }

    protected void paintContentBorder(Graphics graphics, int n, int n2) {
        int n3 = this.tabPane.getWidth();
        int n4 = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int n5 = insets.left;
        int n6 = insets.top;
        int n7 = n3 - insets.right - insets.left;
        int n8 = n4 - insets.top - insets.bottom;
        switch (n) {
            case 2: {
                n7 -= (n5 += this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                n7 -= this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
                break;
            }
            case 3: {
                n8 -= this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
                break;
            }
            default: {
                n8 -= (n6 += this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight)) - insets.top;
            }
        }
        if (this.selColor == null) {
            graphics.setColor(this.tabPane.getBackground());
        } else {
            graphics.setColor(this.selColor);
        }
        graphics.fillRect(n5, n6, n7, n8);
        switch (n) {
            case 1: {
                this.paintContentBorderTopEdge(graphics, n, n2, n5, n6, n7, n8);
                break;
            }
            case 3: {
                this.paintContentBorderBottomEdge(graphics, n, n2, n5, n6, n7, n8);
                break;
            }
            case 2: {
                this.paintContentBorderLeftEdge(graphics, n, n2, n5, n6, n7, n8);
                break;
            }
            case 4: {
                this.paintContentBorderRightEdge(graphics, n, n2, n5, n6, n7, n8);
            }
        }
    }
}

