/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import workbench.gui.WbSwingUtilities;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.util.ClassFinder;
import workbench.util.StringUtil;
import workbench.util.WbThread;

public class ClassFinderGUI {
    private ClassFinder finder;
    private JTextComponent className;
    private List<File> classPath;
    private JLabel statusBar;
    private String statusKey;
    private String selectWindowKey;

    public ClassFinderGUI(ClassFinder classFinder, JTextComponent jTextComponent, JLabel jLabel) {
        this.finder = classFinder;
        this.className = jTextComponent;
        this.statusBar = jLabel;
    }

    public void setClassPath(List<File> list) {
        this.classPath = list != null ? new ArrayList<File>(list) : null;
    }

    public void setStatusBarKey(String string) {
        this.statusKey = string;
    }

    public void setWindowTitleKey(String string) {
        this.selectWindowKey = string;
    }

    public static String selectEntry(List<String> list, String string, String string2, Window window) {
        JPanel jPanel = new JPanel(new BorderLayout());
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (String object2 : list) {
            defaultListModel.addElement(object2);
        }
        JList jList = new JList(defaultListModel);
        jList.setVisibleRowCount(Math.min(10, list.size() + 1));
        if (StringUtil.isNonBlank(string)) {
            jList.setSelectedValue(string, true);
        }
        JScrollPane jScrollPane = new JScrollPane(jList);
        jPanel.add((Component)jScrollPane, "Center");
        boolean bl = WbSwingUtilities.getOKCancel(ResourceMgr.getString(string2), window, jPanel);
        if (bl) {
            return (String)jList.getSelectedValue();
        }
        return null;
    }

    protected String selectEntry(List<String> list) {
        return ClassFinderGUI.selectEntry(list, this.className.getText(), this.selectWindowKey, SwingUtilities.getWindowAncestor(this.className));
    }

    protected void checkFinished(List<String> list) {
        if (list == null) {
            return;
        }
        EventQueue.invokeLater(() -> {
            String string;
            this.statusBar.setText("");
            if (list.size() == 1) {
                this.className.setText((String)list.get(0));
            } else if (list.size() > 0 && (string = this.selectEntry(list)) != null) {
                this.className.setText(string);
            }
        });
    }

    public void startCheck() {
        WbThread wbThread = new WbThread("CheckDriver"){

            @Override
            public void run() {
                ClassFinderGUI.this.statusBar.setText(ResourceMgr.getString(ClassFinderGUI.this.statusKey));
                try {
                    List<String> list = ClassFinderGUI.this.finder.findImplementations(ClassFinderGUI.this.classPath);
                    ClassFinderGUI.this.checkFinished(list);
                }
                catch (Exception exception) {
                    LogMgr.logError(new CallerInfo(){}, "Could not find JDBC driver class", exception);
                }
            }
        };
        wbThread.start();
    }
}

