/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import workbench.gui.components.ExtensionFileFilter;
import workbench.gui.components.WbFileChooser;
import workbench.gui.profiles.LibraryElement;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.WbFile;

public class ClasspathEditor
extends JPanel
implements ListSelectionListener,
ActionListener {
    private String lastDirProperty;
    private String lastDir = null;
    private List<ActionListener> listener = new ArrayList<ActionListener>();
    private JButton btnAdd;
    private JButton btnDown;
    private JButton btnRemove;
    private JButton btnUp;
    private JScrollPane jScrollPane1;
    private JList libList;

    public ClasspathEditor() {
        this.initComponents();
        this.libList.getSelectionModel().addListSelectionListener(this);
        this.btnUp.addActionListener(this);
        this.btnDown.addActionListener(this);
        this.btnRemove.addActionListener(this);
        this.btnAdd.addActionListener(this);
    }

    public void restoreSettings() {
        if (this.lastDirProperty != null) {
            this.lastDir = Settings.getInstance().getProperty(this.lastDirProperty, null);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listener.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listener.remove(actionListener);
    }

    public void saveSettings() {
        if (this.lastDirProperty != null) {
            Settings.getInstance().setProperty(this.lastDirProperty, this.lastDir);
        }
    }

    public String getLastDirProperty() {
        return this.lastDirProperty;
    }

    public void setLastDirProperty(String string) {
        this.lastDirProperty = string;
        this.restoreSettings();
    }

    public boolean hasLibraries() {
        return this.libList.getModel().getSize() > 0;
    }

    public void setLibraries(List<String> list) {
        DefaultListModel<LibraryElement> defaultListModel = new DefaultListModel<LibraryElement>();
        if (list != null) {
            for (String string : list) {
                if (string == null) continue;
                defaultListModel.addElement(new LibraryElement(string));
            }
        }
        this.libList.setModel(defaultListModel);
        this.libList.getSelectionModel().clearSelection();
        this.checkButtons();
    }

    public List<String> getRealJarPaths() {
        int n = this.libList.getModel().getSize();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            LibraryElement libraryElement = (LibraryElement)this.libList.getModel().getElementAt(i);
            arrayList.add(libraryElement.getRealPath());
        }
        return arrayList;
    }

    public List<String> getLibraries() {
        int n = this.libList.getModel().getSize();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            LibraryElement libraryElement = (LibraryElement)this.libList.getModel().getElementAt(i);
            arrayList.add(libraryElement.getPath());
        }
        return arrayList;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.libList.getSelectedIndices();
        int n = -1;
        if (nArray.length == 1) {
            n = nArray[0];
        }
        DefaultListModel defaultListModel = (DefaultListModel)this.libList.getModel();
        int n2 = defaultListModel.getSize();
        if (actionEvent.getSource() == this.btnRemove && nArray.length > 0) {
            this.removeSelected();
        } else if (actionEvent.getSource() == this.btnUp && n > 0) {
            this.swap(n, n - 1);
        } else if (actionEvent.getSource() == this.btnDown && n > -1 && n < n2 - 1) {
            this.swap(n, n + 1);
        } else if (actionEvent.getSource() == this.btnAdd) {
            this.selectFile();
        }
    }

    private void removeSelected() {
        int[] nArray = this.libList.getSelectedIndices();
        if (nArray.length == 0) {
            return;
        }
        Arrays.sort(nArray);
        DefaultListModel defaultListModel = (DefaultListModel)this.libList.getModel();
        for (int i = nArray.length - 1; i >= 0; --i) {
            defaultListModel.remove(nArray[i]);
        }
    }

    private void swap(int n, int n2) {
        DefaultListModel defaultListModel = (DefaultListModel)this.libList.getModel();
        Object e = defaultListModel.get(n);
        Object e2 = defaultListModel.get(n2);
        defaultListModel.set(n, e2);
        defaultListModel.set(n2, e);
        this.libList.setSelectedIndex(n2);
    }

    private void removeSingleInvalidEntry() {
        LibraryElement libraryElement;
        String string;
        File file;
        DefaultListModel defaultListModel = (DefaultListModel)this.libList.getModel();
        if (defaultListModel.getSize() == 1 && !(file = new File(string = (libraryElement = (LibraryElement)defaultListModel.getElementAt(0)).getRealPath())).exists()) {
            defaultListModel.remove(0);
        }
    }

    private void selectFile() {
        DefaultListModel defaultListModel = (DefaultListModel)this.libList.getModel();
        WbFileChooser wbFileChooser = new WbFileChooser();
        wbFileChooser.setFileSelectionMode(2);
        wbFileChooser.setMultiSelectionEnabled(true);
        if (this.lastDir != null) {
            wbFileChooser.setCurrentDirectory(new File(this.lastDir));
        }
        wbFileChooser.setFileFilter(ExtensionFileFilter.getJarFileFilter());
        int n = wbFileChooser.showOpenDialog(SwingUtilities.getWindowAncestor(this));
        if (n == 0) {
            File[] fileArray = wbFileChooser.getSelectedFiles();
            this.removeSelected();
            this.removeSingleInvalidEntry();
            for (File file : fileArray) {
                defaultListModel.addElement(new LibraryElement(new WbFile(file)));
            }
            this.lastDir = fileArray[0].getParent();
            this.saveSettings();
            this.fireLiblistChanged();
        }
    }

    private void fireLiblistChanged() {
        ActionEvent actionEvent = new ActionEvent(this, 1, "modified");
        for (ActionListener actionListener : this.listener) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.checkButtons();
    }

    public void setFileSelectionEnabled(boolean bl) {
        this.btnAdd.setEnabled(bl);
        this.btnRemove.setEnabled(bl);
        this.btnUp.setEnabled(bl);
        this.btnDown.setEnabled(bl);
        this.libList.setEnabled(bl);
    }

    private void checkButtons() {
        int n = this.libList.getSelectedIndex();
        int n2 = this.libList.getModel().getSize();
        this.btnRemove.setEnabled(n > -1);
        this.btnUp.setEnabled(n > 0);
        this.btnDown.setEnabled(n > -1 && n < n2 - 1);
    }

    public void reset() {
        this.libList.setModel(new DefaultListModel());
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.libList = new JList();
        this.btnAdd = new JButton();
        this.btnRemove = new JButton();
        this.btnUp = new JButton();
        this.btnDown = new JButton();
        this.setLayout(new GridBagLayout());
        this.libList.setVerifyInputWhenFocusTarget(false);
        this.libList.setVisibleRowCount(4);
        this.jScrollPane1.setViewportView(this.libList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.btnAdd.setIcon(IconMgr.getInstance().getLabelIcon("Open"));
        this.btnAdd.setToolTipText(ResourceMgr.getString("d_LblDriverLibrary"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.add((Component)this.btnAdd, gridBagConstraints);
        this.btnRemove.setIcon(IconMgr.getInstance().getLabelIcon("delete"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(4, 8, 0, 0);
        this.add((Component)this.btnRemove, gridBagConstraints);
        this.btnUp.setIcon(IconMgr.getInstance().getLabelIcon("Up"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(16, 8, 0, 0);
        this.add((Component)this.btnUp, gridBagConstraints);
        this.btnDown.setIcon(IconMgr.getInstance().getLabelIcon("Down"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(4, 8, 0, 0);
        this.add((Component)this.btnDown, gridBagConstraints);
    }
}

