/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import workbench.db.ColumnIdentifier;
import workbench.resource.ResourceMgr;

class ColumnSelectTableModel
implements TableModel {
    ColumnIdentifier[] columns;
    boolean[] selected;
    String colLabel = ResourceMgr.getString("LblHeaderKeyColumnColName");
    String selectLabel = ResourceMgr.getString("LblHeaderUseColumn");
    private final int rows;

    ColumnSelectTableModel(ColumnIdentifier[] columnIdentifierArray) {
        this.rows = columnIdentifierArray.length;
        this.columns = columnIdentifierArray;
        this.selected = new boolean[this.rows];
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            String string = this.columns[n].getColumnAlias();
            if (string == null) {
                string = this.columns[n].getColumnName();
            }
            return string;
        }
        if (n2 == 1) {
            return this.selected[n];
        }
        return "";
    }

    public void selectAll() {
        this.setFlagForAll(true);
    }

    public void selectNone() {
        this.setFlagForAll(false);
    }

    private void setFlagForAll(boolean bl) {
        for (int i = 0; i < this.rows; ++i) {
            this.selected[i] = bl;
        }
    }

    @Override
    public int getRowCount() {
        return this.rows;
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return String.class;
        }
        return Boolean.class;
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return this.colLabel;
        }
        return this.selectLabel;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 1;
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 1 && object instanceof Boolean) {
            Boolean bl = (Boolean)object;
            this.selected[n] = bl;
        }
    }
}

