/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import workbench.db.ConnectionProfile;
import workbench.db.DbSwitcher;
import workbench.db.WbConnection;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.gui.components.SwitchDbComboBox;
import workbench.gui.components.WbLabelField;
import workbench.gui.tools.ConnectionInfoPanel;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.ssh.SshConfig;

public class ConnectionInfo
extends JPanel
implements PropertyChangeListener,
ActionListener,
MouseListener {
    private WbConnection sourceConnection;
    private Color defaultBackground;
    private WbAction showInfoAction;
    private WbLabelField infoText;
    private JLabel iconLabel;
    private boolean useCachedSchema;
    private SwitchDbComboBox dbSwitcher;
    private JPanel contentPanel = new JPanel(new GridBagLayout());

    public ConnectionInfo(Color color) {
        super(new BorderLayout(2, 0));
        this.add((Component)this.contentPanel, "Center");
        this.infoText = new WbLabelField();
        this.infoText.setOpaque(false);
        this.contentPanel.setOpaque(true);
        if (color != null) {
            this.contentPanel.setBackground(color);
            this.defaultBackground = color;
        } else {
            this.defaultBackground = this.infoText.getBackground();
        }
        this.showInfoAction = new WbAction(this, "show-info");
        this.showInfoAction.setMenuTextByKey("MnuTxtConnInfo");
        this.showInfoAction.setEnabled(false);
        this.infoText.addPopupAction(this.showInfoAction);
        this.infoText.setText(ResourceMgr.getString("TxtNotConnected"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        this.contentPanel.add((Component)this.infoText, gridBagConstraints);
    }

    private void removeDbSwitcher() {
        if (this.dbSwitcher != null) {
            this.remove(this.dbSwitcher);
            this.dbSwitcher.clear();
            this.dbSwitcher = null;
        }
    }

    private void addDbSwitcher(WbConnection wbConnection) {
        if (wbConnection == null) {
            return;
        }
        if (this.dbSwitcher == null) {
            LogMgr.logTrace(new CallerInfo(){}, "Adding DB switcher in thread: " + Thread.currentThread() + " for: " + wbConnection);
            this.dbSwitcher = new SwitchDbComboBox(wbConnection);
            this.add((Component)this.dbSwitcher, "Before");
        } else {
            LogMgr.logTrace(new CallerInfo(){}, "Updating DB switcher in thread: " + Thread.currentThread() + " for: " + wbConnection);
            this.dbSwitcher.setConnection(wbConnection);
        }
        this.dbSwitcher.setEnabled(!wbConnection.isBusy());
    }

    private boolean useDbSwitcher(WbConnection wbConnection) {
        if (wbConnection == null) {
            return false;
        }
        if (wbConnection.isClosed()) {
            return false;
        }
        if (!wbConnection.getDbSettings().enableDatabaseSwitcher()) {
            return false;
        }
        DbSwitcher dbSwitcher = DbSwitcher.Factory.createDatabaseSwitcher(wbConnection);
        return dbSwitcher != null && dbSwitcher.supportsSwitching(wbConnection);
    }

    private void updateDBSwitcher(WbConnection wbConnection) {
        if (this.useDbSwitcher(wbConnection)) {
            this.addDbSwitcher(wbConnection);
        } else {
            if (wbConnection != null) {
                LogMgr.logDebug(new CallerInfo(){}, "Removing DB switcher for: " + wbConnection);
            }
            this.removeDbSwitcher();
        }
    }

    private boolean connectionsAreEqual(WbConnection wbConnection, WbConnection wbConnection2) {
        if (wbConnection == null && wbConnection2 == null) {
            return true;
        }
        if (wbConnection == null || wbConnection2 == null) {
            return false;
        }
        if (wbConnection == wbConnection2) {
            return true;
        }
        if (wbConnection.getId().equals(wbConnection2.getId())) {
            return wbConnection.getUrl().equals(wbConnection2.getUrl());
        }
        return false;
    }

    public void setDbSwitcherEnabled(boolean bl) {
        if (this.dbSwitcher != null) {
            this.dbSwitcher.setEnabled(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnection(WbConnection wbConnection) {
        Serializable serializable;
        if (this.connectionsAreEqual(this.sourceConnection, wbConnection)) {
            return;
        }
        if (this.sourceConnection != null) {
            this.sourceConnection.removeChangeListener(this);
        }
        this.sourceConnection = wbConnection;
        Color color = null;
        Color color2 = null;
        if (this.sourceConnection != null) {
            this.sourceConnection.addChangeListener(this);
            serializable = wbConnection.getProfile();
            if (serializable != null) {
                color = serializable.getInfoDisplayColor();
                if (GuiSettings.useContrastColor() && color != null) {
                    color2 = WbSwingUtilities.getContrastColor(color);
                }
            }
        }
        this.updateDBSwitcher(this.sourceConnection);
        this.useCachedSchema = true;
        try {
            this.updateDisplay();
        }
        finally {
            this.useCachedSchema = false;
        }
        serializable = color;
        Color color3 = color2;
        EventQueue.invokeLater(() -> this.lambda$setConnection$0((Color)serializable, color3));
    }

    private void updateDisplay() {
        WbSwingUtilities.invoke(this::_updateDisplay);
    }

    private void _updateDisplay() {
        WbConnection wbConnection = this.sourceConnection;
        if (wbConnection != null && !wbConnection.isClosed()) {
            String string = wbConnection.getDisplayString(this.useCachedSchema);
            this.infoText.setText(string);
            StringBuilder stringBuilder = new StringBuilder(30);
            stringBuilder.append("<html>");
            stringBuilder.append(wbConnection.getDatabaseProductName());
            stringBuilder.append(" ");
            stringBuilder.append(wbConnection.getDatabaseVersion().toString());
            stringBuilder.append("<br>");
            stringBuilder.append(ResourceMgr.getFormattedString("TxtDrvVersion", wbConnection.getDriverVersion()));
            stringBuilder.append("<br>");
            stringBuilder.append("Connection ID: " + wbConnection.getId());
            SshConfig sshConfig = wbConnection.getProfile().getSshConfig();
            if (sshConfig != null) {
                stringBuilder.append("<br>SSH: ");
                stringBuilder.append(sshConfig.getInfoString());
            }
            stringBuilder.append("</html>");
            this.infoText.setToolTipText(stringBuilder.toString());
        } else {
            this.infoText.setText(ResourceMgr.getString("TxtNotConnected"));
            this.infoText.setToolTipText(null);
        }
        this.infoText.setBackground(this.getBackground());
        this.infoText.setCaretPosition(0);
        this.showMode();
        this.invalidate();
        this.validate();
        if (this.getParent() != null) {
            this.getParent().invalidate();
            this.getParent().validate();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.sourceConnection) {
            switch (propertyChangeEvent.getPropertyName()) {
                case "catalog": 
                case "schema": 
                case "readonly": {
                    this.updateDisplay();
                    break;
                }
                case "busy": {
                    if (this.dbSwitcher == null) break;
                    boolean bl = Boolean.parseBoolean((String)propertyChangeEvent.getNewValue());
                    this.dbSwitcher.setEnabled(!bl);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.sourceConnection == null) {
            return;
        }
        ConnectionInfoPanel.showConnectionInfo(this.sourceConnection);
    }

    private void showMode() {
        String string = null;
        if (this.sourceConnection == null) {
            this.hideIcon();
        } else {
            ConnectionProfile connectionProfile = this.sourceConnection.getProfile();
            boolean bl = connectionProfile.isReadOnly();
            boolean bl2 = this.sourceConnection.isSessionReadOnly();
            if (bl && !bl2) {
                this.showIcon("unlocked");
                string = ResourceMgr.getString("TxtConnReadOnlyOff");
            } else if (bl || bl2) {
                this.showIcon("lock");
                string = ResourceMgr.getString("TxtConnReadOnly");
            } else {
                this.hideIcon();
            }
        }
        if (this.iconLabel != null) {
            this.iconLabel.setToolTipText(string);
        }
        this.invalidate();
    }

    private void hideIcon() {
        if (this.iconLabel != null) {
            this.iconLabel.removeMouseListener(this);
            this.remove(this.iconLabel);
            this.iconLabel = null;
        }
    }

    private void showIcon(String string) {
        if (this.iconLabel == null) {
            this.iconLabel = new JLabel();
            this.iconLabel.setOpaque(false);
            this.iconLabel.addMouseListener(this);
            this.iconLabel.setBackground(this.getBackground());
        }
        ImageIcon imageIcon = IconMgr.getInstance().getPngIcon(string, IconMgr.getInstance().getToolbarIconSize());
        this.iconLabel.setIcon(imageIcon);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        this.contentPanel.add((Component)this.iconLabel, gridBagConstraints);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1 && this.sourceConnection != null) {
            Window window;
            boolean bl;
            ConnectionProfile connectionProfile = this.sourceConnection.getProfile();
            boolean bl2 = connectionProfile.isReadOnly();
            boolean bl3 = this.sourceConnection.isSessionReadOnly();
            if (!bl3 && bl2) {
                this.sourceConnection.resetSessionReadOnly();
            }
            if (bl2 && bl3 && (bl = WbSwingUtilities.getYesNo(window = SwingUtilities.getWindowAncestor(this), ResourceMgr.getString("MsgDisableReadOnly")))) {
                this.sourceConnection.setSessionReadOnly(false);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void dispose() {
        if (this.showInfoAction != null) {
            this.showInfoAction.dispose();
        }
        this.infoText.dispose();
        if (this.sourceConnection != null) {
            this.sourceConnection.removeChangeListener(this);
        }
        if (this.dbSwitcher != null) {
            this.dbSwitcher.clear();
        }
    }

    private /* synthetic */ void lambda$setConnection$0(Color color, Color color2) {
        this.showInfoAction.setEnabled(this.sourceConnection != null);
        if (color == null) {
            this.contentPanel.setBackground(this.defaultBackground);
        } else {
            this.contentPanel.setBackground(color);
        }
        if (color2 == null) {
            this.infoText.setForeground(UIManager.getDefaults().getColor("Label.foreground"));
            Font font = this.infoText.getFont();
            if (GuiSettings.useBoldFontForConnectionInfo()) {
                this.infoText.setFont(font.deriveFont(font.getStyle() - 1));
            }
        } else {
            this.infoText.setForeground(color2);
            if (GuiSettings.useBoldFontForConnectionInfo()) {
                this.infoText.setFont(this.infoText.getFont().deriveFont(1));
            }
        }
    }
}

