/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Toolkit;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import workbench.db.ColumnIdentifier;
import workbench.db.ConnectionProfile;
import workbench.db.WbConnection;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.WbTable;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.storage.DataStore;
import workbench.storage.InputValidator;
import workbench.storage.NamedSortDefinition;
import workbench.storage.ResultInfo;
import workbench.storage.SortDefinition;
import workbench.storage.filter.FilterExpression;
import workbench.util.ConverterException;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.WbThread;

public class DataStoreTableModel
extends AbstractTableModel {
    private DataStore dataCache;
    private boolean showStatusColumn;
    private int columnStartIndex;
    private List<Integer> noneditableColumns = new ArrayList<Integer>();
    private SortDefinition sortDefinition = new SortDefinition();
    private boolean allowEditing = true;
    private boolean allowEditMode = true;
    private boolean showConverterError = true;
    private final Object model_change_lock = new Object();
    private Set<Integer> readOnlyColumns;
    private InputValidator inputValidator;
    private boolean sortingInProgress = false;

    public DataStoreTableModel(DataStore dataStore) throws IllegalArgumentException {
        if (dataStore == null) {
            throw new IllegalArgumentException("DataStore cannot be null");
        }
        this.setDataStore(dataStore);
    }

    public DataStore getDataStore() {
        return this.dataCache;
    }

    public final void setDataStore(DataStore dataStore) {
        this.dispose();
        this.dataCache = dataStore;
        this.showStatusColumn = false;
        this.columnStartIndex = 0;
        if (dataStore.getLastSort() != null) {
            this.sortDefinition = dataStore.getLastSort();
        }
        this.fireTableStructureChanged();
    }

    public void setShowConverterError(boolean bl) {
        this.showConverterError = bl;
    }

    public void setSortIgnoreCase(boolean bl) {
        this.sortDefinition.setIgnoreCase(bl);
    }

    public boolean isColumnModified(int n, int n2) {
        if (this.showStatusColumn && n2 == 0) {
            return false;
        }
        try {
            return this.dataCache.isColumnModified(n, n2 - this.columnStartIndex);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error checking value at: " + n + "/" + n2, exception);
            return false;
        }
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        TableModelListener[] tableModelListenerArray;
        if (tableModelListener == null) {
            return;
        }
        for (TableModelListener tableModelListener2 : tableModelListenerArray = this.getTableModelListeners()) {
            if (tableModelListener != tableModelListener2) continue;
            return;
        }
        super.addTableModelListener(tableModelListener);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.showStatusColumn && n2 == 0) {
            return this.dataCache.getRowStatus(n);
        }
        try {
            Object object = this.dataCache.getValue(n, n2 - this.columnStartIndex);
            return object;
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error retrieving value at: " + n + "/" + n2, exception);
            return "Error";
        }
    }

    public void addColumn(ColumnIdentifier columnIdentifier, int n) {
        this.dataCache.addColumnAt(columnIdentifier, n);
        this.fireTableStructureChanged();
    }

    @Override
    public int findColumn(String string) {
        int n = this.dataCache.getColumnIndex(string);
        if (n == -1) {
            return -1;
        }
        return n + this.columnStartIndex;
    }

    public int getRealColumnStart() {
        return this.columnStartIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatusColumnVisible(boolean bl) {
        if (bl == this.showStatusColumn) {
            return;
        }
        Object object = this.model_change_lock;
        synchronized (object) {
            this.columnStartIndex = bl ? 1 : 0;
            this.showStatusColumn = bl;
        }
        this.fireTableStructureChanged();
    }

    public boolean isStatusColumnVisible() {
        return this.showStatusColumn;
    }

    public boolean isUpdateable() {
        if (this.dataCache == null) {
            return false;
        }
        return this.dataCache.isUpdateable();
    }

    private boolean isNull(Object object, int n) {
        if (object == null) {
            return true;
        }
        String string = object.toString();
        int n2 = this.dataCache.getColumnType(n);
        if (SqlUtil.isCharacterType(n2)) {
            ConnectionProfile connectionProfile;
            WbConnection wbConnection = this.dataCache.getOriginalConnection();
            ConnectionProfile connectionProfile2 = connectionProfile = wbConnection != null ? wbConnection.getProfile() : null;
            if (connectionProfile == null || connectionProfile.getEmptyStringIsNull()) {
                return string.length() == 0;
            }
            return false;
        }
        return StringUtil.isEmptyString(string);
    }

    public void setValidator(InputValidator inputValidator) {
        this.inputValidator = inputValidator;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (this.showStatusColumn && n2 == 0) {
            return;
        }
        if (!this.allowEditing) {
            return;
        }
        if (this.inputValidator != null && !this.inputValidator.isValid(object, n, n2, this)) {
            return;
        }
        this.setValue(object, n, n2);
    }

    public void setValue(Object object, int n, int n2) {
        int n3 = n2 - this.columnStartIndex;
        if (this.readOnlyColumns != null && this.readOnlyColumns.contains(n3)) {
            return;
        }
        if (this.isNull(object, n3)) {
            this.dataCache.setValue(n, n3, null);
        } else {
            try {
                this.dataCache.setInputValue(n, n3, object);
            }
            catch (ConverterException converterException) {
                int n4 = this.getColumnType(n2);
                LogMgr.logError(new CallerInfo(){}, "Error converting input >" + object + "< to column type " + SqlUtil.getTypeName(n4) + " (" + n4 + ")", converterException);
                Toolkit.getDefaultToolkit().beep();
                String string = ResourceMgr.getString("MsgConvertError");
                string = string + "\r\n" + converterException.getLocalizedMessage();
                if (this.showConverterError) {
                    WbSwingUtilities.showErrorMessage(string);
                    return;
                }
                throw new IllegalArgumentException(string);
            }
        }
        WbSwingUtilities.invoke(() -> this.fireTableRowsUpdated(n, n));
    }

    @Override
    public int getColumnCount() {
        return this.dataCache.getColumnCount() + this.columnStartIndex;
    }

    public int getColumnWidth(int n) {
        if (this.showStatusColumn && n == 0) {
            return 5;
        }
        if (this.dataCache == null) {
            return 0;
        }
        try {
            return this.dataCache.getColumnSize(n);
        }
        catch (Exception exception) {
            LogMgr.logWarning(new CallerInfo(){}, "Error retrieving display size for column " + n, exception);
            return 100;
        }
    }

    public String getColumnTypeName(int n) {
        if (this.dataCache == null) {
            return "";
        }
        if (this.showStatusColumn && n == 0) {
            return "";
        }
        try {
            ResultInfo resultInfo = this.dataCache.getResultInfo();
            return resultInfo.getColumn(n - this.columnStartIndex).getColumnTypeName();
        }
        catch (Exception exception) {
            return SqlUtil.getTypeName(this.getColumnType(n));
        }
    }

    public String getColumnTable(int n) {
        if (this.dataCache == null) {
            return null;
        }
        if (this.showStatusColumn && n == 0) {
            return null;
        }
        try {
            ResultInfo resultInfo = this.dataCache.getResultInfo();
            return resultInfo.getColumn(n - this.columnStartIndex).getSourceTableName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getColumnRemarks(int n) {
        if (this.dataCache == null) {
            return null;
        }
        if (this.showStatusColumn && n == 0) {
            return null;
        }
        try {
            ResultInfo resultInfo = this.dataCache.getResultInfo();
            return resultInfo.getColumn(n - this.columnStartIndex).getComment();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getDbmsType(int n) {
        if (this.dataCache == null) {
            return null;
        }
        if (this.showStatusColumn && n == 0) {
            return null;
        }
        try {
            ResultInfo resultInfo = this.dataCache.getResultInfo();
            return resultInfo.getDbmsTypeName(n - this.columnStartIndex);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getColumnType(int n) {
        if (this.dataCache == null) {
            return 0;
        }
        if (this.showStatusColumn && n == 0) {
            return 0;
        }
        try {
            return this.dataCache.getColumnType(n - this.columnStartIndex);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 12;
        }
    }

    public int getFilteredCount() {
        if (this.dataCache == null) {
            return 0;
        }
        return this.dataCache.getFilteredCount();
    }

    @Override
    public int getRowCount() {
        if (this.dataCache == null) {
            return 0;
        }
        return this.dataCache.getRowCount();
    }

    public ColumnIdentifier getColumn(int n) {
        if (this.dataCache == null) {
            return null;
        }
        if (n == 0 && this.showStatusColumn) {
            return null;
        }
        return this.dataCache.getColumn(n - this.columnStartIndex);
    }

    public Class getColumnClass(int n) {
        if (this.dataCache == null) {
            return null;
        }
        if (n == 0 && this.showStatusColumn) {
            return Integer.class;
        }
        return this.dataCache.getColumnClass(n - this.columnStartIndex);
    }

    public int insertRow(int n) {
        int n2 = this.dataCache.insertRowAfter(n);
        this.fireTableRowsInserted(n2, n2);
        return n2;
    }

    public int addRow() {
        int n = this.dataCache.addRow();
        this.fireTableRowsInserted(n, n);
        return n;
    }

    public void deleteRow(int n, boolean bl) throws SQLException {
        if (bl) {
            this.dataCache.deleteRowWithDependencies(n);
        } else {
            this.dataCache.deleteRow(n);
        }
        this.fireTableRowsDeleted(n, n);
    }

    public int duplicateRow(int n) {
        int n2 = this.dataCache.duplicateRow(n);
        this.fireTableRowsInserted(n2, n2);
        return n2;
    }

    public void fileImported() {
        int n = this.getRowCount();
        this.fireTableRowsInserted(0, n - 1);
    }

    public void removeAll() {
        if (this.dataCache != null) {
            this.dataCache.reset();
            this.fireTableDataChanged();
        }
    }

    public void dispose() {
        this.listenerList = new EventListenerList();
        if (this.dataCache != null) {
            this.dataCache.reset();
            this.dataCache = null;
        }
    }

    @Override
    public String getColumnName(int n) {
        if (this.showStatusColumn && n == 0) {
            return " ";
        }
        try {
            String string = this.dataCache.getColumnDisplayName(n - this.columnStartIndex);
            return string;
        }
        catch (Exception exception) {
            return "(n/a)";
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.noneditableColumns.contains(n2) || this.columnStartIndex > 0 && n2 < this.columnStartIndex) {
            return false;
        }
        return this.allowEditMode || SqlUtil.isBlobType(this.getColumnType(n2));
    }

    public void clearLockedColumn() {
        this.noneditableColumns.clear();
    }

    public void setLockedColumn(int n) {
        this.clearLockedColumn();
        this.noneditableColumns.add(n);
    }

    public void setNonEditableColums(int ... nArray) {
        this.clearLockedColumn();
        if (nArray == null) {
            return;
        }
        for (int n : nArray) {
            if (n <= -1) continue;
            this.noneditableColumns.add(n);
        }
    }

    public void setAllowEditing(boolean bl) {
        this.allowEditing = bl;
        this.allowEditMode = bl;
    }

    public boolean getAllowEditing() {
        return this.allowEditing;
    }

    public void setAllowEditMode(boolean bl) {
        this.allowEditMode = bl;
    }

    public void resetFilter() {
        if (this.isSortInProgress()) {
            return;
        }
        this.dataCache.clearFilter();
        if (!this.sort()) {
            this.fireTableDataChanged();
        }
    }

    public void applyFilter(FilterExpression filterExpression) {
        if (this.isSortInProgress()) {
            return;
        }
        this.dataCache.applyFilter(filterExpression);
        if (!this.sort()) {
            this.fireTableDataChanged();
        }
    }

    private void setSortInProgress(boolean bl) {
        this.sortingInProgress = bl;
    }

    private boolean isSortInProgress() {
        return this.sortingInProgress;
    }

    public boolean isSortAscending(int n) {
        return this.sortDefinition.isSortAscending(n - this.columnStartIndex);
    }

    public boolean isPrimarySortColumn(int n) {
        return this.sortDefinition.isPrimarySortColumn(n - this.columnStartIndex);
    }

    public boolean isSortColumn(int n) {
        return this.sortDefinition.isSortColumn(n - this.columnStartIndex);
    }

    public NamedSortDefinition getSortDefinition() {
        if (this.sortDefinition == null) {
            return null;
        }
        if (this.sortDefinition.isEmpty()) {
            return null;
        }
        if (!this.sortDefinition.isValid()) {
            return null;
        }
        NamedSortDefinition namedSortDefinition = new NamedSortDefinition(this.dataCache, this.sortDefinition);
        if (namedSortDefinition.getColumnCount() > 0) {
            return namedSortDefinition;
        }
        return null;
    }

    public SortDefinition getSortColumns() {
        if (this.sortDefinition == null) {
            return null;
        }
        return this.sortDefinition.createCopy();
    }

    public void setSortDefinition(SortDefinition sortDefinition) {
        if (!sortDefinition.equals(this.sortDefinition)) {
            this.sortDefinition = sortDefinition;
            this.applySortColumns();
        }
    }

    public void setSortDefinition(NamedSortDefinition namedSortDefinition) {
        if (namedSortDefinition == null) {
            return;
        }
        SortDefinition sortDefinition = namedSortDefinition.getSortDefinition(this.dataCache);
        this.setSortDefinition(sortDefinition);
    }

    public boolean sort() {
        if (this.sortDefinition == null) {
            return false;
        }
        this.applySortColumns();
        return true;
    }

    public void removeSortColumn(int n) {
        if (this.sortDefinition == null) {
            return;
        }
        boolean bl = this.sortDefinition.isPrimarySortColumn(n);
        this.sortDefinition.removeSortColumn(n);
        if (bl) {
            this.applySortColumns();
        }
    }

    public void sortByColumn(int n, boolean bl, boolean bl2) {
        if (bl2) {
            this.sortDefinition.addSortColumn(n - this.columnStartIndex, bl);
        } else {
            this.sortDefinition.setSortColumn(n - this.columnStartIndex, bl);
        }
        this.applySortColumns();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applySortColumns() {
        if (this.sortDefinition == null) {
            return;
        }
        if (this.dataCache == null) {
            return;
        }
        Object object = this.model_change_lock;
        synchronized (object) {
            try {
                this.setSortInProgress(true);
                this.dataCache.sort(this.sortDefinition);
            }
            catch (Throwable throwable) {
                LogMgr.logError(new CallerInfo(){}, "Error when sorting data", throwable);
            }
            finally {
                this.setSortInProgress(false);
            }
        }
        WbSwingUtilities.invoke(this::fireTableDataChanged);
    }

    public void startBackgroundSort(WbTable wbTable, int n, boolean bl, boolean bl2) {
        if (this.sortingInProgress) {
            return;
        }
        if (n < 0 && n >= this.getColumnCount()) {
            LogMgr.logWarning(new CallerInfo(){}, "Wrong column index for sorting specified!");
            return;
        }
        int n2 = this.sortDefinition.getColumnCount();
        boolean bl3 = true;
        bl3 = bl2 && (n2 == 0 || !bl) ? false : !this.isSortAscending(n);
        this.sortInBackground(wbTable, n, bl3, bl);
    }

    public void sortInBackground(final WbTable wbTable, final int n, final boolean bl, final boolean bl2) {
        if (this.isSortInProgress()) {
            return;
        }
        WbThread wbThread = new WbThread("Data Sort"){

            @Override
            public void run() {
                try {
                    wbTable.sortingStarted();
                    DataStoreTableModel.this.sortByColumn(n, bl, bl2);
                }
                finally {
                    wbTable.sortingFinished();
                }
            }
        };
        wbThread.start();
    }
}

