/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class DividerBorder
extends AbstractBorder {
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int TOP = 4;
    public static final int BOTTOM = 8;
    public static final int LEFT_RIGHT = 3;
    public static final int VERTICAL_MIDDLE = 16;
    public static final int HORIZONTAL_MIDDLE = 32;
    private final int borderType;
    private final boolean shadow;
    public static final DividerBorder BOTTOM_DIVIDER = new DividerBorder(8);

    public DividerBorder(int n) {
        this(n, true);
    }

    public DividerBorder(int n, boolean bl) {
        this.borderType = n;
        this.shadow = bl;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        Color color = graphics.getColor();
        Color color2 = component.getBackground();
        Color color3 = color2.brighter();
        Color color4 = color2.darker();
        if ((this.borderType & 4) == 4) {
            graphics.setColor(color4);
            graphics.drawLine(n, n2, n + n3, n2);
            if (this.shadow) {
                graphics.setColor(color3);
                graphics.drawLine(n, n2 + 1, n + n3, n2 + 1);
            }
        }
        if ((this.borderType & 8) == 8) {
            graphics.setColor(color4);
            graphics.drawLine(n, n2 + n4 - 2, n + n3, n2 + n4 - 2);
            if (this.shadow) {
                graphics.setColor(color3);
                graphics.drawLine(n, n2 + n4 - 1, n + n3, n2 + n4 - 1);
            }
        }
        if ((this.borderType & 1) == 1) {
            graphics.setColor(color4);
            graphics.drawLine(n, n2, n, n2 + n4);
            if (this.shadow) {
                graphics.setColor(color3);
                graphics.drawLine(n + 1, n2, n + 1, n2 + n4);
            }
        }
        if ((this.borderType & 2) == 2) {
            graphics.setColor(color4);
            graphics.drawLine(n + n3 - 2, n2, n + n3 - 2, n2 + n4);
            if (this.shadow) {
                graphics.setColor(color3);
                graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4);
            }
        }
        if ((this.borderType & 0x10) == 16) {
            n5 = n3 / 2;
            graphics.setColor(color4);
            graphics.drawLine(n + n5, n2, n + n5, n2 + n4);
            if (this.shadow) {
                graphics.setColor(color3);
                graphics.drawLine(n + n5 + 1, n2, n + n5 + 1, n2 + n4);
            }
        }
        if ((this.borderType & 0x20) == 32) {
            n5 = n4 / 2;
            graphics.setColor(color4);
            graphics.drawLine(0, n2 + n5, n3, n2 + n5);
            if (this.shadow) {
                graphics.setColor(color3);
                graphics.drawLine(0, n2 + n5 + 1, n3, n2 + n5 + 1);
            }
        }
        graphics.setColor(color);
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return new Insets(2, 2, 2, 2);
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        insets.bottom = 2;
        insets.right = 2;
        insets.top = 2;
        insets.left = 2;
        return insets;
    }
}

