/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import workbench.resource.Settings;

public class FocusIndicator
implements FocusListener {
    private Border focusBorder;
    private Border noFocusBorder;
    private Border originalBorder;
    private JComponent focusClient;
    private JComponent borderClient;
    private Color borderColor;

    public FocusIndicator(JComponent jComponent, JComponent jComponent2) {
        this.focusClient = jComponent;
        this.focusClient.addFocusListener(this);
        this.borderClient = jComponent2;
        this.borderColor = Settings.getInstance().getColor("workbench.gui.focusindicator.bordercolor", Color.YELLOW.brighter());
        this.initBorder();
    }

    private void initBorder() {
        if (this.noFocusBorder == null && this.focusBorder == null && this.originalBorder == null) {
            this.originalBorder = this.borderClient.getBorder();
            this.noFocusBorder = new CompoundBorder(new EmptyBorder(1, 1, 1, 1), this.originalBorder);
            this.borderClient.setBorder(this.noFocusBorder);
            this.focusBorder = new CompoundBorder(new LineBorder(this.borderColor, 1), this.originalBorder);
        }
    }

    public void dispose() {
        if (this.focusClient != null) {
            this.focusClient.removeFocusListener(this);
        }
        if (this.borderClient != null && this.originalBorder != null) {
            this.borderClient.setBorder(this.originalBorder);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.borderClient != null) {
            this.initBorder();
            this.borderClient.setBorder(this.focusBorder);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.borderClient != null) {
            this.initBorder();
            this.borderClient.setBorder(this.noFocusBorder);
        }
    }
}

