/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Component;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import workbench.gui.components.ComboboxEditorWrapper;
import workbench.gui.components.TextComponentMouseListener;
import workbench.interfaces.PropertyStorage;
import workbench.resource.Settings;
import workbench.util.FixedSizeList;
import workbench.util.StringUtil;

public class HistoryTextField
extends JComboBox {
    private String propName;
    private FixedSizeList<String> historyValues;
    private TextComponentMouseListener contextMenu;

    public HistoryTextField() {
        this((String)null);
    }

    public HistoryTextField(String string) {
        this.setEditable(true);
        this.setSettingsProperty(string);
        this.contextMenu = new TextComponentMouseListener();
        ComboBoxEditor comboBoxEditor = this.getEditor();
        ComboboxEditorWrapper comboboxEditorWrapper = new ComboboxEditorWrapper(comboBoxEditor);
        this.setEditor(comboboxEditorWrapper);
        this.getEditor().getEditorComponent().addMouseListener(this.contextMenu);
        this.getEditor().getEditorComponent().setFocusTraversalKeysEnabled(true);
        this.setFocusTraversalKeysEnabled(true);
    }

    public void dispose() {
        Component component;
        this.historyValues.clear();
        ComboBoxEditor comboBoxEditor = this.getEditor();
        if (comboBoxEditor != null && (component = comboBoxEditor.getEditorComponent()) != null) {
            KeyListener[] keyListenerArray;
            component.removeMouseListener(this.contextMenu);
            for (KeyListener keyListener : keyListenerArray = component.getKeyListeners()) {
                component.removeKeyListener(keyListener);
            }
        }
        this.contextMenu.dispose();
    }

    public void setSettingsProperty(String string) {
        this.propName = string;
        int n = Settings.getInstance().getIntProperty("workbench.history." + this.propName + ".size", 25);
        this.historyValues = new FixedSizeList(n);
    }

    public void selectAll() {
        Component component = this.getEditor().getEditorComponent();
        if (component instanceof JTextField) {
            JTextField jTextField = (JTextField)component;
            jTextField.select(0, jTextField.getText().length());
        }
    }

    public void setColumns(int n) {
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append('w');
        }
        this.setPrototypeDisplayValue(stringBuilder);
    }

    public void setText(String string) {
        if (!StringUtil.equalString(string, this.getText())) {
            this.setSelectedItem(string);
        }
    }

    public String getEditorText() {
        Component component = this.getEditor().getEditorComponent();
        if (component instanceof JTextField) {
            JTextField jTextField = (JTextField)component;
            return jTextField.getText();
        }
        return (String)this.getEditor().getItem();
    }

    public String getText() {
        Object object = this.getSelectedItem();
        if (object != null) {
            return (String)object;
        }
        object = this.getEditor().getItem();
        if (object != null) {
            return (String)object;
        }
        Component component = this.getEditor().getEditorComponent();
        if (component instanceof JTextField) {
            JTextField jTextField = (JTextField)component;
            return jTextField.getText();
        }
        return null;
    }

    public void saveSettings(PropertyStorage propertyStorage, String string) {
        propertyStorage.setProperty(string + this.propName + ".history", StringUtil.listToString(this.historyValues, ';', true));
        propertyStorage.setProperty(string + this.propName + ".lastvalue", this.getText());
    }

    public void restoreSettings(PropertyStorage propertyStorage, String string) {
        String string2 = propertyStorage.getProperty(string + this.propName + ".history", "");
        List<String> list = StringUtil.stringToList(string2, ";", true, true);
        this.setText("");
        this.historyValues.clear();
        for (String string3 : list) {
            this.historyValues.append(string3);
        }
        this.updateModel();
        String string4 = propertyStorage.getProperty(string + this.propName + ".lastvalue", null);
        if (string4 != null) {
            this.setText(string4);
        }
    }

    public void restoreSettings() {
        this.restoreSettings(Settings.getInstance(), "workbench.quickfilter.");
    }

    public void saveSettings() {
        this.saveSettings(Settings.getInstance(), "workbench.quickfilter.");
    }

    public void storeCurrent() {
        this.addToHistory(this.getText());
    }

    public void addToHistory(String string) {
        if (StringUtil.isEmptyString(string)) {
            return;
        }
        string = string.trim();
        Object object = this.getSelectedItem();
        this.historyValues.addEntry(string);
        this.updateModel();
        this.setSelectedItem(object);
    }

    private void updateModel() {
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        for (String string : this.historyValues.getEntries()) {
            defaultComboBoxModel.addElement(string);
        }
        this.setModel(defaultComboBoxModel);
    }
}

