/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.reflect.Method;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import workbench.gui.components.TextComponentMouseListener;
import workbench.interfaces.SimplePropertyEditor;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class IntegerPropertyEditor
extends JTextField
implements DocumentListener,
SimplePropertyEditor,
FocusListener {
    private Object source;
    private Method setter;
    private Method getter;
    private boolean changed;
    private boolean immediateUpdate;
    private String propName;

    public IntegerPropertyEditor() {
        this.addFocusListener(this);
        this.addMouseListener(new TextComponentMouseListener());
    }

    @Override
    public void setSourceObject(Object object, String string) {
        this.setSourceObject(object, string, null);
    }

    public int getValue() {
        try {
            return Integer.parseInt(this.getText());
        }
        catch (Exception exception) {
            return Integer.MIN_VALUE;
        }
    }

    public void setSourceObject(Object object, String string, String string2) {
        this.source = object;
        this.changed = false;
        this.propName = string;
        this.getDocument().removeDocumentListener(this);
        if (this.source == null) {
            this.setter = null;
            this.getter = null;
            this.setText("");
            return;
        }
        String string3 = Character.toUpperCase(string.charAt(0)) + string.substring(1);
        if (string2 != null) {
            this.setText(string2);
        }
        try {
            String string4 = "get" + string3;
            Class<?> clazz = object.getClass();
            this.getter = clazz.getMethod(string4, null);
            string4 = "set" + string3;
            Class[] classArray = new Class[]{Integer.class};
            this.setter = clazz.getMethod(string4, classArray);
            Integer n = (Integer)this.getter.invoke(this.source, (Object[])null);
            if (n == null) {
                this.setText("");
            } else {
                this.setText(n.toString());
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error during init", exception);
        }
        this.getDocument().addDocumentListener(this);
    }

    @Override
    public void applyChanges() {
        if (!this.changed) {
            return;
        }
        if (this.source == null) {
            return;
        }
        if (this.setter == null) {
            return;
        }
        Object[] objectArray = new Object[1];
        try {
            objectArray[0] = this.getValue();
            this.setter.invoke(this.source, objectArray);
            this.changed = false;
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error setting value", exception);
        }
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.documentChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.documentChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.documentChanged();
    }

    private void documentChanged() {
        this.changed = true;
        if (this.immediateUpdate) {
            this.applyChanges();
        }
        this.firePropertyChange(this.propName, null, null);
    }

    @Override
    public void setImmediateUpdate(boolean bl) {
        this.immediateUpdate = bl;
        if (bl) {
            this.applyChanges();
        }
    }

    @Override
    public boolean getImmediateUpdate() {
        return this.immediateUpdate;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (!this.immediateUpdate) {
            this.applyChanges();
        }
    }
}

