/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Reader;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.DividerBorder;
import workbench.gui.components.TextComponentMouseListener;
import workbench.gui.editor.SearchAndReplace;
import workbench.interfaces.Restoreable;
import workbench.interfaces.TextContainer;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;

public class PlainEditor
extends JPanel
implements ActionListener,
TextContainer,
Restoreable {
    private JTextArea editor = new JTextArea();
    private JCheckBox wordWrap;
    private Color enabledBackground = this.editor.getBackground();
    private JLabel infoText;
    private JPanel toolPanel;
    private JScrollPane scroll;
    private String wrapSettingsKey;
    private TextComponentMouseListener editMenu;

    public PlainEditor() {
        this("workbench.editor.plain.wordwrap", true, true);
    }

    public PlainEditor(String string, boolean bl, boolean bl2) {
        this.editor.putClientProperty("JTextArea.infoBackground", Boolean.TRUE);
        this.editMenu = new TextComponentMouseListener(this.editor);
        this.scroll = new JScrollPane(this.editor);
        this.editor.setFont(Settings.getInstance().getEditorFont());
        this.setLayout(new BorderLayout());
        this.wrapSettingsKey = string;
        if (bl2) {
            this.editor.setLineWrap(true);
            this.editor.setWrapStyleWord(true);
            this.toolPanel = new JPanel();
            this.toolPanel.setLayout(new FlowLayout(0, 0, 0));
            this.wordWrap = new JCheckBox(ResourceMgr.getString("LblWordWrap"));
            this.wordWrap.setSelected(true);
            this.wordWrap.setFocusable(false);
            this.wordWrap.addActionListener(this);
            this.toolPanel.add(this.wordWrap);
            this.add((Component)this.toolPanel, "North");
        }
        this.add((Component)this.scroll, "Center");
        this.setFocusable(false);
        Document document = this.editor.getDocument();
        if (document != null) {
            int n = Settings.getInstance().getEditorTabWidth();
            document.putProperty("tabSize", n);
        }
        if (bl) {
            SearchAndReplace searchAndReplace = new SearchAndReplace(this, this);
            this.editMenu.addAction(searchAndReplace.getFindAction());
            this.editMenu.addAction(searchAndReplace.getFindNextAction());
            this.editMenu.addAction(searchAndReplace.getReplaceAction());
        }
        this.setEditable(bl);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.editMenu.dispose();
    }

    public void removeBorders() {
        this.scroll.setBorder(WbSwingUtilities.EMPTY_BORDER);
        if (this.toolPanel != null) {
            this.toolPanel.setBorder(DividerBorder.BOTTOM_DIVIDER);
        }
    }

    @Override
    public int getCaretPosition() {
        return this.editor.getCaretPosition();
    }

    @Override
    public int getSelectionEnd() {
        return this.editor.getSelectionEnd();
    }

    @Override
    public int getSelectionStart() {
        return this.editor.getSelectionStart();
    }

    @Override
    public void select(int n, int n2) {
        this.editor.select(n, n2);
    }

    public void setInfoText(String string) {
        if (this.infoText == null && this.toolPanel != null) {
            this.infoText = new JLabel();
            this.toolPanel.add(Box.createHorizontalStrut(10));
            this.toolPanel.add(this.infoText);
        }
        this.infoText.setText(string);
    }

    public int getScrollbarWidth() {
        int n = 0;
        JScrollBar jScrollBar = this.scroll.getVerticalScrollBar();
        if (jScrollBar != null) {
            Dimension dimension = jScrollBar.getPreferredSize();
            n = dimension != null ? (int)dimension.getHeight() : jScrollBar.getHeight();
        }
        return n;
    }

    public int getScrollbarHeight() {
        int n = 0;
        JScrollBar jScrollBar = this.scroll.getHorizontalScrollBar();
        if (jScrollBar != null) {
            Dimension dimension = jScrollBar.getPreferredSize();
            n = dimension != null ? (int)dimension.getHeight() : jScrollBar.getHeight();
        }
        return n;
    }

    @Override
    public void requestFocus() {
        this.editor.requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.editor.requestFocusInWindow();
    }

    @Override
    public void restoreSettings() {
        if (this.wordWrap != null && this.wrapSettingsKey != null) {
            boolean bl = Settings.getInstance().getBoolProperty(this.wrapSettingsKey);
            this.wordWrap.setSelected(bl);
            this.editor.setLineWrap(bl);
        }
    }

    public void append(String string) {
        this.editor.append(string);
    }

    public void clear() {
        this.editor.setText("");
    }

    @Override
    public void saveSettings() {
        if (this.wordWrap != null) {
            Settings.getInstance().setProperty(this.wrapSettingsKey, this.wordWrap.isSelected());
        }
    }

    @Override
    public void setSelectedText(String string) {
        this.editor.replaceSelection(string);
    }

    @Override
    public String getText() {
        return this.editor.getText();
    }

    @Override
    public String getSelectedText() {
        return this.editor.getSelectedText();
    }

    public void readText(Reader reader) throws IOException {
        this.editor.read(reader, null);
    }

    @Override
    public void setText(String string) {
        this.editor.setText(string);
    }

    @Override
    public void setCaretPosition(int n) {
        this.editor.setCaretPosition(n);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.editor.setLineWrap(this.wordWrap.isSelected());
        if (this.wrapSettingsKey != null) {
            Settings.getInstance().setProperty(this.wrapSettingsKey, this.wordWrap.isSelected());
        }
    }

    @Override
    public void setEditable(boolean bl) {
        this.editor.setEditable(bl);
        this.editor.setBackground(this.enabledBackground);
    }

    @Override
    public boolean isEditable() {
        return this.editor.isEditable();
    }

    @Override
    public boolean isTextSelected() {
        return this.getSelectionStart() < this.getSelectionEnd();
    }

    @Override
    public String getWordAtCursor(String string) {
        return null;
    }

    @Override
    public int getLineCount() {
        return this.editor.getLineCount();
    }

    @Override
    public int getStartInLine(int n) {
        try {
            int n2 = this.getLineOfOffset(n);
            int n3 = this.editor.getLineStartOffset(n2);
            return n - n3;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    @Override
    public int getLineOfOffset(int n) {
        try {
            return this.editor.getLineOfOffset(n);
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    @Override
    public String getLineText(int n) {
        try {
            int n2 = this.editor.getLineStartOffset(n);
            int n3 = this.editor.getLineEndOffset(n);
            return this.editor.getText(n2, n3 - n2);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }
}

