/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.EscAction;
import workbench.gui.components.HistoryTextField;
import workbench.gui.components.WbButton;
import workbench.gui.components.WbTraversalPolicy;
import workbench.interfaces.Replaceable;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.ExceptionUtil;
import workbench.util.StringUtil;

public class ReplacePanel
extends JPanel
implements ActionListener,
WindowListener,
FocusListener {
    private String settingsKey;
    private String caseProperty;
    private String wordProperty;
    private String selectedProperty;
    private String regexProperty;
    private String criteriaProperty;
    private String replacementProperty;
    private String wrapProperty;
    private Replaceable client;
    private int lastPos = -1;
    private JDialog dialog;
    private EscAction escAction;
    protected JButton closeButton;
    protected JLabel criteriaLabel;
    protected JButton findButton;
    protected JButton findNextButton;
    protected JCheckBox ignoreCaseCheckBox;
    protected JPanel jPanel1;
    protected JButton replaceAllButton;
    protected JLabel replaceLabel;
    protected JButton replaceNextButton;
    protected JComboBox replaceValue;
    protected JComboBox searchCriteria;
    protected JCheckBox selectedTextCheckBox;
    protected JPanel spacerPanel;
    protected JCheckBox useRegexCheckBox;
    protected JCheckBox wordsOnlyCheckBox;
    protected JCheckBox wrapSearchCbx;

    public ReplacePanel(Replaceable replaceable) {
        this(replaceable, "workbench.sql.replace", null);
    }

    public ReplacePanel(Replaceable replaceable, String string, String string2) {
        this.initComponents();
        this.client = replaceable;
        this.settingsKey = string;
        this.caseProperty = this.settingsKey + ".ignoreCase";
        this.wordProperty = this.settingsKey + ".wholeWord";
        this.selectedProperty = this.settingsKey + ".selectedText";
        this.regexProperty = this.settingsKey + ".useRegEx";
        this.wrapProperty = this.settingsKey + ".wrapSearch";
        this.criteriaProperty = "criteria";
        this.replacementProperty = "replacement";
        WbTraversalPolicy wbTraversalPolicy = new WbTraversalPolicy();
        wbTraversalPolicy.addComponent(this.searchCriteria.getEditor().getEditorComponent());
        wbTraversalPolicy.addComponent(this.replaceValue.getEditor().getEditorComponent());
        wbTraversalPolicy.addComponent(this.ignoreCaseCheckBox);
        wbTraversalPolicy.addComponent(this.wordsOnlyCheckBox);
        wbTraversalPolicy.addComponent(this.useRegexCheckBox);
        wbTraversalPolicy.addComponent(this.selectedTextCheckBox);
        wbTraversalPolicy.addComponent(this.wrapSearchCbx);
        wbTraversalPolicy.addComponent(this.findButton);
        wbTraversalPolicy.addComponent(this.replaceNextButton);
        wbTraversalPolicy.addComponent(this.replaceAllButton);
        wbTraversalPolicy.addComponent(this.closeButton);
        wbTraversalPolicy.setDefaultComponent(this.searchCriteria.getEditor().getEditorComponent());
        this.setFocusTraversalPolicy(wbTraversalPolicy);
        this.findButton.addActionListener(this);
        this.replaceNextButton.addActionListener(this);
        this.replaceAllButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.findNextButton.addActionListener(this);
        this.replaceNextButton.setEnabled(false);
        this.findNextButton.setEnabled(false);
        ((HistoryTextField)this.searchCriteria).setColumns(30);
        ((HistoryTextField)this.searchCriteria).setSettingsProperty(this.criteriaProperty);
        ((HistoryTextField)this.replaceValue).setColumns(30);
        ((HistoryTextField)this.replaceValue).setSettingsProperty(this.replacementProperty);
        this.restoreSettings();
        if (string2 != null) {
            this.selectedTextCheckBox.setText(string2);
        }
        this.replaceValue.getEditor().getEditorComponent().addFocusListener(this);
        this.searchCriteria.getEditor().getEditorComponent().addFocusListener(this);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getComponent() == this.replaceValue.getEditor().getEditorComponent()) {
            this.replaceValue.getEditor().selectAll();
        } else if (focusEvent.getComponent() == this.searchCriteria.getEditor().getEditorComponent()) {
            this.searchCriteria.getEditor().selectAll();
        }
    }

    private void initComponents() {
        this.criteriaLabel = new JLabel();
        this.replaceLabel = new JLabel();
        this.spacerPanel = new JPanel();
        this.findButton = new WbButton();
        this.findNextButton = new WbButton();
        this.replaceNextButton = new WbButton();
        this.replaceAllButton = new WbButton();
        this.closeButton = new WbButton();
        this.replaceValue = new HistoryTextField();
        this.searchCriteria = new HistoryTextField();
        this.jPanel1 = new JPanel();
        this.ignoreCaseCheckBox = new JCheckBox();
        this.wordsOnlyCheckBox = new JCheckBox();
        this.useRegexCheckBox = new JCheckBox();
        this.selectedTextCheckBox = new JCheckBox();
        this.wrapSearchCbx = new JCheckBox();
        this.setFocusCycleRoot(true);
        this.setLayout(new GridBagLayout());
        this.criteriaLabel.setText(ResourceMgr.getString("LblSearchCriteria"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.criteriaLabel, gridBagConstraints);
        this.replaceLabel.setText(ResourceMgr.getString("LblReplaceNewValue"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 8, 0, 0);
        this.add((Component)this.replaceLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.spacerPanel, gridBagConstraints);
        this.findButton.setText(ResourceMgr.getString("LblFindNow"));
        this.findButton.setToolTipText(ResourceMgr.getString("d_LblFindNow"));
        this.findButton.setName("findbutton");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.add((Component)this.findButton, gridBagConstraints);
        this.findNextButton.setText(ResourceMgr.getString("LblFindNext"));
        this.findNextButton.setToolTipText(ResourceMgr.getString("d_LblFindNext"));
        this.findNextButton.setName("findnextbutton");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 0, 0, 5);
        this.add((Component)this.findNextButton, gridBagConstraints);
        this.replaceNextButton.setText(ResourceMgr.getString("LblReplaceNext"));
        this.replaceNextButton.setToolTipText(ResourceMgr.getString("d_LblReplaceNext"));
        this.replaceNextButton.setName("replacenextbutton");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 0, 0, 5);
        this.add((Component)this.replaceNextButton, gridBagConstraints);
        this.replaceAllButton.setText(ResourceMgr.getString("LblReplaceAll"));
        this.replaceAllButton.setToolTipText(ResourceMgr.getString("d_LblReplaceAll"));
        this.replaceAllButton.setName("replaceallbutton");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 0, 0, 5);
        this.add((Component)this.replaceAllButton, gridBagConstraints);
        this.closeButton.setText(ResourceMgr.getString("LblClose"));
        this.closeButton.setName("closebutton");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.closeButton, gridBagConstraints);
        this.replaceValue.setName("replacetext");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 8);
        this.add((Component)this.replaceValue, gridBagConstraints);
        this.searchCriteria.setName("searchtext");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 6, 0, 8);
        this.add((Component)this.searchCriteria, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.ignoreCaseCheckBox.setText(ResourceMgr.getString("LblSearchIgnoreCase"));
        this.ignoreCaseCheckBox.setToolTipText(ResourceMgr.getString("d_LblSearchIgnoreCase"));
        this.ignoreCaseCheckBox.setBorder(null);
        this.ignoreCaseCheckBox.setName("ignorecase");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.ignoreCaseCheckBox, gridBagConstraints);
        this.wordsOnlyCheckBox.setText(ResourceMgr.getString("LblSearchWordsOnly"));
        this.wordsOnlyCheckBox.setToolTipText(ResourceMgr.getString("d_LblSearchWordsOnly"));
        this.wordsOnlyCheckBox.setBorder(null);
        this.wordsOnlyCheckBox.setName("wordsonly");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(9, 0, 0, 0);
        this.jPanel1.add((Component)this.wordsOnlyCheckBox, gridBagConstraints);
        this.useRegexCheckBox.setText(ResourceMgr.getString("LblSearchRegEx"));
        this.useRegexCheckBox.setToolTipText(ResourceMgr.getString("d_LblSearchRegEx"));
        this.useRegexCheckBox.setBorder(null);
        this.useRegexCheckBox.setName("regex");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(9, 0, 0, 0);
        this.jPanel1.add((Component)this.useRegexCheckBox, gridBagConstraints);
        this.selectedTextCheckBox.setText(ResourceMgr.getString("LblSelectedTextOnly"));
        this.selectedTextCheckBox.setToolTipText(ResourceMgr.getString("d_LblSelectedTextOnly"));
        this.selectedTextCheckBox.setBorder(null);
        this.selectedTextCheckBox.setName("selectedtext");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.jPanel1.add((Component)this.selectedTextCheckBox, gridBagConstraints);
        this.wrapSearchCbx.setText(ResourceMgr.getString("LblSearchWrap"));
        this.wrapSearchCbx.setToolTipText(ResourceMgr.getString("d_LblSearchWrap"));
        this.wrapSearchCbx.setBorder(null);
        this.wrapSearchCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReplacePanel.this.wrapSearchCbxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 28, 0, 0);
        this.jPanel1.add((Component)this.wrapSearchCbx, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 7, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void wrapSearchCbxActionPerformed(ActionEvent actionEvent) {
        this.client.setWrapSearch(this.wrapSearchCbx.isSelected());
    }

    public void showReplaceDialog(Component component, String string) {
        this.showReplaceDialog(component, string, ResourceMgr.getString("TxtWindowTitleReplaceText"));
    }

    public void showReplaceDialog(Component component, String string, String string2) {
        if (this.dialog != null) {
            this.dialog.setVisible(true);
            this.dialog.requestFocus();
            return;
        }
        try {
            Window window = WbSwingUtilities.getWindowAncestor(component);
            this.dialog = null;
            if (window instanceof Frame) {
                this.dialog = new JDialog((Frame)window);
            } else if (window instanceof Dialog) {
                this.dialog = new JDialog((Dialog)window);
            }
            this.dialog.setTitle(string2);
            this.dialog.getContentPane().add(this);
            this.dialog.pack();
            this.dialog.setResizable(false);
            if (!Settings.getInstance().restoreWindowPosition(this.dialog, this.settingsKey + ".window")) {
                WbSwingUtilities.center(this.dialog, window);
            }
            this.dialog.addWindowListener(this);
            boolean bl = false;
            if (!StringUtil.isEmptyString(string) && string.indexOf(10) == -1 && string.indexOf(13) == -1) {
                ((HistoryTextField)this.searchCriteria).setText(string);
                bl = true;
            }
            this.escAction = new EscAction(this.dialog, this);
            boolean bl2 = bl;
            EventQueue.invokeLater(() -> {
                if (bl2) {
                    ((HistoryTextField)this.replaceValue).selectAll();
                    ((HistoryTextField)this.replaceValue).requestFocus();
                } else {
                    ((HistoryTextField)this.searchCriteria).selectAll();
                    ((HistoryTextField)this.searchCriteria).requestFocus();
                }
            });
            this.dialog.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        this.updateHistoryFields();
        if (object == this.findButton) {
            this.findFirst();
        } else if (object == this.findNextButton) {
            this.findNext();
        } else if (object == this.replaceNextButton) {
            this.replaceNext();
        } else if (object == this.replaceAllButton) {
            this.replaceAll();
        } else if (object == this.closeButton || actionEvent.getActionCommand().equals(this.escAction.getActionName())) {
            this.closeWindow();
        }
    }

    private void findNext() {
        try {
            this.lastPos = this.client.findNext();
            this.replaceNextButton.setEnabled(this.lastPos > -1);
            this.findNextButton.setEnabled(this.lastPos > -1);
        }
        catch (Exception exception) {
            WbSwingUtilities.showErrorMessage(this, ExceptionUtil.getDisplay(exception));
        }
    }

    private void findFirst() {
        String string = ((HistoryTextField)this.searchCriteria).getText();
        try {
            this.lastPos = this.client.findFirst(string, this.ignoreCaseCheckBox.isSelected(), this.wordsOnlyCheckBox.isSelected(), this.useRegexCheckBox.isSelected());
            this.replaceNextButton.setEnabled(this.lastPos > -1);
            this.findNextButton.setEnabled(this.lastPos > -1);
        }
        catch (Exception exception) {
            WbSwingUtilities.showErrorMessage(this, ExceptionUtil.getDisplay(exception));
        }
    }

    private void replaceNext() {
        if (this.lastPos < 0) {
            this.findFirst();
        }
        if (this.client.replaceCurrent(((HistoryTextField)this.replaceValue).getText(), this.useRegexCheckBox.isSelected())) {
            this.findNext();
        } else {
            this.replaceNextButton.setEnabled(false);
        }
    }

    private void replaceAll() {
        boolean bl = this.selectedTextCheckBox.isEnabled() && this.selectedTextCheckBox.isSelected();
        this.client.replaceAll(((HistoryTextField)this.searchCriteria).getText(), ((HistoryTextField)this.replaceValue).getText(), bl, this.ignoreCaseCheckBox.isSelected(), this.wordsOnlyCheckBox.isSelected(), this.useRegexCheckBox.isSelected());
    }

    private void closeWindow() {
        if (this.dialog != null) {
            this.saveSettings();
            this.escAction = null;
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    private void updateHistoryFields() {
        ((HistoryTextField)this.searchCriteria).storeCurrent();
        ((HistoryTextField)this.replaceValue).storeCurrent();
    }

    private void saveSettings() {
        Settings.getInstance().setProperty(this.caseProperty, Boolean.toString(this.ignoreCaseCheckBox.isSelected()));
        Settings.getInstance().setProperty(this.wordProperty, Boolean.toString(this.wordsOnlyCheckBox.isSelected()));
        Settings.getInstance().setProperty(this.selectedProperty, Boolean.toString(this.selectedTextCheckBox.isSelected()));
        Settings.getInstance().setProperty(this.regexProperty, Boolean.toString(this.useRegexCheckBox.isSelected()));
        Settings.getInstance().setProperty(this.wrapProperty, Boolean.toString(this.wrapSearchCbx.isSelected()));
        ((HistoryTextField)this.searchCriteria).saveSettings(Settings.getInstance(), this.settingsKey + ".");
        ((HistoryTextField)this.replaceValue).saveSettings(Settings.getInstance(), this.settingsKey + ".");
        Settings.getInstance().storeWindowPosition(this.dialog, this.settingsKey + ".window");
    }

    private void restoreSettings() {
        this.ignoreCaseCheckBox.setSelected(Settings.getInstance().getBoolProperty(this.caseProperty, true));
        this.wordsOnlyCheckBox.setSelected(Settings.getInstance().getBoolProperty(this.wordProperty, false));
        this.selectedTextCheckBox.setSelected(Settings.getInstance().getBoolProperty(this.selectedProperty, false));
        this.useRegexCheckBox.setSelected(Settings.getInstance().getBoolProperty(this.regexProperty, true));
        this.wrapSearchCbx.setSelected(Settings.getInstance().getBoolProperty(this.wrapProperty, false));
        ((HistoryTextField)this.searchCriteria).restoreSettings(Settings.getInstance(), this.settingsKey + ".");
        ((HistoryTextField)this.replaceValue).restoreSettings(Settings.getInstance(), this.settingsKey + ".");
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.closeWindow();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }
}

