/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.geom.RectangularShape;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import workbench.gui.components.TableRowHeader;
import workbench.gui.renderer.ToolTipRenderer;
import workbench.resource.GuiSettings;
import workbench.util.NumberStringCache;

public class RowHeaderRenderer
extends ToolTipRenderer {
    private JTable table;
    private TableRowHeader rowHeader;
    private int colWidth = -1;
    private Color backgroundColor;
    private Color textColor;

    public RowHeaderRenderer(TableRowHeader tableRowHeader, JTable jTable) {
        this.table = jTable;
        this.rowHeader = tableRowHeader;
        JTableHeader jTableHeader = this.table.getTableHeader();
        this.setFont(jTableHeader.getFont());
        this.setOpaque(true);
        this.setHorizontalAlignment(4);
        this.textColor = jTableHeader.getForeground();
        this.backgroundColor = jTableHeader.getBackground();
        this.rightMargin = GuiSettings.getRowNumberMargin();
        this.calculateWidth();
        this.setTooltip(null);
    }

    @Override
    protected void initDisplay(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
    }

    @Override
    protected Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    protected Color getForegroundColor() {
        return this.textColor;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.calculateWidth();
    }

    public final void calculateWidth() {
        Object object;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = 12;
        try {
            if (fontMetrics != null) {
                object = fontMetrics.getStringBounds("0", this.getGraphics());
                n = ((RectangularShape)object).getBounds().width;
            }
        }
        catch (Exception exception) {
            n = 12;
        }
        object = NumberStringCache.getNumberString(this.table.getRowCount());
        this.colWidth = ((String)object).length() * n + n + this.rightMargin + 1;
        try {
            TableColumn tableColumn = this.rowHeader.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(this.colWidth);
            tableColumn.setMaxWidth(this.colWidth);
            tableColumn = this.rowHeader.getTableHeader().getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(this.colWidth);
            tableColumn.setMaxWidth(this.colWidth);
            Dimension dimension = this.rowHeader.getPreferredSize();
            Dimension dimension2 = new Dimension(this.colWidth, dimension.height);
            this.rowHeader.setMaximumSize(dimension2);
            this.rowHeader.setSize(dimension2);
            this.rowHeader.setPreferredScrollableViewportSize(dimension2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void prepareDisplay(Object object) {
        try {
            this.displayValue = (String)object;
        }
        catch (Throwable throwable) {
            this.displayValue = object == null ? null : object.toString();
        }
    }
}

