/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.JTextArea;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.BadLocationException;
import workbench.gui.components.TableRowHeader;
import workbench.gui.components.WbTable;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.util.StringUtil;

public class RowHeightOptimizer {
    private WbTable table;

    public RowHeightOptimizer(WbTable wbTable) {
        this.table = wbTable;
    }

    protected void notifyRowHeader(int n) {
        EventQueue.invokeLater(() -> {
            TableRowHeader tableRowHeader = TableRowHeader.getRowHeader(this.table);
            if (tableRowHeader != null) {
                tableRowHeader.rowHeightChanged(n);
            }
        });
    }

    public void optimizeAllRows() {
        this.optimizeAllRows(GuiSettings.getAutRowHeightMaxLines());
    }

    public void optimizeAllRows(int n) {
        int n2 = this.table.getRowCount();
        if (n2 == 0) {
            return;
        }
        boolean bl = GuiSettings.getIgnoreWhitespaceForAutoRowHeight();
        for (int i = 0; i < n2; ++i) {
            this.optimizeRowHeight(i, n, bl);
        }
        EventQueue.invokeLater(() -> {
            TableRowHeader tableRowHeader = TableRowHeader.getRowHeader(this.table);
            if (tableRowHeader != null) {
                tableRowHeader.rowHeightChanged();
            }
        });
    }

    private int countWrappedLines(JTextArea jTextArea, int n) {
        String string = jTextArea.getText();
        if (StringUtil.isEmptyString(string)) {
            return 0;
        }
        int n2 = 0;
        try {
            AttributedString attributedString = new AttributedString(string);
            FontRenderContext fontRenderContext = jTextArea.getFontMetrics(jTextArea.getFont()).getFontRenderContext();
            AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
            LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
            lineBreakMeasurer.setPosition(0);
            while (lineBreakMeasurer.getPosition() < attributedCharacterIterator.getEndIndex()) {
                lineBreakMeasurer.nextLayout(n);
                ++n2;
            }
        }
        catch (Throwable throwable) {
            LogMgr.logDebug(new CallerInfo(){}, "Error when counting lines", throwable);
            n2 = 1;
        }
        return n2;
    }

    public int countVisibleLines(JTextArea jTextArea, FontMetrics fontMetrics, int n) {
        int n2;
        String string = jTextArea.getText();
        if (StringUtil.isEmptyString(string)) {
            return 0;
        }
        int n3 = fontMetrics.getHeight();
        try {
            int n4 = jTextArea.modelToView((int)(string.length() - 1)).y;
            n2 = n4 / n3 + 1;
        }
        catch (Throwable throwable) {
            LogMgr.logDebug(new CallerInfo(){}, "Error when counting lines", throwable);
            n2 = this.countWrappedLines(jTextArea, n - 32);
        }
        return n2;
    }

    private void optimizeRowHeight(int n, int n2, boolean bl) {
        int n3;
        int n4 = this.table.getColumnCount();
        int n5 = n3 = this.table.getRowHeight();
        for (int i = 0; i < n4; ++i) {
            int n6;
            TableCellRenderer tableCellRenderer = this.table.getCellRenderer(n, i);
            Component component = tableCellRenderer.getTableCellRendererComponent(this.table, this.table.getValueAt(n, i), false, false, n, i);
            Font font = component.getFont();
            FontMetrics fontMetrics = component.getFontMetrics(font);
            int n7 = 1;
            if (component instanceof JTextArea) {
                JTextArea jTextArea = (JTextArea)component;
                n6 = this.table.getColumnModel().getColumn(i).getPreferredWidth();
                Dimension dimension = jTextArea.getPreferredSize();
                dimension.setSize(n6, dimension.height);
                jTextArea.setSize(dimension);
                jTextArea.setPreferredSize(dimension);
                jTextArea.setMaximumSize(dimension);
                if (bl) {
                    n7 = this.getLineCount(jTextArea);
                } else {
                    n7 = jTextArea.getLineCount();
                    if (n7 == 1 && jTextArea.getLineWrap()) {
                        n7 = this.countVisibleLines(jTextArea, fontMetrics, n6);
                    }
                }
            }
            if (n7 > n2) {
                n7 = n2;
            }
            int n8 = fontMetrics == null ? 16 : fontMetrics.getHeight();
            n6 = n7 * n8;
            n5 = Math.max(n5, n6);
        }
        if (n5 > 0 && n5 != this.table.getRowHeight(n)) {
            this.table.setRowHeight(n, n5);
        }
    }

    private int getLineCount(JTextArea jTextArea) {
        int n = jTextArea.getLineCount();
        if (n < 1) {
            return n;
        }
        int n2 = n;
        try {
            boolean bl = false;
            while (n2 > 0 && !bl) {
                int n3;
                int n4;
                String string;
                if (StringUtil.isBlank(string = jTextArea.getText(n4 = jTextArea.getLineStartOffset(--n2), (n3 = jTextArea.getLineEndOffset(n2)) - n4))) {
                    bl = false;
                    continue;
                }
                bl = true;
            }
        }
        catch (BadLocationException badLocationException) {
            LogMgr.logError(new CallerInfo(){}, "Error when calculating lines", badLocationException);
            return n;
        }
        return n2 + 1;
    }
}

