/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.event.MouseInputAdapter;
import workbench.gui.components.TableRowHeader;

public class RowHeightResizer
extends MouseInputAdapter {
    private JTable table;
    private boolean active;
    private boolean rowSelectionAllowed;
    private int row;
    private int startY;
    private int startHeight;
    private static final int PIXELS = 5;
    private Cursor lastCursor;
    private static Cursor resizeCursor = Cursor.getPredefinedCursor(9);

    public RowHeightResizer(JTable jTable) {
        this.table = jTable;
        this.table.addMouseListener(this);
        this.table.addMouseMotionListener(this);
        this.row = -1;
    }

    public void done() {
        if (this.table == null) {
            return;
        }
        this.table.removeMouseListener(this);
        this.table.removeMouseMotionListener(this);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (this.isMouseOverRowMargin(point)) {
            if (this.lastCursor == null) {
                this.lastCursor = this.table.getCursor();
            }
            this.table.setCursor(resizeCursor);
        } else {
            this.table.setCursor(this.lastCursor);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (this.isMouseOverRowMargin(point)) {
            this.active = true;
            this.startY = point.y;
            this.startHeight = this.table.getRowHeight(this.row);
            this.rowSelectionAllowed = this.table.getRowSelectionAllowed();
            this.table.setRowSelectionAllowed(false);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.active) {
            return;
        }
        int n = this.startHeight + mouseEvent.getY() - this.startY;
        n = Math.max(1, n);
        this.table.setRowHeight(this.row, n);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TableRowHeader tableRowHeader = TableRowHeader.getRowHeader(RowHeightResizer.this.table);
                if (tableRowHeader != null) {
                    tableRowHeader.rowHeightChanged(RowHeightResizer.this.row);
                }
            }
        });
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.active) {
            return;
        }
        this.table.setRowSelectionAllowed(this.rowSelectionAllowed);
        this.active = false;
        this.row = -1;
    }

    private boolean isMouseOverRowMargin(Point point) {
        if (!this.table.isEnabled()) {
            return false;
        }
        this.row = this.table.rowAtPoint(point);
        int n = this.table.columnAtPoint(point);
        if (this.row == -1 || n == -1) {
            return false;
        }
        Rectangle rectangle = this.table.getCellRect(this.row, n, true);
        return point.y >= rectangle.y + rectangle.height - 5;
    }
}

